/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.datasource;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Props;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.lang.Nullable;

public class DsUtils {
    public static final String[] DEFAULT_CLASS_PROP_NAMES = new String[]{"@type", "type", "class", "dataSourceClassName"};

    private static Class<?> resolveTypeOrNull(Properties props, String[] typePropNames) {
        String typeStr = Utils.propertyOr(props, typePropNames);
        if (Utils.isNotEmpty(typeStr)) {
            Utils.propertyRemove(props, typePropNames);
            Class<?> typeClz = ClassUtil.loadClass(typeStr);
            if (typeClz == null || !DataSource.class.isAssignableFrom(typeClz)) {
                throw new IllegalStateException("Type configuration not is data source");
            }
            return typeClz;
        }
        return null;
    }

    private static Class<?> resolveTypeOrDefault(Properties props, Class<?> typeDef, String[] typePropNames) {
        String typeStr = Utils.propertyOr(props, typePropNames);
        Class<?> typeClz = null;
        if (Utils.isEmpty(typeStr)) {
            typeClz = typeDef;
        } else {
            Utils.propertyRemove(props, typePropNames);
            typeClz = ClassUtil.loadClass(typeStr);
        }
        if (typeClz == null || !DataSource.class.isAssignableFrom(typeClz)) {
            throw new IllegalStateException("Type configuration not is data source");
        }
        return typeClz;
    }

    private static DataSource convertDo(Properties props, Class<?> typeClz) {
        return (DataSource)PropsConverter.global().convert(props, typeClz);
    }

    public static DataSource buildDs(Properties props) {
        return DsUtils.buildDs(props, null, DEFAULT_CLASS_PROP_NAMES);
    }

    public static DataSource buildDs(Properties props, Class<?> typeDef) {
        return DsUtils.buildDs(props, typeDef, DEFAULT_CLASS_PROP_NAMES);
    }

    public static DataSource buildDs(Properties props, String[] typePropNames) {
        return DsUtils.buildDs(props, null, typePropNames);
    }

    public static DataSource buildDs(Properties props, Class<?> typeDef, String[] typePropNames) {
        Class<?> typeClz = DsUtils.resolveTypeOrDefault(props, typeDef, typePropNames);
        return DsUtils.convertDo(props, typeClz);
    }

    public static Map<String, DataSource> buildDsMap(Properties props) {
        return DsUtils.buildDsMap(props, DEFAULT_CLASS_PROP_NAMES);
    }

    public static Map<String, DataSource> buildDsMap(Properties props, Class<?> typeDef) {
        return DsUtils.buildDsMap(props, typeDef, DEFAULT_CLASS_PROP_NAMES);
    }

    public static Map<String, DataSource> buildDsMap(Properties props, String[] typePropNames) {
        Class<?> typeClz = DsUtils.resolveTypeOrNull(props, typePropNames);
        return DsUtils.buildDsMap(props, typeClz, typePropNames);
    }

    public static Map<String, DataSource> buildDsMap(Properties props, @Nullable Class<?> typeDef, String[] typePropNames) {
        Props rootProps;
        if (props instanceof Props) {
            rootProps = (Props)props;
        } else {
            rootProps = new Props();
            rootProps.putAll((Map<?, ?>)props);
        }
        Map<String, Props> groupProps = rootProps.getGroupedProp("");
        if (groupProps.size() == 0) {
            throw new IllegalStateException("Missing data source configuration");
        }
        LinkedHashMap<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
        for (Map.Entry<String, Props> kv : groupProps.entrySet()) {
            if (kv.getValue().size() <= 1) continue;
            Class<?> typeClz = DsUtils.resolveTypeOrDefault(kv.getValue(), typeDef, typePropNames);
            DataSource source = DsUtils.convertDo(kv.getValue(), typeClz);
            dataSourceMap.put(kv.getKey(), source);
        }
        return dataSourceMap;
    }

    public static void observeDs(AppContext context, String dsName, Consumer<BeanWrap> consumer) {
        if (Utils.isEmpty(dsName)) {
            context.getWrapAsync(DataSource.class, dsBw -> consumer.accept((BeanWrap)dsBw));
        } else {
            context.getWrapAsync(dsName, dsBw -> {
                if (dsBw.raw() instanceof DataSource) {
                    consumer.accept((BeanWrap)dsBw);
                }
            });
        }
    }
}

