/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging.integration;

import java.util.Properties;
import java.util.function.BiConsumer;
import org.noear.solon.Solon;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.logging.AppenderManager;
import org.noear.solon.logging.LogOptions;
import org.noear.solon.logging.event.Appender;
import org.slf4j.MDC;

public class LoggingPlugin
implements Plugin {
    public LoggingPlugin() {
        AppenderManager.init();
    }

    @Override
    public void start(AppContext context) {
        Props props = Solon.cfg().getProp("solon.logging.appender");
        AppenderManager.init();
        if (((Properties)props).size() > 0) {
            ((Properties)props).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                Appender appender;
                String key = (String)k;
                String val = (String)v;
                if (key.endsWith(".class") && (appender = (Appender)ClassUtil.tryInstance(val)) != null) {
                    String name = key.substring(0, key.length() - 6);
                    AppenderManager.register(name, appender);
                }
            }));
        }
        LogOptions.getLoggerLevelInit();
        Solon.app().filter(Integer.MIN_VALUE, (ctx, chain) -> {
            if (ctx.path() != null && ctx.path().equals(ctx.pathNew())) {
                MDC.clear();
            }
            chain.doFilter(ctx);
        });
    }

    @Override
    public void stop() throws Throwable {
        AppenderManager.stop();
    }
}

