/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.socketd.handle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.entity.FileEntity;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.web.AsyncContextState;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.handle.DownloadedFile;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.net.socketd.handle.SocketdSessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketdContext
extends ContextEmpty {
    static final Logger log = LoggerFactory.getLogger(SocketdContext.class);
    private Session _session;
    private Message _request;
    private EntityDefault _response;
    private URI _uri;
    private String path;
    private InputStream bodyAsStream;
    protected final AsyncContextState asyncState = new AsyncContextState();

    public SocketdContext(Session session, Message message) throws IOException {
        this._session = session;
        this._request = message;
        this._response = new EntityDefault();
        if (session.handshake().paramMap().size() > 0) {
            this.headerMap().putAll(session.handshake().paramMap());
        }
        if (Utils.isNotEmpty(message.metaString())) {
            this.headerMap().putAll(message.metaMap());
        }
        this.sessionState = new SocketdSessionState(this._session);
    }

    protected Session session() {
        return this._session;
    }

    protected Message message() {
        return this._request;
    }

    @Override
    public Object request() {
        return this._request;
    }

    @Override
    public String remoteIp() {
        try {
            return this._session.remoteAddress().getAddress().toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int remotePort() {
        try {
            return this._session.remoteAddress().getPort();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean isMultipart() {
        return false;
    }

    @Override
    public String method() {
        return MethodType.SOCKET.name;
    }

    @Override
    public String protocol() {
        return this._session.handshake().uri().getScheme();
    }

    @Override
    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    @Override
    public String url() {
        return this._request.event();
    }

    @Override
    public String path() {
        if (this.path == null && this.url() != null) {
            this.path = this.uri().getPath();
            if (this.path == null) {
                this.path = "";
            }
            if (this.path.contains("//")) {
                this.path = Utils.trimDuplicates(this.path, '/');
            }
        }
        return this.path;
    }

    @Override
    public long contentLength() {
        return this._request.dataSize();
    }

    @Override
    public String contentType() {
        return this.header("Content-Type");
    }

    @Override
    public String queryString() {
        return this.uri().getQuery();
    }

    @Override
    public InputStream bodyAsStream() throws IOException {
        if (this.bodyAsStream == null) {
            this.bodyAsStream = new ByteArrayInputStream(this._request.dataAsBytes());
        }
        return this.bodyAsStream;
    }

    @Override
    public Object response() {
        return this._session;
    }

    @Override
    public void contentType(String contentType) {
        this.headerSet("Content-Type", contentType);
    }

    @Override
    public void headerSet(String key, String val) {
        this._response.metaPut(key, val);
    }

    @Override
    public void headerAdd(String key, String val) {
        this._response.metaPut(key, val);
    }

    @Override
    public String headerOfResponse(String name) {
        return this._response.meta(name);
    }

    @Override
    public void outputAsFile(File file) throws IOException {
        String fileName = URLEncoder.encode(file.getName(), Solon.encoding());
        String contentType = Utils.mime(file.getName());
        this.headerSet("Data-Disposition-Filename", fileName);
        this.contentType(contentType);
        long len = file.length();
        FileEntity fileEntity = new FileEntity(file);
        this.replyDo(fileEntity.data(), (int)len);
        fileEntity.release();
    }

    @Override
    public void outputAsFile(DownloadedFile file) throws IOException {
        String fileName = URLEncoder.encode(file.getName(), Solon.encoding());
        this.headerSet("Data-Disposition-Filename", fileName);
        this.contentType(file.getContentType());
        byte[] bytes = IoUtil.transferToBytes(file.getContent());
        this.replyDo(ByteBuffer.wrap(bytes), (int)file.getContentSize());
    }

    protected void innerCommit() throws IOException {
        if (this.getHandled() || this.status() >= 200) {
            ByteArrayOutputStream out = (ByteArrayOutputStream)this.outputStream();
            this.replyDo(ByteBuffer.wrap(out.toByteArray()), out.size());
        } else {
            this._session.sendAlarm(this._request, "No event handler was found! like code=404");
        }
    }

    private void replyDo(ByteBuffer dataStream, int dataSize) throws IOException {
        this.sendHandlers();
        if (this._request.isRequest() || this._request.isSubscribe()) {
            this._response.dataSet(dataStream);
            this._session.replyEnd(this._request, (Entity)this._response);
        } else if (dataSize > 0) {
            log.warn("No reply is supported for the current message, sid={}", (Object)this._request.sid());
        }
    }

    @Override
    public void close() throws IOException {
        this._session.close();
    }

    @Override
    public boolean asyncSupported() {
        return true;
    }

    @Override
    public boolean asyncStarted() {
        return this.asyncState.isStarted;
    }

    @Override
    public void asyncListener(ContextAsyncListener listener) {
        this.asyncState.addListener(listener);
    }

    @Override
    public void asyncStart(long timeout, Runnable runnable) {
        if (!this.asyncState.isStarted) {
            this.asyncState.isStarted = true;
            this.asyncState.asyncDelay(timeout, this, this::innerCommit);
            if (runnable != null) {
                runnable.run();
            }
            this.asyncState.onStart(this);
        }
    }

    @Override
    public void asyncComplete() {
        if (this.asyncState.isStarted) {
            try {
                this.innerCommit();
            }
            catch (Throwable e) {
                log.warn("Async completion failed", e);
                this.asyncState.onError(this, e);
            }
            finally {
                this.asyncState.onComplete(this);
            }
        }
    }
}

