/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.socketd.handle;

import java.io.IOException;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.listener.EventListener;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.net.socketd.handle.SocketdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToHandlerListener
extends EventListener {
    private static final Logger log = LoggerFactory.getLogger(ToHandlerListener.class);

    public ToHandlerListener() {
        this.doOnMessage(this::onMessageDo);
    }

    protected void onMessageDo(Session session, Message message) throws IOException {
        if (Utils.isEmpty(message.event())) {
            log.warn("This message is missing route, sid={}", (Object)message.sid());
            return;
        }
        this.handle0(new SocketdContext(session, message));
    }

    protected void handle0(SocketdContext ctx) {
        block5: {
            try {
                Solon.app().tryHandle(ctx);
                if (!ctx.asyncStarted()) {
                    ctx.innerCommit();
                }
            }
            catch (Throwable e) {
                log.warn(e.getMessage(), e);
                if (!ctx.session().isValid()) break block5;
                try {
                    ctx.session().sendAlarm(ctx.message(), e.getMessage());
                }
                catch (Throwable err) {
                    this.onError(ctx.session(), err);
                }
            }
        }
    }
}

