/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.socketd.listener;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.solon.core.util.PathMatcher;
import org.noear.solon.core.util.PathUtil;

public class ExpressListener
implements Listener {
    private Listener listener;
    private PathMatcher pathAnalyzer;
    private List<String> pathKeys;

    public ExpressListener(String path, Listener listener) {
        this.listener = listener;
        if (path != null && path.indexOf("{") >= 0) {
            path = PathUtil.mergePath(null, path);
            this.pathKeys = new ArrayList<String>();
            Matcher pm = PathUtil.pathKeyExpr.matcher(path);
            while (pm.find()) {
                this.pathKeys.add(pm.group(1));
            }
            if (this.pathKeys.size() > 0) {
                this.pathAnalyzer = PathMatcher.get(path);
            }
        }
    }

    public void onOpen(Session s2) throws IOException {
        Matcher pm;
        if (this.pathAnalyzer != null && (pm = this.pathAnalyzer.matcher(s2.path())).find()) {
            int len = this.pathKeys.size();
            for (int i = 0; i < len; ++i) {
                s2.handshake().paramPut(this.pathKeys.get(i), pm.group(i + 1));
            }
        }
        this.listener.onOpen(s2);
    }

    public void onMessage(Session s2, Message m4) throws IOException {
        this.listener.onMessage(s2, m4);
    }

    public void onClose(Session s2) {
        this.listener.onClose(s2);
    }

    public void onError(Session s2, Throwable e) {
        this.listener.onError(s2, e);
    }
}

