/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket.listener;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.listener.SimpleWebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextPathWebSocketListener
extends SimpleWebSocketListener {
    private static final Logger log = LoggerFactory.getLogger(ContextPathWebSocketListener.class);
    private final String contextPath0;
    private final String contextPath1;
    private final boolean forced;

    public ContextPathWebSocketListener() {
        this(Solon.cfg().serverContextPath(), Solon.cfg().serverContextPathForced());
    }

    public ContextPathWebSocketListener(String contextPath, boolean forced) {
        this.forced = forced;
        if (Utils.isEmpty(contextPath)) {
            this.contextPath0 = null;
            this.contextPath1 = null;
        } else {
            String newPath = null;
            newPath = contextPath.endsWith("/") ? contextPath : contextPath + "/";
            this.contextPath1 = newPath.startsWith("/") ? newPath : "/" + newPath;
            this.contextPath0 = this.contextPath1.substring(0, this.contextPath1.length() - 1);
        }
    }

    @Override
    public void onOpen(WebSocket s2) {
        if (this.contextPath0 != null) {
            if (s2.path().equals(this.contextPath0)) {
                s2.pathNew("/");
            } else if (s2.path().startsWith(this.contextPath1)) {
                s2.pathNew(s2.path().substring(this.contextPath1.length() - 1));
            } else if (this.forced) {
                try {
                    s2.close();
                }
                catch (Exception e) {
                    log.warn("ContextPathListener onOpen failed!", e);
                }
            }
        }
    }
}

