/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket.listener;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.noear.solon.core.util.PathMatcher;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketListener;

public class ExpressWebSocketListener
implements WebSocketListener {
    private WebSocketListener listener;
    private PathMatcher pathAnalyzer;
    private List<String> pathKeys;

    public ExpressWebSocketListener(String path, WebSocketListener listener) {
        this.listener = listener;
        if (path != null && path.indexOf("{") >= 0) {
            path = PathUtil.mergePath(null, path);
            this.pathKeys = new ArrayList<String>();
            Matcher pm = PathUtil.pathKeyExpr.matcher(path);
            while (pm.find()) {
                this.pathKeys.add(pm.group(1));
            }
            if (this.pathKeys.size() > 0) {
                this.pathAnalyzer = PathMatcher.get(path);
            }
        }
    }

    public WebSocketListener getListener() {
        return this.listener;
    }

    @Override
    public void onOpen(WebSocket s2) {
        Matcher pm;
        if (this.pathAnalyzer != null && (pm = this.pathAnalyzer.matcher(s2.path())).find()) {
            int len = this.pathKeys.size();
            for (int i = 0; i < len; ++i) {
                s2.param(this.pathKeys.get(i), pm.group(i + 1));
            }
        }
        this.listener.onOpen(s2);
    }

    @Override
    public void onMessage(WebSocket s2, String text) throws IOException {
        this.listener.onMessage(s2, text);
    }

    @Override
    public void onMessage(WebSocket s2, ByteBuffer binary) throws IOException {
        this.listener.onMessage(s2, binary);
    }

    @Override
    public void onClose(WebSocket s2) {
        this.listener.onClose(s2);
    }

    @Override
    public void onError(WebSocket s2, Throwable e) {
        this.listener.onError(s2, e);
    }

    @Override
    public void onPing(WebSocket s2) {
        this.listener.onPing(s2);
    }

    @Override
    public void onPong(WebSocket s2) {
        this.listener.onPong(s2);
    }
}

