/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket.listener;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.route.RoutingDefault;
import org.noear.solon.core.route.RoutingTable;
import org.noear.solon.core.route.RoutingTableDefault;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketListener;
import org.noear.solon.net.websocket.listener.ExpressWebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathWebSocketListener
implements WebSocketListener {
    static final Logger log = LoggerFactory.getLogger(PathWebSocketListener.class);
    private final RoutingTable<WebSocketListener> routingTable = new RoutingTableDefault<WebSocketListener>();
    private final boolean autoClose;

    public PathWebSocketListener() {
        this(false);
    }

    public PathWebSocketListener(boolean autoClose) {
        this.autoClose = autoClose;
    }

    public int count() {
        return this.routingTable.count();
    }

    public PathWebSocketListener of(String path, int index, WebSocketListener listener) {
        ExpressWebSocketListener lh = new ExpressWebSocketListener(path, listener);
        RoutingDefault<ExpressWebSocketListener> routing = new RoutingDefault<ExpressWebSocketListener>(path, MethodType.SOCKET, index, lh);
        this.routingTable.add(routing);
        return this;
    }

    public PathWebSocketListener of(String path, WebSocketListener listener) {
        return this.of(path, 0, listener);
    }

    public PathWebSocketListener remove(String path) {
        this.routingTable.remove(path);
        return this;
    }

    public WebSocketListener matching(WebSocket s2) {
        if (s2 == null) {
            return null;
        }
        String path = s2.path();
        return this.matching(path);
    }

    public WebSocketListener matching(String path) {
        if (path == null) {
            return null;
        }
        return this.routingTable.matchOne(path, MethodType.SOCKET);
    }

    @Override
    public void onOpen(WebSocket s2) {
        WebSocketListener l1 = this.matching(s2);
        if (l1 != null) {
            l1.onOpen(s2);
        } else if (this.autoClose) {
            s2.close();
            log.warn("Route failed. The connection will close. path={}", (Object)s2.path());
        }
    }

    @Override
    public void onMessage(WebSocket s2, String text) throws IOException {
        WebSocketListener l1 = this.matching(s2);
        if (l1 != null) {
            l1.onMessage(s2, text);
        }
    }

    @Override
    public void onMessage(WebSocket s2, ByteBuffer binary) throws IOException {
        WebSocketListener l1 = this.matching(s2);
        if (l1 != null) {
            l1.onMessage(s2, binary);
        }
    }

    @Override
    public void onClose(WebSocket s2) {
        WebSocketListener l1 = this.matching(s2);
        if (l1 != null) {
            l1.onClose(s2);
        }
    }

    @Override
    public void onError(WebSocket s2, Throwable error) {
        WebSocketListener l1 = this.matching(s2);
        if (l1 != null) {
            l1.onError(s2, error);
        }
    }

    @Override
    public void onPing(WebSocket s2) {
        WebSocketListener l1 = this.matching(s2);
        if (l1 != null) {
            l1.onPing(s2);
        }
    }

    @Override
    public void onPong(WebSocket s2) {
        WebSocketListener l1 = this.matching(s2);
        if (l1 != null) {
            l1.onPong(s2);
        }
    }
}

