/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.scheduled.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.scheduling.ScheduledException;
import org.noear.solon.scheduling.annotation.Scheduled;
import org.noear.solon.scheduling.scheduled.JobHandler;
import org.noear.solon.scheduling.scheduled.JobHolder;
import org.noear.solon.scheduling.scheduled.JobInterceptor;
import org.noear.solon.scheduling.scheduled.manager.IJobManager;

public abstract class AbstractJobManager
implements IJobManager {
    protected final Map<String, JobHolder> jobMap = new HashMap<String, JobHolder>();
    protected final List<RankEntity<JobInterceptor>> jobInterceptorNodes = new ArrayList<RankEntity<JobInterceptor>>();
    protected boolean isStarted = false;

    public AbstractJobManager() {
        Solon.context().subWrapsOfType(JobInterceptor.class, bw -> this.addJobInterceptor(bw.index(), (JobInterceptor)bw.raw()));
    }

    @Override
    public void addJobInterceptor(int index, JobInterceptor jobInterceptor) {
        this.jobInterceptorNodes.add(new RankEntity<JobInterceptor>(jobInterceptor, index));
        this.jobInterceptorNodes.sort(Comparator.comparingInt(f -> f.index));
    }

    @Override
    public boolean hasJobInterceptor() {
        return this.jobInterceptorNodes.size() > 0;
    }

    @Override
    public List<RankEntity<JobInterceptor>> getJobInterceptors() {
        return Collections.unmodifiableList(this.jobInterceptorNodes);
    }

    @Override
    public JobHolder jobAdd(String name, Scheduled scheduled, JobHandler handler) {
        JobHolder jobHolder;
        this.jobAddCheckDo(name, scheduled);
        if (this.jobExists(name)) {
            jobHolder = this.jobMap.get(name);
        } else {
            jobHolder = this.jobWrapDo(name, scheduled, handler);
            this.jobMap.put(name, jobHolder);
        }
        if (this.isStarted()) {
            this.jobStart(name, null);
        }
        return jobHolder;
    }

    protected JobHolder jobWrapDo(String name, Scheduled scheduled, JobHandler handler) {
        return new JobHolder(this, name, scheduled, handler);
    }

    protected void jobAddCheckDo(String name, Scheduled scheduled) {
        if (Utils.isEmpty(name)) {
            throw new IllegalArgumentException("The job name cannot be empty!");
        }
        if (scheduled.fixedDelay() > 0L && scheduled.fixedRate() > 0L) {
            if (Utils.isEmpty(scheduled.cron())) {
                throw new IllegalArgumentException("The job fixedDelay and fixedRate cannot both have values: " + name);
            }
            throw new IllegalArgumentException("The job cron and fixedDelay and fixedRate cannot both have values: " + name);
        }
    }

    @Override
    public boolean jobExists(String name) {
        return this.jobMap.containsKey(name);
    }

    @Override
    public JobHolder jobGet(String name) {
        return this.jobMap.get(name);
    }

    @Override
    public Map<String, JobHolder> jobGetAll() {
        return Collections.unmodifiableMap(this.jobMap);
    }

    @Override
    public void jobRemove(String name) throws ScheduledException {
        this.jobStop(name);
        this.jobMap.remove(name);
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }
}

