/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.prop;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import org.noear.solon.Utils;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.prop.JsonProps;

public class JsonPropsUtil {
    @Deprecated
    public static boolean apply(JsonRenderFactory factory, JsonProps jsonProps) {
        if (jsonProps == null) {
            return false;
        }
        JsonPropsUtil.dateAsFormat(factory, jsonProps);
        JsonPropsUtil.dateAsTicks(factory, jsonProps);
        JsonPropsUtil.boolAsInt(factory, jsonProps);
        return true;
    }

    public static void boolAsInt(JsonRenderFactory factory, JsonProps jsonProps) {
        if (jsonProps == null) {
            return;
        }
        if (jsonProps.boolAsInt) {
            factory.addConvertor(Boolean.class, e -> e != false ? 1 : 0);
            factory.addConvertor(Boolean.TYPE, e -> e != false ? 1 : 0);
        }
    }

    public static void longAsString(JsonRenderFactory factory, JsonProps jsonProps) {
        if (jsonProps == null) {
            return;
        }
        if (jsonProps.longAsString) {
            factory.addConvertor(Long.class, String::valueOf);
            factory.addConvertor(Long.TYPE, String::valueOf);
        }
    }

    public static void dateAsTicks(JsonRenderFactory factory, JsonProps jsonProps) {
        if (jsonProps == null) {
            return;
        }
        if (jsonProps.dateAsTicks) {
            factory.addConvertor(Date.class, d -> {
                if (jsonProps.longAsString) {
                    return String.valueOf(d.getTime());
                }
                return d.getTime();
            });
        }
    }

    public static void dateAsFormat(JsonRenderFactory factory, JsonProps jsonProps) {
        if (jsonProps == null) {
            return;
        }
        if (Utils.isNotEmpty(jsonProps.dateAsFormat)) {
            factory.addConvertor(Date.class, e -> {
                SimpleDateFormat df = new SimpleDateFormat(jsonProps.dateAsFormat);
                if (Utils.isNotEmpty(jsonProps.dateAsTimeZone)) {
                    df.setTimeZone(TimeZone.getTimeZone(ZoneId.of(jsonProps.dateAsTimeZone)));
                }
                return df.format((Date)e);
            });
            factory.addConvertor(OffsetDateTime.class, e -> {
                DateTimeFormatter df = DateTimeFormatter.ofPattern(jsonProps.dateAsFormat);
                if (Utils.isNotEmpty(jsonProps.dateAsTimeZone)) {
                    df.withZone(ZoneId.of(jsonProps.dateAsTimeZone));
                }
                return e.format(df);
            });
            factory.addConvertor(ZonedDateTime.class, e -> {
                DateTimeFormatter df = DateTimeFormatter.ofPattern(jsonProps.dateAsFormat);
                if (Utils.isNotEmpty(jsonProps.dateAsTimeZone)) {
                    df.withZone(ZoneId.of(jsonProps.dateAsTimeZone));
                }
                return e.format(df);
            });
            factory.addConvertor(LocalDateTime.class, e -> JsonPropsUtil.formatLocalDateTime(e, jsonProps));
            factory.addConvertor(LocalDate.class, e -> JsonPropsUtil.formatLocalDateTime(e.atStartOfDay(), jsonProps));
        }
    }

    private static String formatLocalDateTime(LocalDateTime e, JsonProps jsonProps) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(jsonProps.dateAsFormat);
        if (Utils.isNotEmpty(jsonProps.dateAsTimeZone)) {
            df.withZone(ZoneId.of(jsonProps.dateAsTimeZone));
        }
        return e.format(df);
    }
}

