/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.snack3;

import org.noear.snack.core.Feature;
import org.noear.snack.core.Options;
import org.noear.solon.core.handle.Render;
import org.noear.solon.serialization.StringSerializerRender;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil;
import org.noear.solon.serialization.snack3.SnackRenderFactoryBase;

public class SnackRenderFactory
extends SnackRenderFactoryBase {
    public SnackRenderFactory(JsonProps jsonProps) {
        this.serializer.setConfig(Options.def());
        this.addFeatures(Feature.EnumUsingName);
        this.applyProps(jsonProps);
    }

    @Override
    public String[] mappings() {
        return new String[]{"@json"};
    }

    @Override
    public Render create() {
        return new StringSerializerRender(false, this.serializer);
    }

    public void setFeatures(Feature ... features) {
        this.config().setFeatures(features);
    }

    public void addFeatures(Feature ... features) {
        this.config().add(features);
    }

    public void removeFeatures(Feature ... features) {
        this.config().remove(features);
    }

    protected void applyProps(JsonProps jsonProps) {
        if (jsonProps != null) {
            JsonPropsUtil.dateAsFormat(this, jsonProps);
            JsonPropsUtil.dateAsTicks(this, jsonProps);
            JsonPropsUtil.boolAsInt(this, jsonProps);
            JsonPropsUtil.longAsString(this, jsonProps);
            if (jsonProps.nullStringAsEmpty) {
                this.addFeatures(Feature.StringNullAsEmpty);
            }
            if (jsonProps.nullBoolAsFalse) {
                this.addFeatures(Feature.BooleanNullAsFalse);
            }
            if (jsonProps.nullNumberAsZero) {
                this.addFeatures(Feature.NumberNullAsZero);
            }
            if (jsonProps.nullArrayAsEmpty) {
                this.addFeatures(Feature.ArrayNullAsEmpty);
            }
            if (jsonProps.nullAsWriteable) {
                this.addFeatures(Feature.SerializeNulls);
            }
            if (jsonProps.enumAsName) {
                this.addFeatures(Feature.EnumUsingName);
            }
        }
    }
}

