/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.snack3;

import java.io.IOException;
import java.lang.reflect.Type;
import org.noear.snack.ONode;
import org.noear.snack.core.Options;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.ContextSerializer;

public class SnackStringSerializer
implements ContextSerializer<String> {
    private static final String label = "/json";
    private Options config;

    public Options getConfig() {
        if (this.config == null) {
            this.config = Options.def();
        }
        return this.config;
    }

    public void setConfig(Options config) {
        if (config != null) {
            this.config = config;
        }
    }

    @Override
    public String mimeType() {
        return "application/json";
    }

    @Override
    public Class<String> dataType() {
        return String.class;
    }

    @Override
    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label) || mime.startsWith("application/x-ndjson");
    }

    @Override
    public String name() {
        return "snack3-json";
    }

    @Override
    public String serialize(Object obj) throws IOException {
        return ONode.loadObj(obj, this.getConfig()).toJson();
    }

    @Override
    public Object deserialize(String data, Type toType) throws IOException {
        if (toType == null) {
            return ONode.loadStr(data, this.getConfig());
        }
        return ONode.loadStr(data, this.getConfig()).toObject(toType);
    }

    @Override
    public void serializeToBody(Context ctx, Object data) throws IOException {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    @Override
    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty(data)) {
            return ONode.loadStr(data, this.getConfig());
        }
        return null;
    }
}

