/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.local;

import java.io.IOException;
import java.util.Collection;
import org.noear.solon.Utils;
import org.noear.solon.boot.web.SessionStateBase;
import org.noear.solon.core.handle.Context;
import org.noear.solon.sessionstate.local.ScheduledStore;

public class LocalSessionState
extends SessionStateBase {
    private static ScheduledStore _store = new ScheduledStore(_expiry);
    private String sessionId;

    protected LocalSessionState(Context ctx) {
        super(ctx);
    }

    @Override
    public boolean replaceable() {
        return false;
    }

    @Override
    public long creationTime() {
        return _store.creationTime(this.sessionId());
    }

    @Override
    public long lastAccessTime() {
        return _store.lastAccessTime(this.sessionId());
    }

    @Override
    public String sessionId() {
        if (this.sessionId == null) {
            this.sessionId = this.sessionIdGet(false);
        }
        return this.sessionId;
    }

    @Override
    public String sessionChangeId() {
        this.sessionId = this.sessionIdGet(true);
        return this.sessionId;
    }

    @Override
    public Collection<String> sessionKeys() {
        return _store.getKeys(this.sessionId());
    }

    @Override
    public <T> T sessionGet(String key, Class<T> clz) {
        return (T)_store.get(this.sessionId(), key);
    }

    @Override
    public void sessionSet(String key, Object val) {
        if (val == null) {
            this.sessionRemove(key);
        } else {
            _store.put(this.sessionId(), key, val);
        }
    }

    @Override
    public void sessionRemove(String key) {
        _store.remove(this.sessionId(), key);
    }

    @Override
    public void sessionClear() {
        _store.clear(this.sessionId());
    }

    @Override
    public void sessionReset() {
        this.sessionClear();
        this.sessionChangeId();
    }

    @Override
    public void sessionRefresh() {
        this.sessionIdPush();
    }

    @Override
    public void sessionPublish() throws IOException {
        String sid = this.sessionId();
        if (!Utils.isEmpty(sid)) {
            _store.updateAccessedTime(sid);
        }
    }
}

