/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.local;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.noear.solon.core.util.RunUtil;

class ScheduledStore {
    private int _defaultSeconds;
    private Map<String, Entity> _data = new ConcurrentHashMap<String, Entity>();

    public ScheduledStore(int seconds) {
        this._defaultSeconds = seconds;
    }

    public void put(String block, String key, Object obj) {
        Entity ent = this._data.computeIfAbsent(block, k -> new Entity((String)k));
        ent.map.put(key, obj);
    }

    public Object get(String block, String key) {
        Entity ent = this._data.get(block);
        if (ent != null) {
            return ent.map.get(key);
        }
        return null;
    }

    public Collection<String> getKeys(String block) {
        Entity ent = this._data.get(block);
        if (ent != null) {
            return ent.map.keySet();
        }
        return null;
    }

    public void remove(String block, String key) {
        Entity ent = this._data.get(block);
        if (ent != null) {
            ent.map.remove(key);
        }
    }

    public void clear(String block) {
        Entity ent = this._data.get(block);
        if (ent != null) {
            ent.invalid();
            this._data.remove(block);
        }
    }

    public long creationTime(String block) {
        Entity ent = this._data.computeIfAbsent(block, k -> new Entity((String)k));
        if (ent != null) {
            return ent.creationTime;
        }
        return 0L;
    }

    public long lastAccessTime(String block) {
        Entity ent = this._data.get(block);
        if (ent != null) {
            return ent.lastAccessTime;
        }
        return 0L;
    }

    public void updateAccessedTime(String block) {
        Entity ent = this._data.get(block);
        if (ent != null) {
            ent.lastAccessTime = System.currentTimeMillis();
            ent.delay(this._data, this._defaultSeconds);
        }
    }

    public static class Entity {
        public final String block;
        public final Map<String, Object> map = new ConcurrentHashMap<String, Object>();
        public long creationTime;
        public long lastAccessTime = this.creationTime = System.currentTimeMillis();
        private Future _future;

        public Entity(String block) {
            this.block = block;
        }

        protected void delay(Map<String, Entity> data, int seconds) {
            this.invalid();
            this._future = RunUtil.delay(() -> data.remove(this.block), seconds * 1000);
        }

        protected void invalid() {
            if (this._future != null) {
                this._future.cancel(true);
                this._future = null;
            }
        }
    }
}

