/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.Max;
import org.noear.solon.validation.util.StringUtils;

public class MaxValidator
implements Validator<Max> {
    public static final MaxValidator instance = new MaxValidator();

    @Override
    public String message(Max anno) {
        return anno.message();
    }

    @Override
    public Class<?>[] groups(Max anno) {
        return anno.groups();
    }

    @Override
    public boolean isSupportValueType(Class<?> type) {
        return ClassUtil.isNumberType(type);
    }

    @Override
    public Result validateOfValue(Max anno, Object val0, StringBuilder tmp) {
        if (val0 != null && !(val0 instanceof Number)) {
            return Result.failure();
        }
        Number val = (Number)val0;
        if (!this.verify(anno, val)) {
            return Result.failure();
        }
        return Result.succeed();
    }

    @Override
    public Result validateOfContext(Context ctx, Max anno, String name, StringBuilder tmp) {
        String val = ctx.param(name);
        if (Utils.isEmpty(val)) {
            return Result.succeed();
        }
        if (!StringUtils.isInteger(val)) {
            return Result.failure(name);
        }
        if (!this.verify(anno, Long.parseLong(val))) {
            return Result.failure(name);
        }
        return Result.succeed();
    }

    private boolean verify(Max anno, Number val) {
        if (val == null) {
            return true;
        }
        return val.longValue() <= anno.value();
    }
}

