/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.Min;
import org.noear.solon.validation.util.StringUtils;

public class MinValidator
implements Validator<Min> {
    public static final MinValidator instance = new MinValidator();

    @Override
    public String message(Min anno) {
        return anno.message();
    }

    @Override
    public Class<?>[] groups(Min anno) {
        return anno.groups();
    }

    @Override
    public boolean isSupportValueType(Class<?> type) {
        return ClassUtil.isNumberType(type);
    }

    @Override
    public Result validateOfValue(Min anno, Object val0, StringBuilder tmp) {
        if (val0 != null && !(val0 instanceof Number)) {
            return Result.failure();
        }
        Number val = (Number)val0;
        if (!this.verify(anno, val)) {
            return Result.failure();
        }
        return Result.succeed();
    }

    @Override
    public Result validateOfContext(Context ctx, Min anno, String name, StringBuilder tmp) {
        String val = ctx.param(name);
        if (Utils.isEmpty(val)) {
            return Result.succeed();
        }
        if (!StringUtils.isInteger(val)) {
            return Result.failure(name);
        }
        if (!this.verify(anno, Long.parseLong(val))) {
            return Result.failure(name);
        }
        return Result.succeed();
    }

    private boolean verify(Min anno, Number val) {
        if (val == null) {
            return true;
        }
        return val.longValue() >= anno.value();
    }
}

