/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import java.io.IOException;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.HttpPart;
import org.noear.solon.validation.annotation.NoRepeatSubmit;
import org.noear.solon.validation.annotation.NoRepeatSubmitChecker;

public class NoRepeatSubmitValidator
implements Validator<NoRepeatSubmit> {
    public static final NoRepeatSubmitValidator instance = new NoRepeatSubmitValidator();
    private NoRepeatSubmitChecker checker;

    public void setChecker(NoRepeatSubmitChecker checker) {
        if (checker != null) {
            this.checker = checker;
        }
    }

    @Override
    public String message(NoRepeatSubmit anno) {
        return anno.message();
    }

    @Override
    public Class<?>[] groups(NoRepeatSubmit anno) {
        return anno.groups();
    }

    @Override
    public Result validateOfContext(Context ctx, NoRepeatSubmit anno, String name, StringBuilder tmp) {
        if (this.checker == null) {
            throw new IllegalArgumentException("Missing NoRepeatSubmitChecker Setting");
        }
        tmp.append(ctx.pathNew()).append("#");
        block6: for (HttpPart part : anno.value()) {
            switch (part) {
                case body: {
                    try {
                        tmp.append("body:");
                        tmp.append(ctx.bodyNew()).append(";");
                        continue block6;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                case headers: {
                    tmp.append("headers:");
                    for (KeyValues<String> keyValues : ctx.headerMap()) {
                        tmp.append(keyValues.getKey()).append("=").append(keyValues.getValues()).append(";");
                    }
                    continue block6;
                }
                default: {
                    tmp.append("params:");
                    for (KeyValues<String> keyValues : ctx.paramMap()) {
                        tmp.append(keyValues.getKey()).append("=").append(keyValues.getValues()).append(";");
                    }
                }
            }
        }
        if (this.checker.check(anno, ctx, Utils.md5(tmp.toString()), anno.seconds())) {
            return Result.succeed();
        }
        return Result.failure();
    }
}

