/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.vault.integration;

import java.util.Properties;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.vault.VaultUtils;
import org.noear.solon.vault.annotation.VaultInject;

public class VaultBeanInjector
implements BeanInjector<VaultInject> {
    @Override
    public void doInject(VarHolder vh, VaultInject anno) {
        this.beanInject(vh, anno.value(), anno.required(), anno.autoRefreshed());
    }

    protected void beanInject(VarHolder vh, String name, boolean required, boolean autoRefreshed) {
        vh.required(required);
        if (name.startsWith("${")) {
            String name2 = name.substring(2, name.length() - 1).trim();
            this.beanInjectConfig(vh, name2);
            if (autoRefreshed && vh.isField()) {
                vh.context().cfg().onChange((key, val) -> {
                    if (key.startsWith(name2)) {
                        this.beanInjectConfig(vh, name2);
                    }
                });
            }
        }
    }

    private void beanInjectConfig(VarHolder vh, String name) {
        if (Properties.class == vh.getType()) {
            Properties val = vh.context().cfg().getProp(name);
            val = VaultUtils.guard(val);
            vh.setValue(val);
        } else {
            String def = null;
            int defIdx = name.indexOf(":");
            if (defIdx > 0) {
                def = name.length() > defIdx + 1 ? name.substring(defIdx + 1).trim() : "";
                name = name.substring(0, defIdx).trim();
            }
            String val = vh.context().cfg().get(name);
            if (def != null && Utils.isEmpty(val)) {
                val = def;
            }
            if ((val = VaultUtils.guard(val)) == null) {
                Properties val0;
                Class<?> pt = vh.getType();
                if (!pt.getName().startsWith("java.lang.") && !pt.isPrimitive() && ((Properties)(val0 = vh.context().cfg().getProp(name))).size() > 0) {
                    val0 = VaultUtils.guard(val0);
                    Object val2 = PropsConverter.global().convert(val0, null, pt, vh.getGenericType());
                    vh.setValue(val2);
                }
            } else {
                Object val2 = ConvertUtil.to(vh.getType(), vh.getGenericType(), val);
                vh.setValue(val2);
            }
        }
    }
}

