/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.web.AsyncContextState;
import org.noear.solon.boot.web.DecodeUtils;
import org.noear.solon.boot.web.RedirectUtils;
import org.noear.solon.boot.web.WebContextBase;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.Cookie;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.web.servlet.AsyncListenerWrap;
import org.noear.solon.web.servlet.MultipartUtil;
import org.noear.solon.web.servlet.SolonServletSessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolonServletContext
extends WebContextBase {
    static final Logger log = LoggerFactory.getLogger(SolonServletContext.class);
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private boolean _loadMultipartFormData = false;
    private URI _uri;
    private String _url;
    private MultiMap<String> _paramMap;
    private MultiMap<String> _cookieMap;
    private MultiMap<String> _headerMap;
    private boolean _headers_sent = false;
    protected final AsyncContextState asyncState = new AsyncContextState();
    private AsyncContext asyncContext;

    public SolonServletContext(HttpServletRequest request, HttpServletResponse response) {
        this._request = request;
        this._response = response;
        if (this.sessionState().replaceable()) {
            this.sessionState = new SolonServletSessionState(request);
        }
    }

    private void loadMultipartFormData() {
        if (this._loadMultipartFormData) {
            return;
        }
        this._loadMultipartFormData = true;
        if (this.isMultipartFormData()) {
            MultipartUtil.buildParamsAndFiles(this, this._fileMap);
        }
    }

    @Override
    public boolean isHeadersSent() {
        return this._headers_sent;
    }

    @Override
    public Object pull(Class<?> clz) {
        Object tmp = super.pull(clz);
        if (tmp == null && HttpSession.class.isAssignableFrom(clz)) {
            return this._request.getSession();
        }
        return tmp;
    }

    @Override
    public Object request() {
        return this._request;
    }

    @Override
    public String remoteIp() {
        return this._request.getRemoteAddr();
    }

    @Override
    public int remotePort() {
        return this._request.getRemotePort();
    }

    @Override
    public String method() {
        return this._request.getMethod();
    }

    @Override
    public String protocol() {
        return this._request.getProtocol();
    }

    @Override
    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    @Override
    public boolean isSecure() {
        return this._request.isSecure();
    }

    @Override
    public String url() {
        if (this._url == null) {
            this._url = this._request.getRequestURL().toString();
        }
        return this._url;
    }

    @Override
    public long contentLength() {
        return this._request.getContentLengthLong();
    }

    @Override
    public String contentType() {
        return this._request.getContentType();
    }

    @Override
    public String queryString() {
        return this._request.getQueryString();
    }

    @Override
    public String body(String charset) throws IOException {
        try {
            return super.body(charset);
        }
        catch (Exception e) {
            throw MultipartUtil.status4xx(this, e);
        }
    }

    @Override
    public InputStream bodyAsStream() throws IOException {
        return this._request.getInputStream();
    }

    @Override
    public MultiMap<String> paramMap() {
        this.paramsMapInit();
        return this._paramMap;
    }

    private void paramsMapInit() {
        if (this._paramMap == null) {
            this._paramMap = new MultiMap();
            try {
                DecodeUtils.decodeFormUrlencoded(this);
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                for (Map.Entry<String, String[]> kv : this._request.getParameterMap().entrySet()) {
                    String name = ServerProps.urlDecode(kv.getKey());
                    this._paramMap.holder(name).setValues((String[])((Object[])kv.getValue()));
                }
            }
            catch (Exception e) {
                throw MultipartUtil.status4xx(this, e);
            }
        }
    }

    @Override
    public MultiMap<UploadedFile> fileMap() {
        if (this.isMultipartFormData()) {
            this.loadMultipartFormData();
        }
        return this._fileMap;
    }

    @Override
    public MultiMap<String> cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new MultiMap();
            DecodeUtils.decodeCookies(this, this.header("Cookie"));
        }
        return this._cookieMap;
    }

    @Override
    public MultiMap<String> headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new MultiMap();
            Enumeration<String> headers = this._request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String key = headers.nextElement();
                this._headerMap.holder(key).setValues((List<String>)Collections.list(this._request.getHeaders(key)));
            }
        }
        return this._headerMap;
    }

    @Override
    public Object response() {
        return this._response;
    }

    @Override
    public void charset(String charset) {
        this._response.setCharacterEncoding(charset);
        this.charset = Charset.forName(charset);
    }

    @Override
    protected void contentTypeDoSet(String contentType) {
        this._response.setContentType(contentType);
    }

    @Override
    public OutputStream outputStream() throws IOException {
        this.sendHeaders();
        return this._response.getOutputStream();
    }

    @Override
    public void output(byte[] bytes) {
        try {
            OutputStream out = this.outputStream();
            out.write(bytes);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void output(InputStream stream) {
        try {
            OutputStream out = this.outputStream();
            IoUtil.transferTo(stream, out);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void headerSet(String key, String val) {
        this._response.setHeader(key, val);
    }

    @Override
    public void headerAdd(String key, String val) {
        this._response.addHeader(key, val);
    }

    @Override
    public String headerOfResponse(String name) {
        return this._response.getHeader(name);
    }

    @Override
    public Collection<String> headerValuesOfResponse(String name) {
        return this._response.getHeaders(name);
    }

    @Override
    public Collection<String> headerNamesOfResponse() {
        return this._response.getHeaderNames();
    }

    @Override
    public void cookieSet(Cookie cookie) {
        javax.servlet.http.Cookie c = new javax.servlet.http.Cookie(cookie.name, cookie.value);
        if (cookie.maxAge >= 0) {
            c.setMaxAge(cookie.maxAge);
        }
        if (Utils.isNotEmpty(cookie.domain)) {
            c.setDomain(cookie.domain);
        }
        if (Utils.isNotEmpty(cookie.path)) {
            c.setPath(cookie.path);
        }
        c.setSecure(cookie.secure);
        c.setHttpOnly(cookie.httpOnly);
        this._response.addCookie(c);
    }

    @Override
    public void redirect(String url, int code) {
        url = RedirectUtils.getRedirectPath(url);
        this.headerSet("Location", url);
        this.statusDoSet(code);
    }

    @Override
    public int status() {
        return this._response.getStatus();
    }

    @Override
    protected void statusDoSet(int status) {
        this._response.setStatus(status);
    }

    @Override
    public void flush() throws IOException {
        this.outputStream().flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream().close();
    }

    @Override
    protected void innerCommit() throws IOException {
        if (this.getHandled() || this.status() >= 200) {
            this.sendHeaders();
        } else {
            this._response.setStatus(404);
        }
    }

    private void sendHeaders() throws IOException {
        if (!this._headers_sent) {
            this._headers_sent = true;
            if (this.sessionState() != null) {
                this.sessionState().sessionPublish();
            }
        }
    }

    @Override
    public boolean asyncSupported() {
        return true;
    }

    @Override
    public boolean asyncStarted() {
        return this.asyncContext != null;
    }

    @Override
    public void asyncListener(ContextAsyncListener listener) {
        this.asyncState.addListener(listener);
    }

    @Override
    public void asyncStart(long timeout, Runnable runnable) {
        if (this.asyncContext == null) {
            this.asyncContext = this._request.startAsync();
            this.asyncState.isStarted = true;
            this.asyncContext.addListener(new AsyncListenerWrap(this, this.asyncState));
            if (timeout != 0L) {
                this.asyncContext.setTimeout(timeout);
            }
            if (runnable != null) {
                this.asyncContext.start(runnable);
            }
        }
    }

    @Override
    public void asyncComplete() {
        if (this.asyncContext != null) {
            try {
                this.innerCommit();
            }
            catch (Throwable e) {
                log.warn("Async completion failed", e);
                this.asyncState.onError(this, e);
            }
            finally {
                this.asyncContext.complete();
            }
        }
    }
}

