/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextHolder;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.web.servlet.SolonServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolonServletFilter
implements Filter {
    static final Logger log = LoggerFactory.getLogger(SolonServletFilter.class);
    public static Handler onFilterStart;
    public static Handler onFilterError;
    public static Handler onFilterEnd;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            SolonServletContext ctx = new SolonServletContext((HttpServletRequest)request, (HttpServletResponse)response);
            try {
                ContextHolder.currentSet(ctx);
                this.doFilterStart(ctx);
                Solon.app().tryHandle(ctx);
                ContextHolder.currentSet(ctx);
                if (ctx.getHandled()) return;
                filterChain.doFilter(request, response);
                return;
            }
            catch (Throwable e) {
                ctx.errors = e;
                this.doFilterError(ctx);
                throw e;
            }
            finally {
                this.doFilterEnd(ctx);
                ContextHolder.currentRemove();
            }
        } else {
            filterChain.doFilter(request, response);
        }
    }

    protected void doFilterStart(Context ctx) {
        this.doHandler(onFilterStart, ctx);
    }

    protected void doFilterError(Context ctx) {
        this.doHandler(onFilterError, ctx);
    }

    protected void doFilterEnd(Context ctx) {
        this.doHandler(onFilterEnd, ctx);
    }

    protected void doHandler(Handler h2, Context ctx) {
        if (h2 != null) {
            try {
                h2.handle(ctx);
            }
            catch (Throwable e) {
                log.warn(e.getMessage(), e);
            }
        }
    }

    @Override
    public void destroy() {
    }
}

