/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.web.servlet.holder.FilterHodler;
import org.noear.solon.web.servlet.holder.ServletHolder;

public class SolonServletInstaller {
    Set<ServletContainerInitializer> initializers = new LinkedHashSet<ServletContainerInitializer>();
    Set<FilterHodler> filters = new LinkedHashSet<FilterHodler>();
    Set<EventListener> listeners = new LinkedHashSet<EventListener>();
    Set<ServletHolder> servlets = new LinkedHashSet<ServletHolder>();

    public SolonServletInstaller() {
        Solon.context().beanForeach(bw -> {
            Annotation anno;
            if (bw.raw() instanceof ServletContainerInitializer) {
                this.initializers.add((ServletContainerInitializer)bw.raw());
            }
            if (bw.raw() instanceof EventListener && (anno = bw.clz().getAnnotation(WebListener.class)) != null) {
                this.listeners.add((EventListener)bw.raw());
            }
            if (bw.raw() instanceof Filter && (anno = bw.clz().getAnnotation(WebFilter.class)) != null) {
                this.filters.add(new FilterHodler((WebFilter)anno, (Filter)bw.raw()));
            }
            if (bw.raw() instanceof Servlet && (anno = bw.clz().getAnnotation(WebServlet.class)) != null) {
                this.servlets.add(new ServletHolder((WebServlet)anno, (Servlet)bw.raw()));
            }
        });
    }

    public void startup(Set<Class<?>> set, ServletContext sc) throws ServletException {
        String name;
        String[] urlPatterns;
        for (ServletContainerInitializer si : this.initializers) {
            si.onStartup(set, sc);
        }
        for (EventListener l : this.listeners) {
            sc.addListener(l);
        }
        for (FilterHodler f : this.filters) {
            urlPatterns = f.anno.value();
            if (urlPatterns.length == 0) {
                urlPatterns = f.anno.urlPatterns();
            }
            if (Utils.isEmpty(name = f.anno.filterName())) {
                name = f.filter.getClass().getSimpleName();
            }
            EnumSet<DispatcherType> enumSet = EnumSet.copyOf(Arrays.asList(f.anno.dispatcherTypes()));
            FilterRegistration.Dynamic dy = sc.addFilter(name, f.filter);
            WebInitParam[] webInitParamArray = f.anno.initParams();
            int n = webInitParamArray.length;
            for (int i = 0; i < n; ++i) {
                WebInitParam ip = webInitParamArray[i];
                dy.setInitParameter(ip.name(), ip.value());
            }
            if (urlPatterns.length > 0) {
                dy.addMappingForUrlPatterns(enumSet, false, urlPatterns);
            }
            if (f.anno.servletNames().length <= 0) continue;
            dy.addMappingForServletNames(enumSet, false, f.anno.servletNames());
        }
        for (ServletHolder s2 : this.servlets) {
            urlPatterns = s2.anno.value();
            if (urlPatterns.length == 0) {
                urlPatterns = s2.anno.urlPatterns();
            }
            if (Utils.isEmpty(name = s2.anno.name())) {
                name = s2.servlet.getClass().getSimpleName();
            }
            ServletRegistration.Dynamic dy = sc.addServlet(name, s2.servlet);
            for (WebInitParam ip : s2.anno.initParams()) {
                dy.setInitParameter(ip.name(), ip.value());
            }
            dy.addMapping(urlPatterns);
            dy.setLoadOnStartup(s2.anno.loadOnStartup());
        }
    }
}

