/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.noear.solon.core.handle.SessionState;

public class SolonServletSessionState
implements SessionState {
    private HttpServletRequest _request;

    public SolonServletSessionState(HttpServletRequest request) {
        this._request = request;
    }

    @Override
    public long creationTime() {
        return this._request.getSession().getCreationTime();
    }

    @Override
    public long lastAccessTime() {
        return this._request.getSession().getLastAccessedTime();
    }

    @Override
    public String sessionId() {
        return this._request.getRequestedSessionId();
    }

    @Override
    public String sessionChangeId() {
        return this._request.changeSessionId();
    }

    @Override
    public Collection<String> sessionKeys() {
        return Collections.list(this._request.getSession().getAttributeNames());
    }

    @Override
    public <T> T sessionGet(String key, Class<T> clz) {
        return (T)this._request.getSession().getAttribute(key);
    }

    @Override
    public void sessionSet(String key, Object val) {
        if (val == null) {
            this.sessionRemove(key);
        } else {
            this._request.getSession().setAttribute(key, val);
        }
    }

    @Override
    public void sessionRemove(String key) {
        this._request.getSession().removeAttribute(key);
    }

    @Override
    public void sessionClear() {
        Enumeration<String> names = this._request.getSession().getAttributeNames();
        while (names.hasMoreElements()) {
            this._request.getSession().removeAttribute(names.nextElement());
        }
    }

    @Override
    public void sessionReset() {
        this._request.getSession().invalidate();
    }
}

