/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.Future;
import javax.servlet.ServletContext;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketBase;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolonWebSocketEndpoint
extends Endpoint {
    private final String SESSION_KEY = "session";
    private static final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public static void addEndpoint(ServletContext sc) {
        ServerContainer serverContainer = (ServerContainer)sc.getAttribute("javax.websocket.server.ServerContainer");
        if (serverContainer == null) {
            throw new IllegalStateException("Missing javax.websocket.server.ServerContainer");
        }
        Collection<String> paths = WebSocketRouter.getInstance().getPaths();
        try {
            for (String path : paths) {
                if (!path.startsWith("/")) continue;
                ServerEndpointConfig endpointConfig = ServerEndpointConfig.Builder.create(SolonWebSocketEndpoint.class, (String)path).build();
                serverContainer.addEndpoint(endpointConfig);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        WebSocketImpl socket = new WebSocketImpl(session);
        session.getUserProperties().put("session", socket);
        session.addMessageHandler((MessageHandler)new BufferMessageHandler(socket));
        session.addMessageHandler((MessageHandler)new TextMessageHandler(socket));
    }

    public void onClose(Session session, CloseReason closeReason) {
        WebSocket socket = (WebSocket)session.getUserProperties().get("session");
        webSocketRouter.getListener().onClose(socket);
    }

    public void onError(Session session, Throwable thr) {
        WebSocket socket = (WebSocket)session.getUserProperties().get("session");
        webSocketRouter.getListener().onError(socket, thr);
    }

    private static class WebSocketImpl
    extends WebSocketBase {
        private static final Logger log = LoggerFactory.getLogger(WebSocketImpl.class);
        private Session real;

        public WebSocketImpl(Session real) {
            this.real = real;
            this.init(real.getRequestURI());
        }

        @Override
        public boolean isValid() {
            return !this.isClosed() && this.real.isOpen();
        }

        @Override
        public boolean isSecure() {
            return this.real.isSecure();
        }

        @Override
        public InetSocketAddress remoteAddress() {
            return null;
        }

        @Override
        public InetSocketAddress localAddress() {
            return null;
        }

        @Override
        public long getIdleTimeout() {
            return this.real.getMaxIdleTimeout();
        }

        @Override
        public void setIdleTimeout(long idleTimeout) {
            this.real.setMaxIdleTimeout(idleTimeout);
        }

        @Override
        public Future<Void> send(String text) {
            return this.real.getAsyncRemote().sendText(text);
        }

        @Override
        public Future<Void> send(ByteBuffer binary) {
            return this.real.getAsyncRemote().sendBinary(binary);
        }

        @Override
        public void close() {
            block2: {
                super.close();
                try {
                    this.real.close();
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug("{}", e);
                }
            }
        }
    }

    private static class BufferMessageHandler
    implements MessageHandler.Whole<ByteBuffer> {
        private WebSocket socket;

        public BufferMessageHandler(WebSocket socket) {
            this.socket = socket;
        }

        public void onMessage(ByteBuffer s2) {
            try {
                webSocketRouter.getListener().onMessage(this.socket, s2);
            }
            catch (Throwable e) {
                webSocketRouter.getListener().onError(this.socket, e);
            }
        }
    }

    private static class TextMessageHandler
    implements MessageHandler.Whole<String> {
        private WebSocket socket;

        public TextMessageHandler(WebSocket socket) {
            this.socket = socket;
        }

        public void onMessage(String s2) {
            try {
                webSocketRouter.getListener().onMessage(this.socket, s2);
            }
            catch (Throwable e) {
                webSocketRouter.getListener().onError(this.socket, e);
            }
        }
    }
}

