/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.staticfiles;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.web.staticfiles.StaticLocation;
import org.noear.solon.web.staticfiles.StaticRepository;

public class StaticMappings {
    static final Map<StaticRepository, StaticLocation> locationMap = new ConcurrentHashMap<StaticRepository, StaticLocation>();

    public static int count() {
        return locationMap.size();
    }

    public static void add(String pathPrefix, StaticRepository repository) {
        StaticMappings.addDo(pathPrefix, repository, false);
    }

    protected static void addDo(String pathPrefix, StaticRepository repository, boolean repositoryIncPrefix) {
        if (!pathPrefix.startsWith("/")) {
            pathPrefix = "/" + pathPrefix;
        }
        locationMap.putIfAbsent(repository, new StaticLocation(pathPrefix, repository, repositoryIncPrefix));
    }

    public static void remove(StaticRepository repository) {
        locationMap.remove(repository);
    }

    public static URL find(String path) throws Exception {
        if (path.contains("../") || path.contains("..\\")) {
            return null;
        }
        URL rst = null;
        for (StaticLocation m4 : locationMap.values()) {
            if (!path.startsWith(m4.pathPrefix)) continue;
            if (m4.repositoryIncPrefix) {
                rst = m4.repository.find(path.substring(1));
            } else if (m4.pathPrefixAsFile) {
                int idx = m4.pathPrefix.lastIndexOf("/");
                rst = m4.repository.find(m4.pathPrefix.substring(idx + 1));
            } else {
                rst = m4.repository.find(path.substring(m4.pathPrefix.length()));
            }
            if (rst == null) continue;
            return rst;
        }
        return rst;
    }
}

