/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.smartboot.http.common.codec.h2.codec.Http2Frame;
import org.smartboot.socket.transport.WriteBuffer;

public class HeadersFrame
extends Http2Frame {
    private int padLength;
    private int streamDependency;
    private int weight;
    private boolean exclusive;
    private ByteBuffer fragment = EMPTY_BUFFER;
    private byte[] padding = EMPTY_PADDING;

    public HeadersFrame(int streamId, int flags, int remaining) {
        super(streamId, flags, remaining);
    }

    @Override
    public boolean decode(ByteBuffer buffer) {
        if (this.finishDecode()) {
            return true;
        }
        switch (this.state) {
            case 0: {
                if (this.getFlag(8)) {
                    if (!buffer.hasRemaining()) {
                        return false;
                    }
                    this.padLength = buffer.get();
                    if (this.padLength < 0) {
                        throw new IllegalStateException();
                    }
                    this.remaining = -1;
                }
                this.state = 1;
            }
            case 1: {
                if (this.getFlag(32)) {
                    if (buffer.remaining() < 5) {
                        return false;
                    }
                    this.streamDependency = buffer.getInt();
                    this.weight = buffer.get() & 0xFF;
                    this.remaining -= 5;
                }
                this.state = 2;
                this.fragment = ByteBuffer.allocate(this.remaining - this.padLength);
            }
            case 2: {
                int min2 = Math.min(buffer.remaining(), this.fragment.remaining());
                int limit = buffer.limit();
                buffer.limit(buffer.position() + min2);
                this.fragment.put(buffer);
                buffer.limit(limit);
                this.remaining -= min2;
                if (this.fragment.hasRemaining()) {
                    return false;
                }
                this.fragment.flip();
                this.state = 3;
            }
            case 3: {
                if (buffer.remaining() < this.padLength) {
                    return false;
                }
                if (this.padLength <= 0) break;
                this.padding = new byte[this.padLength];
                buffer.get(this.padding);
                this.remaining -= this.padLength;
            }
        }
        this.checkEndRemaining();
        return true;
    }

    @Override
    public void writeTo(WriteBuffer writeBuffer) throws IOException {
        boolean padded;
        int payloadLength = 0;
        byte flags = (byte)this.flags;
        boolean bl = padded = this.padding != null && this.padding.length > 0;
        if (padded) {
            payloadLength += 1 + this.padding.length;
            flags = (byte)(flags | 8);
        }
        if (this.weight > 0) {
            payloadLength += 5;
            flags = (byte)(flags | 0x20);
        }
        writeBuffer.writeInt((payloadLength += this.fragment.remaining()) << 8 | 1);
        writeBuffer.writeByte(flags);
        System.out.println("write header ,streamId:" + this.streamId);
        writeBuffer.writeInt(this.streamId);
        if (padded) {
            writeBuffer.writeByte((byte)this.padding.length);
        }
        if (this.hasFlag(flags, 32)) {
            writeBuffer.writeInt(this.streamDependency);
            writeBuffer.writeByte((byte)this.weight);
        }
        writeBuffer.write(this.fragment.array(), 0, this.fragment.remaining());
        if (padded) {
            writeBuffer.write(this.padding);
        }
    }

    public ByteBuffer getFragment() {
        return this.fragment;
    }

    public void setFragment(ByteBuffer fragment) {
        this.fragment = fragment;
    }

    @Override
    public int type() {
        return 1;
    }
}

