/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.hpack;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.smartboot.http.common.codec.h2.hpack.DecodingCallback;
import org.smartboot.http.common.codec.h2.hpack.IntegerReader;
import org.smartboot.http.common.codec.h2.hpack.SimpleHeaderTable;
import org.smartboot.http.common.codec.h2.hpack.StringReader;

public final class Decoder {
    private static final AtomicLong DECODERS_IDS = new AtomicLong();
    private static final List<State> states;
    private final long id;
    private final SimpleHeaderTable table;
    private State state = State.READY;
    private final IntegerReader integerReader;
    private final StringReader stringReader;
    private final StringBuilder name;
    private final StringBuilder value;
    private int intValue;
    private boolean firstValueRead;
    private boolean firstValueIndex;
    private boolean nameHuffmanEncoded;
    private boolean valueHuffmanEncoded;
    private int capacity;

    public Decoder(int capacity) {
        this.id = DECODERS_IDS.incrementAndGet();
        this.setMaxCapacity0(capacity);
        this.table = new SimpleHeaderTable(capacity);
        this.integerReader = new IntegerReader();
        this.stringReader = new StringReader();
        this.name = new StringBuilder(512);
        this.value = new StringBuilder(1024);
    }

    public void setMaxCapacity(int capacity) {
        this.setMaxCapacity0(capacity);
    }

    private void setMaxCapacity0(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity >= 0: " + capacity);
        }
        this.capacity = capacity;
    }

    public void decode(ByteBuffer headerBlock, boolean endOfHeaderBlock, DecodingCallback consumer) throws IOException {
        Objects.requireNonNull(headerBlock, "headerBlock");
        Objects.requireNonNull(consumer, "consumer");
        while (headerBlock.hasRemaining()) {
            this.proceed(headerBlock, consumer);
        }
        if (endOfHeaderBlock && this.state != State.READY) {
            throw new IOException("Unexpected end of header block");
        }
    }

    private void proceed(ByteBuffer input, DecodingCallback action) throws IOException {
        switch (this.state) {
            case READY: {
                this.resumeReady(input);
                break;
            }
            case INDEXED: {
                this.resumeIndexed(input, action);
                break;
            }
            case LITERAL: {
                this.resumeLiteral(input, action);
                break;
            }
            case LITERAL_WITH_INDEXING: {
                this.resumeLiteralWithIndexing(input, action);
                break;
            }
            case LITERAL_NEVER_INDEXED: {
                this.resumeLiteralNeverIndexed(input, action);
                break;
            }
            case SIZE_UPDATE: {
                this.resumeSizeUpdate(input, action);
                break;
            }
            default: {
                throw new InternalError("Unexpected decoder state: " + (Object)((Object)this.state));
            }
        }
    }

    private void resumeReady(ByteBuffer input) {
        int b = input.get(input.position()) & 0xFF;
        State s2 = states.get(b);
        switch (s2) {
            case INDEXED: {
                this.integerReader.configure(7);
                this.state = State.INDEXED;
                this.firstValueIndex = true;
                break;
            }
            case LITERAL: {
                this.state = State.LITERAL;
                boolean bl = this.firstValueIndex = (b & 0xF) != 0;
                if (!this.firstValueIndex) break;
                this.integerReader.configure(4);
                break;
            }
            case LITERAL_WITH_INDEXING: {
                this.state = State.LITERAL_WITH_INDEXING;
                boolean bl = this.firstValueIndex = (b & 0x3F) != 0;
                if (!this.firstValueIndex) break;
                this.integerReader.configure(6);
                break;
            }
            case LITERAL_NEVER_INDEXED: {
                this.state = State.LITERAL_NEVER_INDEXED;
                boolean bl = this.firstValueIndex = (b & 0xF) != 0;
                if (!this.firstValueIndex) break;
                this.integerReader.configure(4);
                break;
            }
            case SIZE_UPDATE: {
                this.integerReader.configure(5);
                this.state = State.SIZE_UPDATE;
                this.firstValueIndex = true;
                break;
            }
            default: {
                throw new InternalError(String.valueOf((Object)s2));
            }
        }
        if (!this.firstValueIndex) {
            input.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeIndexed(ByteBuffer input, DecodingCallback action) throws IOException {
        if (!this.integerReader.read(input)) {
            return;
        }
        this.intValue = this.integerReader.get();
        this.integerReader.reset();
        try {
            SimpleHeaderTable.HeaderField f = this.getHeaderFieldAt(this.intValue);
            action.onIndexed(this.intValue, f.name, f.value);
        }
        finally {
            this.state = State.READY;
        }
    }

    private SimpleHeaderTable.HeaderField getHeaderFieldAt(int index) throws IOException {
        SimpleHeaderTable.HeaderField f;
        try {
            f = this.table.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException("header fields table index", e);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeLiteral(ByteBuffer input, DecodingCallback action) throws IOException {
        if (!this.completeReading(input)) {
            return;
        }
        try {
            if (this.firstValueIndex) {
                SimpleHeaderTable.HeaderField f = this.getHeaderFieldAt(this.intValue);
                action.onLiteral(this.intValue, f.name, (CharSequence)this.value, this.valueHuffmanEncoded);
            } else {
                action.onLiteral(this.name, this.nameHuffmanEncoded, (CharSequence)this.value, this.valueHuffmanEncoded);
            }
        }
        finally {
            this.cleanUpAfterReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeLiteralWithIndexing(ByteBuffer input, DecodingCallback action) throws IOException {
        if (!this.completeReading(input)) {
            return;
        }
        try {
            String n;
            String v = this.value.toString();
            if (this.firstValueIndex) {
                SimpleHeaderTable.HeaderField f = this.getHeaderFieldAt(this.intValue);
                n = f.name;
                action.onLiteralWithIndexing(this.intValue, n, (CharSequence)v, this.valueHuffmanEncoded);
            } else {
                n = this.name.toString();
                action.onLiteralWithIndexing(n, this.nameHuffmanEncoded, (CharSequence)v, this.valueHuffmanEncoded);
            }
            this.table.put(n, v);
        }
        finally {
            this.cleanUpAfterReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeLiteralNeverIndexed(ByteBuffer input, DecodingCallback action) throws IOException {
        if (!this.completeReading(input)) {
            return;
        }
        try {
            if (this.firstValueIndex) {
                SimpleHeaderTable.HeaderField f = this.getHeaderFieldAt(this.intValue);
                action.onLiteralNeverIndexed(this.intValue, f.name, (CharSequence)this.value, this.valueHuffmanEncoded);
            } else {
                action.onLiteralNeverIndexed(this.name, this.nameHuffmanEncoded, (CharSequence)this.value, this.valueHuffmanEncoded);
            }
        }
        finally {
            this.cleanUpAfterReading();
        }
    }

    private void resumeSizeUpdate(ByteBuffer input, DecodingCallback action) throws IOException {
        if (!this.integerReader.read(input)) {
            return;
        }
        this.intValue = this.integerReader.get();
        assert (this.intValue >= 0);
        if (this.intValue > this.capacity) {
            throw new IOException(String.format("Received capacity exceeds expected: capacity=%s, expected=%s", this.intValue, this.capacity));
        }
        this.integerReader.reset();
        try {
            action.onSizeUpdate(this.intValue);
            this.table.setMaxSize(this.intValue);
        }
        finally {
            this.state = State.READY;
        }
    }

    private boolean completeReading(ByteBuffer input) throws IOException {
        if (!this.firstValueRead) {
            if (this.firstValueIndex) {
                if (!this.integerReader.read(input)) {
                    return false;
                }
                this.intValue = this.integerReader.get();
                this.integerReader.reset();
            } else {
                if (!this.stringReader.read(input, this.name)) {
                    return false;
                }
                this.nameHuffmanEncoded = this.stringReader.isHuffmanEncoded();
                this.stringReader.reset();
            }
            this.firstValueRead = true;
            return false;
        }
        if (!this.stringReader.read(input, this.value)) {
            return false;
        }
        this.valueHuffmanEncoded = this.stringReader.isHuffmanEncoded();
        this.stringReader.reset();
        return true;
    }

    private void cleanUpAfterReading() {
        this.name.setLength(0);
        this.value.setLength(0);
        this.firstValueRead = false;
        this.state = State.READY;
    }

    SimpleHeaderTable getTable() {
        return this.table;
    }

    static {
        State[] s2 = new State[256];
        for (int i = 0; i < s2.length; ++i) {
            if ((i & 0x80) == 128) {
                s2[i] = State.INDEXED;
                continue;
            }
            if ((i & 0xC0) == 64) {
                s2[i] = State.LITERAL_WITH_INDEXING;
                continue;
            }
            if ((i & 0xE0) == 32) {
                s2[i] = State.SIZE_UPDATE;
                continue;
            }
            if ((i & 0xF0) == 16) {
                s2[i] = State.LITERAL_NEVER_INDEXED;
                continue;
            }
            if ((i & 0xF0) == 0) {
                s2[i] = State.LITERAL;
                continue;
            }
            throw new InternalError(String.valueOf(i));
        }
        states = Arrays.asList(s2);
    }

    private static enum State {
        READY,
        INDEXED,
        LITERAL_NEVER_INDEXED,
        LITERAL,
        LITERAL_WITH_INDEXING,
        SIZE_UPDATE;

    }
}

