/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.hpack;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class IntegerReader {
    private static final int NEW = 0;
    private static final int CONFIGURED = 1;
    private static final int FIRST_BYTE_READ = 2;
    private static final int DONE = 4;
    private int state = 0;
    private int N;
    private int maxValue;
    private int value;
    private long r;
    private long b = 1L;

    IntegerReader() {
    }

    public IntegerReader configure(int N2) {
        return this.configure(N2, Integer.MAX_VALUE);
    }

    public IntegerReader configure(int N2, int maxValue) {
        if (this.state != 0) {
            throw new IllegalStateException("Already configured");
        }
        IntegerReader.checkPrefix(N2);
        if (maxValue < 0) {
            throw new IllegalArgumentException("maxValue >= 0: maxValue=" + maxValue);
        }
        this.maxValue = maxValue;
        this.N = N2;
        this.state = 1;
        return this;
    }

    public boolean read(ByteBuffer input) throws IOException {
        if (this.state == 0) {
            throw new IllegalStateException("Configure first");
        }
        if (this.state == 4) {
            return true;
        }
        if (!input.hasRemaining()) {
            return false;
        }
        if (this.state == 1) {
            int max = (2 << this.N - 1) - 1;
            int n = input.get() & max;
            if (n != max) {
                this.value = n;
                this.state = 4;
                return true;
            }
            this.r = max;
            this.state = 2;
        }
        if (this.state == 2) {
            byte i;
            do {
                if (!input.hasRemaining()) {
                    return false;
                }
                i = input.get();
                long increment = this.b * (long)(i & 0x7F);
                if (this.r + increment > (long)this.maxValue) {
                    throw new IOException(String.format("Integer overflow: maxValue=%,d, value=%,d", this.maxValue, this.r + increment));
                }
                this.r += increment;
                this.b *= 128L;
            } while ((0x80 & i) == 128);
            this.value = (int)this.r;
            this.state = 4;
            return true;
        }
        throw new InternalError(Arrays.toString(new Object[]{this.state, this.N, this.maxValue, this.value, this.r, this.b}));
    }

    public int get() throws IllegalStateException {
        if (this.state != 4) {
            throw new IllegalStateException("Has not been fully read yet");
        }
        return this.value;
    }

    private static void checkPrefix(int N2) {
        if (N2 < 1 || N2 > 8) {
            throw new IllegalArgumentException("1 <= N <= 8: N= " + N2);
        }
    }

    public IntegerReader reset() {
        this.b = 1L;
        this.state = 0;
        return this;
    }
}

