/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.hpack;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

class SimpleHeaderTable {
    protected static final List<HeaderField> staticTable = Arrays.asList(new HeaderField(""), new HeaderField(":authority"), new HeaderField(":method", "GET"), new HeaderField(":method", "POST"), new HeaderField(":path", "/"), new HeaderField(":path", "/index.html"), new HeaderField(":scheme", "http"), new HeaderField(":scheme", "https"), new HeaderField(":status", "200"), new HeaderField(":status", "204"), new HeaderField(":status", "206"), new HeaderField(":status", "304"), new HeaderField(":status", "400"), new HeaderField(":status", "404"), new HeaderField(":status", "500"), new HeaderField("accept-charset"), new HeaderField("accept-encoding", "gzip, deflate"), new HeaderField("accept-language"), new HeaderField("accept-ranges"), new HeaderField("accept"), new HeaderField("access-control-allow-origin"), new HeaderField("age"), new HeaderField("allow"), new HeaderField("authorization"), new HeaderField("cache-control"), new HeaderField("content-disposition"), new HeaderField("content-encoding"), new HeaderField("content-language"), new HeaderField("content-length"), new HeaderField("content-location"), new HeaderField("content-range"), new HeaderField("content-type"), new HeaderField("cookie"), new HeaderField("date"), new HeaderField("etag"), new HeaderField("expect"), new HeaderField("expires"), new HeaderField("from"), new HeaderField("host"), new HeaderField("if-match"), new HeaderField("if-modified-since"), new HeaderField("if-none-match"), new HeaderField("if-range"), new HeaderField("if-unmodified-since"), new HeaderField("last-modified"), new HeaderField("link"), new HeaderField("location"), new HeaderField("max-forwards"), new HeaderField("proxy-authenticate"), new HeaderField("proxy-authorization"), new HeaderField("range"), new HeaderField("referer"), new HeaderField("refresh"), new HeaderField("retry-after"), new HeaderField("server"), new HeaderField("set-cookie"), new HeaderField("strict-transport-security"), new HeaderField("transfer-encoding"), new HeaderField("user-agent"), new HeaderField("vary"), new HeaderField("via"), new HeaderField("www-authenticate"));
    protected static final int STATIC_TABLE_LENGTH = staticTable.size() - 1;
    protected static final int ENTRY_SIZE = 32;
    private int maxSize;
    private int size;
    private final CircularBuffer<HeaderField> buffer = new CircularBuffer(0);

    public SimpleHeaderTable(int maxSize) {
        this.setMaxSize(maxSize);
    }

    public int size() {
        return this.size;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int length() {
        return STATIC_TABLE_LENGTH + this.buffer.size;
    }

    HeaderField get(int index) {
        this.checkIndex(index);
        if (index <= STATIC_TABLE_LENGTH) {
            return staticTable.get(index);
        }
        return this.buffer.get(index - STATIC_TABLE_LENGTH - 1);
    }

    void put(CharSequence name, CharSequence value) {
        this.put(new HeaderField(name.toString(), value.toString()));
    }

    private void put(HeaderField h2) {
        int entrySize = this.sizeOf(h2);
        while (entrySize > this.maxSize - this.size && this.size != 0) {
            this.evictEntry();
        }
        if (entrySize > this.maxSize - this.size) {
            return;
        }
        this.size += entrySize;
        this.add(h2);
    }

    void setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize >= 0: maxSize=" + maxSize);
        }
        while (maxSize < this.size && this.size != 0) {
            this.evictEntry();
        }
        this.maxSize = maxSize;
        int upperBound = maxSize / 32;
        this.buffer.resize(upperBound);
    }

    HeaderField evictEntry() {
        HeaderField f = this.remove();
        int s2 = this.sizeOf(f);
        this.size -= s2;
        return f;
    }

    public String toString() {
        double used = this.maxSize == 0 ? 0.0 : 100.0 * ((double)this.size / (double)this.maxSize);
        return String.format("dynamic length: %d, full length: %s, used space: %s/%s (%.1f%%)", this.buffer.size, this.length(), this.size, this.maxSize, used);
    }

    private int checkIndex(int index) {
        int len = this.length();
        if (index < 1 || index > len) {
            throw new IndexOutOfBoundsException(String.format("1 <= index <= length(): index=%s, length()=%s", index, len));
        }
        return index;
    }

    int sizeOf(HeaderField f) {
        return f.name.length() + f.value.length() + 32;
    }

    String getStateString() {
        if (this.size == 0) {
            return "empty.";
        }
        StringBuilder b = new StringBuilder();
        int size = this.buffer.size;
        for (int i = 1; i <= size; ++i) {
            HeaderField e = this.buffer.get(i - 1);
            b.append(String.format("[%3d] (s = %3d) %s: %s\n", i, this.sizeOf(e), e.name, e.value));
        }
        b.append(String.format("      Table size:%4s", this.size));
        return b.toString();
    }

    protected void add(HeaderField f) {
        this.buffer.add(f);
    }

    protected HeaderField remove() {
        return this.buffer.remove();
    }

    static final class CircularBuffer<E> {
        int tail;
        int head;
        int size;
        int capacity;
        Object[] elements;

        CircularBuffer(int capacity) {
            this.capacity = CircularBuffer.pow2Size(capacity);
            this.elements = new Object[this.capacity];
        }

        public static int pow2Size(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return 1;
            }
            if (n >= 0x40000000) {
                return 0x40000000;
            }
            return 1 << 32 - Integer.numberOfLeadingZeros(n - 1);
        }

        void add(E elem) {
            if (this.size == this.capacity) {
                throw new IllegalStateException(String.format("No room for '%s': capacity=%s", elem, this.capacity));
            }
            this.elements[this.head] = elem;
            this.head = this.head + 1 & this.capacity - 1;
            ++this.size;
        }

        E remove() {
            if (this.size == 0) {
                throw new NoSuchElementException("Empty");
            }
            Object elem = this.elements[this.tail];
            this.elements[this.tail] = null;
            this.tail = this.tail + 1 & this.capacity - 1;
            --this.size;
            return (E)elem;
        }

        E get(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException(String.format("0 <= index <= capacity: index=%s, capacity=%s", index, this.capacity));
            }
            int idx = this.tail + (this.size - index - 1) & this.capacity - 1;
            return (E)this.elements[idx];
        }

        public void resize(int newCapacity) {
            if (newCapacity < this.size) {
                throw new IllegalStateException(String.format("newCapacity >= size: newCapacity=%s, size=%s", newCapacity, this.size));
            }
            int capacity = CircularBuffer.pow2Size(newCapacity);
            Object[] newElements = new Object[capacity];
            if (this.tail < this.head || this.size == 0) {
                System.arraycopy(this.elements, this.tail, newElements, 0, this.size);
            } else {
                System.arraycopy(this.elements, this.tail, newElements, 0, this.elements.length - this.tail);
                System.arraycopy(this.elements, 0, newElements, this.elements.length - this.tail, this.head);
            }
            this.elements = newElements;
            this.tail = 0;
            this.head = this.size;
            this.capacity = capacity;
        }
    }

    protected static final class HeaderField {
        final String name;
        final String value;

        public HeaderField(String name) {
            this(name, "");
        }

        public HeaderField(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.value.isEmpty() ? this.name : this.name + ": " + this.value;
        }
    }
}

