/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.function.Supplier;
import org.smartboot.http.common.Cookie;
import org.smartboot.http.common.HeaderValue;
import org.smartboot.http.common.Reset;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.io.BufferOutputStream;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.impl.AbstractOutputStream;
import org.smartboot.socket.transport.AioSession;

public class AbstractResponse
implements HttpResponse,
Reset {
    protected AbstractOutputStream outputStream;
    private Map<String, HeaderValue> headers = Collections.emptyMap();
    private HttpStatus httpStatus = HttpStatus.OK;
    private long contentLength = -1L;
    private String contentType = HeaderValueEnum.DEFAULT_CONTENT_TYPE.getName();
    private AioSession session;
    protected boolean closed = false;
    private List<Cookie> cookies = Collections.emptyList();

    protected void init(AioSession session, AbstractOutputStream outputStream) {
        this.session = session;
        this.outputStream = outputStream;
    }

    @Override
    public final void reset() {
        this.outputStream.reset();
        this.headers.clear();
        this.setHttpStatus(HttpStatus.OK);
        this.contentType = HeaderValueEnum.DEFAULT_CONTENT_TYPE.getName();
        this.contentLength = -1L;
        this.cookies = Collections.emptyList();
        this.closed = false;
    }

    @Override
    public final BufferOutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public final void setHttpStatus(HttpStatus httpStatus) {
        Objects.requireNonNull(httpStatus);
        if (httpStatus.value() < 100 || httpStatus.value() > 1000) {
            throw new IllegalArgumentException("httpStatus must between 100 and 1000");
        }
        this.httpStatus = httpStatus;
    }

    @Override
    public final void setHttpStatus(int value, String reasonPhrase) {
        this.setHttpStatus(new HttpStatus(value, Objects.requireNonNull(reasonPhrase)));
    }

    @Override
    public final void setHeader(String name, String value) {
        this.setHeader(name, value, true);
    }

    @Override
    public final void addHeader(String name, String value) {
        this.setHeader(name, value, false);
    }

    private void setHeader(String name, String value, boolean replace) {
        char cc = name.charAt(0);
        if ((cc == 'C' || cc == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        Map emptyHeaders = Collections.emptyMap();
        if (this.headers == emptyHeaders) {
            this.headers = new HashMap<String, HeaderValue>();
        }
        if (replace) {
            if (value == null) {
                this.headers.remove(name);
            } else {
                this.headers.put(name, new HeaderValue(null, value));
            }
            return;
        }
        HeaderValue headerValue = this.headers.get(name);
        if (headerValue == null) {
            this.setHeader(name, value, true);
            return;
        }
        HeaderValue preHeaderValue = null;
        while (headerValue != null && !headerValue.getValue().equals(value)) {
            preHeaderValue = headerValue;
            headerValue = headerValue.getNextValue();
        }
        if (headerValue == null) {
            preHeaderValue.setNextValue(new HeaderValue(null, value));
        }
    }

    protected boolean isKeepAlive() {
        return HeaderValueEnum.KEEPALIVE.getName().equalsIgnoreCase(this.getHeader(HeaderNameEnum.CONNECTION.getName()));
    }

    private boolean checkSpecialHeader(String name, String value) {
        if (name.equalsIgnoreCase(HeaderNameEnum.CONTENT_TYPE.getName())) {
            this.setContentType(value);
            return true;
        }
        if (name.equalsIgnoreCase(HeaderNameEnum.CONTENT_LENGTH.getName())) {
            this.setContentLength(Long.parseLong(value));
            return true;
        }
        return false;
    }

    @Override
    public final String getHeader(String name) {
        HeaderValue headerValue = this.headers.get(name);
        return headerValue == null ? null : headerValue.getValue();
    }

    final Map<String, HeaderValue> getHeaders() {
        return this.headers;
    }

    @Override
    public final Collection<String> getHeaders(String name) {
        Vector<String> result = new Vector<String>();
        for (HeaderValue headerValue = this.headers.get(name); headerValue != null; headerValue = headerValue.getNextValue()) {
            result.addElement(headerValue.getValue());
        }
        return result;
    }

    @Override
    public final Collection<String> getHeaderNames() {
        return new ArrayList<String>(this.headers.keySet());
    }

    @Override
    public final void write(byte[] buffer) throws IOException {
        this.outputStream.write(buffer);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            if (this.outputStream != null && !this.outputStream.isClosed()) {
                this.outputStream.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.session.close(false);
        }
        this.closed = true;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    @Override
    public void addCookie(Cookie cookie) {
        List emptyList = Collections.emptyList();
        if (this.cookies == emptyList) {
            this.cookies = new ArrayList<Cookie>();
        }
        this.cookies.add(cookie);
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    @Override
    public final void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public Supplier<Map<String, String>> getTrailerFields() {
        return this.outputStream.getTrailerFields();
    }
}

