/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.smartboot.http.common.Cookie;
import org.smartboot.http.common.HeaderValue;
import org.smartboot.http.common.Reset;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpProtocolEnum;
import org.smartboot.http.common.enums.HttpTypeEnum;
import org.smartboot.http.common.io.BodyInputStream;
import org.smartboot.http.common.utils.HttpUtils;
import org.smartboot.http.common.utils.NumberUtils;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.util.Attachment;

public abstract class CommonRequest
implements Reset {
    private static final Locale defaultLocale = Locale.getDefault();
    private static final int INIT_CONTENT_LENGTH = -2;
    private static final int NONE_CONTENT_LENGTH = -1;
    protected final AioSession aioSession;
    protected final Map<String, HeaderValue> headers = new HashMap<String, HeaderValue>();
    protected final HttpServerConfiguration configuration;
    protected Map<String, String[]> parameters;
    protected String uri;
    protected int headerSize = 0;
    protected String method;
    protected HttpProtocolEnum protocol = HttpProtocolEnum.HTTP_11;
    protected String requestUri;
    protected String requestUrl;
    protected String contentType;
    protected String connection;
    protected String queryString;
    protected String scheme;
    protected long contentLength = -2L;
    protected String remoteAddr;
    protected String remoteHost;
    protected String hostHeader;
    protected HttpTypeEnum type = null;
    protected Cookie[] cookies;
    protected SSLEngine sslEngine;
    protected Attachment attachment;
    protected ServerHandler serverHandler;
    private boolean multiplexing = false;

    CommonRequest(AioSession aioSession, HttpServerConfiguration configuration) {
        this.aioSession = aioSession;
        this.configuration = configuration;
        this.sslEngine = HttpRequest.SSL_ENGINE_THREAD_LOCAL.get();
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public final String getHost() {
        if (this.hostHeader == null) {
            this.hostHeader = this.getHeader(HeaderNameEnum.HOST);
        }
        return this.hostHeader;
    }

    final String getInnerHeader(String lowCaseHeaderName) {
        HeaderValue headerValue = this.headers.get(lowCaseHeaderName);
        return headerValue == null ? null : headerValue.getValue();
    }

    public final String getHeader(HeaderNameEnum headerNameEnum) {
        return this.getInnerHeader(headerNameEnum.getLowCaseName());
    }

    public final String getHeader(String headName) {
        return this.getInnerHeader(headName.toLowerCase());
    }

    public final Collection<String> getHeaders(String name) {
        HeaderValue headerValue = this.headers.get(name.toLowerCase());
        if (headerValue == null) {
            return Collections.emptyList();
        }
        ArrayList<String> value = new ArrayList<String>(4);
        while (headerValue != null) {
            value.add(headerValue.getValue());
            headerValue = headerValue.getNextValue();
        }
        return value;
    }

    public final Collection<String> getHeaderNames() {
        HashSet<String> nameSet = new HashSet<String>();
        this.headers.forEach((k, v) -> {
            while (v != null) {
                nameSet.add(v.getName());
                v = v.getNextValue();
            }
        });
        return nameSet;
    }

    public final int getHeaderSize() {
        return this.headerSize;
    }

    public BodyInputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    private void setHeader(String lowCaseHeader, String headerName, String value) {
        if (value == null) {
            HeaderValue oldValue = this.headers.remove(lowCaseHeader);
            if (oldValue != null) {
                do {
                    --this.headerSize;
                } while ((oldValue = oldValue.getNextValue()) != null);
            }
            return;
        }
        HeaderValue headerValue = this.headers.get(lowCaseHeader);
        if (headerValue == null) {
            ++this.headerSize;
            this.headers.put(lowCaseHeader, new HeaderValue(headerName, value));
        } else {
            headerValue.setName(headerName);
            headerValue.setValue(value);
            for (HeaderValue nextValue = headerValue.getNextValue(); nextValue != null; nextValue = nextValue.getNextValue()) {
                --this.headerSize;
            }
            headerValue.setNextValue(null);
        }
    }

    public final void setHeader(String headerName, String value) {
        this.setHeader(headerName.toLowerCase(), headerName, value);
    }

    final void addHeader(String lowCaseHeader, String headerName, String value) {
        HeaderValue oldValue = this.headers.get(lowCaseHeader);
        if (oldValue != null) {
            while (oldValue.getNextValue() != null) {
                oldValue = oldValue.getNextValue();
            }
            oldValue.setNextValue(new HeaderValue(headerName, value));
            ++this.headerSize;
        } else {
            this.setHeader(lowCaseHeader, headerName, value);
        }
    }

    public HttpTypeEnum getRequestType() {
        if (this.type != null) {
            return this.type;
        }
        this.type = this.serverHandler instanceof WebSocketHandler ? HttpTypeEnum.WEBSOCKET : HttpTypeEnum.HTTP;
        return this.type;
    }

    public void setType(HttpTypeEnum type) {
        this.type = type;
    }

    public ServerHandler getServerHandler() {
        return this.serverHandler;
    }

    public void setServerHandler(ServerHandler serverHandler) {
        this.serverHandler = serverHandler;
    }

    public final String getRequestURI() {
        return this.requestUri;
    }

    public final void setRequestURI(String uri) {
        this.requestUri = uri;
    }

    public final HttpProtocolEnum getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(HttpProtocolEnum protocol) {
        if (protocol != null) {
            this.protocol = protocol;
        }
    }

    public final String getMethod() {
        return this.method;
    }

    public final boolean isSecure() {
        return this.configuration.isSecure();
    }

    public final void setMethod(String method) {
        this.method = method;
    }

    public final String getUri() {
        return this.uri;
    }

    public final void setUri(String uri) {
        this.uri = uri;
    }

    public final String getRequestURL() {
        if (this.requestUrl != null) {
            return this.requestUrl;
        }
        this.requestUrl = this.requestUri.startsWith("/") ? this.getScheme() + "://" + this.getHost() + this.getRequestURI() : this.requestUri;
        return this.requestUrl;
    }

    public final String getScheme() {
        if (this.scheme == null) {
            return this.configuration.isSecure() ? "https" : "http";
        }
        return this.scheme;
    }

    public final void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public final String getQueryString() {
        return this.queryString;
    }

    public final void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public final String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = this.getHeader(HeaderNameEnum.CONTENT_TYPE);
        return this.contentType;
    }

    public final String getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        this.connection = this.getHeader(HeaderNameEnum.CONNECTION);
        return this.connection;
    }

    public long getContentLength() {
        if (this.contentLength > -2L) {
            return this.contentLength;
        }
        this.contentLength = NumberUtils.toLong(this.getHeader(HeaderNameEnum.CONTENT_LENGTH), -1L);
        return this.contentLength;
    }

    public final String getParameter(String name) {
        String[] arr = name != null ? this.getParameterValues(name) : null;
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public final String[] getParameterValues(String name) {
        String contentTypeTmp;
        if (this.parameters != null) {
            return this.parameters.get(name);
        }
        this.parameters = new HashMap<String, String[]>();
        String urlParamStr = this.queryString;
        if (StringUtils.isNotBlank(urlParamStr)) {
            urlParamStr = StringUtils.substringBefore(urlParamStr, "#");
            HttpUtils.decodeParamString(urlParamStr, this.parameters);
        }
        if ((contentTypeTmp = this.getContentType()) != null && contentTypeTmp.startsWith(HeaderValueEnum.X_WWW_FORM_URLENCODED.getName())) {
            try {
                BodyInputStream inputStream = this.getInputStream();
                if (inputStream != BodyInputStream.EMPTY_INPUT_STREAM) {
                    int len;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    byte[] bytes = new byte[1024];
                    while ((len = inputStream.read(bytes)) != -1) {
                        outputStream.write(bytes, 0, len);
                    }
                    HttpUtils.decodeParamString(outputStream.toString(), this.parameters);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getParameterValues(name);
    }

    public final Map<String, String[]> getParameters() {
        if (this.parameters == null) {
            this.getParameter("");
        }
        return this.parameters;
    }

    public abstract String getRemoteAddr();

    public abstract InetSocketAddress getRemoteAddress();

    public abstract InetSocketAddress getLocalAddress();

    public abstract String getRemoteHost();

    public final Locale getLocale() {
        return this.getLocales().nextElement();
    }

    public final Enumeration<Locale> getLocales() {
        Collection<String> acceptLanguage = this.getHeaders(HeaderNameEnum.ACCEPT_LANGUAGE.getName());
        if (acceptLanguage.isEmpty()) {
            return Collections.enumeration(Collections.singletonList(defaultLocale));
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String language : acceptLanguage) {
            for (String lan : language.split(",")) {
                locales.add(Locale.forLanguageTag(lan));
            }
        }
        return Collections.enumeration(locales);
    }

    public final String getCharacterEncoding() {
        return "utf8";
    }

    public final Cookie[] getCookies() {
        if (this.cookies != null) {
            return this.cookies;
        }
        HeaderValue headerValue = this.headers.get(HeaderNameEnum.COOKIE.getLowCaseName());
        if (headerValue == null) {
            return new Cookie[0];
        }
        ArrayList<Cookie> parsedCookies = new ArrayList<Cookie>();
        while (headerValue != null) {
            parsedCookies.addAll(HttpUtils.decodeCookies(headerValue.getValue()));
            headerValue = headerValue.getNextValue();
        }
        this.cookies = new Cookie[parsedCookies.size()];
        parsedCookies.toArray(this.cookies);
        return this.cookies;
    }

    public final Attachment getAttachment() {
        return this.attachment;
    }

    public final void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    public AioSession getAioSession() {
        return this.aioSession;
    }

    public final HttpServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isMultiplexing() {
        return this.multiplexing;
    }

    @Override
    public void reset() {
        this.headerSize = 0;
        this.headers.clear();
        this.uri = null;
        this.requestUrl = null;
        this.parameters = null;
        this.contentType = null;
        this.contentLength = -2L;
        this.cookies = null;
        this.type = null;
        this.scheme = null;
        this.queryString = null;
        this.requestUri = null;
        this.multiplexing = true;
    }
}

