/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.nio.ByteBuffer;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HttpProtocolEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.utils.ByteTree;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.impl.DecoderUnit;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.waf.WAF;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.transport.AioSession;

public class HttpRequestProtocol
implements Protocol<Request> {
    private final HttpServerConfiguration configuration;
    private static final ByteTree.EndMatcher URI_END_MATCHER = endByte -> endByte == 32 || endByte == 63;

    public HttpRequestProtocol(HttpServerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Request decode(ByteBuffer byteBuffer, AioSession session) {
        Request request = (Request)session.getAttachment();
        int p = byteBuffer.position();
        boolean flag = this.decode(byteBuffer, request);
        request.decodeSize(byteBuffer.position() - p);
        return flag ? request : null;
    }

    private boolean decode(ByteBuffer byteBuffer, Request request) {
        DecoderUnit decodeState = request.getDecodeState();
        switch (decodeState.getState()) {
            case 14: {
                ByteTree<Object> method = StringUtils.scanByteTree(byteBuffer, ByteTree.SP_END_MATCHER, this.configuration.getByteCache());
                if (method == null) break;
                request.setMethod(method.getStringValue());
                decodeState.setState(15);
                WAF.methodCheck(this.configuration, request);
            }
            case 15: {
                ByteTree<ServerHandler<?, ?>> uriTreeNode = StringUtils.scanByteTree(byteBuffer, URI_END_MATCHER, this.configuration.getUriByteTree());
                if (uriTreeNode == null) break;
                request.setUri(uriTreeNode.getStringValue());
                if (uriTreeNode.getAttach() == null) {
                    request.setServerHandler(request.getConfiguration().getHttpServerHandler());
                } else {
                    request.setServerHandler(uriTreeNode.getAttach());
                }
                WAF.checkUri(this.configuration, request);
                switch (byteBuffer.get(byteBuffer.position() - 1)) {
                    case 32: {
                        decodeState.setState(0);
                        break;
                    }
                    case 63: {
                        decodeState.setState(16);
                        break;
                    }
                    default: {
                        throw new HttpException(HttpStatus.BAD_REQUEST);
                    }
                }
                return this.decode(byteBuffer, request);
            }
            case 16: {
                int length = this.scanUriQuery(byteBuffer);
                if (length < 0) break;
                String query = StringUtils.convertToString(byteBuffer, byteBuffer.position() - 1 - length, length);
                request.setQueryString(query);
                decodeState.setState(0);
            }
            case 0: {
                ByteTree<Object> protocol = StringUtils.scanByteTree(byteBuffer, ByteTree.CR_END_MATCHER, this.configuration.getByteCache());
                if (protocol == null) break;
                HttpProtocolEnum protocolEnum = (HttpProtocolEnum)((Object)protocol.getAttach());
                request.setProtocol(protocolEnum);
                decodeState.setState(3);
            }
            case 3: {
                if (byteBuffer.remaining() == 0) break;
                if (byteBuffer.get() != 10) {
                    throw new HttpException(HttpStatus.BAD_REQUEST);
                }
                decodeState.setState(4);
            }
            case 4: {
                if (byteBuffer.remaining() < 2) break;
                byteBuffer.mark();
                if (byteBuffer.get() == 13) {
                    if (byteBuffer.get() != 10) {
                        throw new HttpException(HttpStatus.BAD_REQUEST);
                    }
                    decodeState.setState(9);
                    return true;
                }
                byteBuffer.reset();
                if (request.getHeaderSize() > this.configuration.getHeaderLimiter()) {
                    decodeState.setState(8);
                    return this.decode(byteBuffer, request);
                }
                decodeState.setState(5);
            }
            case 5: {
                ByteTree<HeaderNameEnum> name = StringUtils.scanByteTree(byteBuffer, ByteTree.COLON_END_MATCHER, this.configuration.getHeaderNameByteTree());
                if (name == null) break;
                decodeState.setDecodeHeaderName(name);
                decodeState.setState(6);
            }
            case 6: {
                ByteTree<Object> value = StringUtils.scanByteTree(byteBuffer, ByteTree.CR_END_MATCHER, this.configuration.getByteCache());
                if (value == null) {
                    if (byteBuffer.remaining() != byteBuffer.capacity()) break;
                    throw new HttpException(HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
                }
                HeaderNameEnum headerName = decodeState.getDecodeHeaderName().getAttach();
                if (headerName != null) {
                    request.addHeader(headerName.getLowCaseName(), decodeState.getDecodeHeaderName().getStringValue(), value.getStringValue());
                } else {
                    request.addHeader(decodeState.getDecodeHeaderName().getStringValue().toLowerCase(), decodeState.getDecodeHeaderName().getStringValue(), value.getStringValue());
                }
                decodeState.setState(7);
            }
            case 7: {
                if (!byteBuffer.hasRemaining()) break;
                if (byteBuffer.get() != 10) {
                    throw new HttpException(HttpStatus.BAD_REQUEST);
                }
                decodeState.setState(4);
                return this.decode(byteBuffer, request);
            }
            case 8: {
                int position = byteBuffer.position() + byteBuffer.arrayOffset();
                int limit = byteBuffer.limit() + byteBuffer.arrayOffset();
                byte[] data = byteBuffer.array();
                while (limit - position >= 4) {
                    byte b = data[position + 3];
                    if (b == 13) {
                        ++position;
                        continue;
                    }
                    if (b != 10) {
                        if ((position += 7) < limit && data[position] != 13 && data[position] != 10) continue;
                        position -= 3;
                        continue;
                    }
                    if (data[position] == 13 && data[position + 1] == 10) {
                        byteBuffer.position(position + 4 - byteBuffer.arrayOffset());
                        decodeState.setState(9);
                        return true;
                    }
                    position += 2;
                }
                byteBuffer.position(position - byteBuffer.arrayOffset());
                return false;
            }
            case 11: {
                decodeState.setState(12);
                if (byteBuffer.position() > 0) break;
            }
            case 12: {
                return true;
            }
        }
        return false;
    }

    private int scanUriQuery(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return -1;
        }
        int i = 0;
        buffer.mark();
        while (buffer.hasRemaining()) {
            if (buffer.get() == 32) {
                return i;
            }
            ++i;
        }
        buffer.reset();
        return -1;
    }
}

