/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.enhance;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.AcceptPendingException;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.concurrent.Future;
import org.smartboot.socket.enhance.EnhanceAsynchronousChannelGroup;
import org.smartboot.socket.enhance.EnhanceAsynchronousServerChannel;
import org.smartboot.socket.enhance.FutureCompletionHandler;

final class EnhanceAsynchronousServerSocketChannel
extends AsynchronousServerSocketChannel {
    private final ServerSocketChannel serverSocketChannel;
    private final EnhanceAsynchronousChannelGroup enhanceAsynchronousChannelGroup;
    private CompletionHandler<AsynchronousSocketChannel, Object> acceptCompletionHandler;
    private FutureCompletionHandler<AsynchronousSocketChannel, Void> acceptFuture;
    private Object attachment;
    private SelectionKey selectionKey;
    private boolean acceptPending;
    private final boolean lowMemory;
    private int acceptInvoker;

    EnhanceAsynchronousServerSocketChannel(EnhanceAsynchronousChannelGroup enhanceAsynchronousChannelGroup, boolean lowMemory) throws IOException {
        super(enhanceAsynchronousChannelGroup.provider());
        this.enhanceAsynchronousChannelGroup = enhanceAsynchronousChannelGroup;
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.configureBlocking(false);
        this.lowMemory = lowMemory;
    }

    @Override
    public AsynchronousServerSocketChannel bind(SocketAddress local, int backlog) throws IOException {
        this.serverSocketChannel.bind(local, backlog);
        return this;
    }

    @Override
    public <T> AsynchronousServerSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        this.serverSocketChannel.setOption((SocketOption)name, (Object)value);
        return this;
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.serverSocketChannel.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.serverSocketChannel.supportedOptions();
    }

    @Override
    public <A> void accept(A attachment, CompletionHandler<AsynchronousSocketChannel, ? super A> handler) {
        if (this.acceptPending) {
            throw new AcceptPendingException();
        }
        this.acceptPending = true;
        this.acceptCompletionHandler = handler;
        this.attachment = attachment;
        this.doAccept();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAccept() {
        try {
            if (this.acceptFuture != null && this.acceptFuture.isDone()) {
                this.resetAccept();
                EnhanceAsynchronousChannelGroup.removeOps(this.selectionKey, 16);
                return;
            }
            SocketChannel socketChannel = null;
            if (this.acceptInvoker++ < 8) {
                socketChannel = this.serverSocketChannel.accept();
            }
            if (socketChannel != null) {
                EnhanceAsynchronousServerChannel asynchronousSocketChannel = new EnhanceAsynchronousServerChannel(this.enhanceAsynchronousChannelGroup, socketChannel, this.lowMemory);
                socketChannel.configureBlocking(false);
                socketChannel.finishConnect();
                CompletionHandler<AsynchronousSocketChannel, Object> completionHandler = this.acceptCompletionHandler;
                Object attach = this.attachment;
                this.resetAccept();
                completionHandler.completed(asynchronousSocketChannel, attach);
                if (!this.acceptPending && this.selectionKey != null) {
                    EnhanceAsynchronousChannelGroup.removeOps(this.selectionKey, 16);
                }
            } else if (this.selectionKey == null) {
                this.enhanceAsynchronousChannelGroup.commonWorker.addRegister(selector -> {
                    try {
                        this.selectionKey = this.serverSocketChannel.register((Selector)selector, 16, this);
                    }
                    catch (ClosedChannelException e) {
                        this.acceptCompletionHandler.failed(e, this.attachment);
                    }
                });
            } else {
                EnhanceAsynchronousChannelGroup.interestOps(this.enhanceAsynchronousChannelGroup.commonWorker, this.selectionKey, 16);
            }
        }
        catch (IOException e) {
            this.acceptCompletionHandler.failed(e, this.attachment);
        }
        finally {
            this.acceptInvoker = 0;
        }
    }

    private void resetAccept() {
        this.acceptPending = false;
        this.acceptFuture = null;
        this.acceptCompletionHandler = null;
        this.attachment = null;
    }

    @Override
    public Future<AsynchronousSocketChannel> accept() {
        FutureCompletionHandler acceptFuture = new FutureCompletionHandler();
        this.accept(null, acceptFuture);
        this.acceptFuture = acceptFuture;
        return acceptFuture;
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.serverSocketChannel.getLocalAddress();
    }

    @Override
    public boolean isOpen() {
        return this.serverSocketChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.serverSocketChannel.close();
    }
}

