/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.processor;

import java.nio.channels.AsynchronousSocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.NetMonitor;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.extension.plugins.Plugin;
import org.smartboot.socket.transport.AioSession;

public abstract class AbstractMessageProcessor<T>
implements MessageProcessor<T>,
NetMonitor {
    private final List<Plugin<T>> plugins = new ArrayList<Plugin<T>>();

    @Override
    public final void afterRead(AioSession session, int readSize) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.afterRead(session, readSize);
        }
    }

    @Override
    public final void afterWrite(AioSession session, int writeSize) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.afterWrite(session, writeSize);
        }
    }

    @Override
    public final void beforeRead(AioSession session) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.beforeRead(session);
        }
    }

    @Override
    public final void beforeWrite(AioSession session) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.beforeWrite(session);
        }
    }

    @Override
    public final AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        AsynchronousSocketChannel acceptChannel = channel;
        for (Plugin<T> plugin : this.plugins) {
            acceptChannel = plugin.shouldAccept(acceptChannel);
            if (acceptChannel != null) continue;
            return null;
        }
        return acceptChannel;
    }

    @Override
    public final void process(AioSession session, T msg) {
        boolean flag = true;
        for (Plugin<T> plugin : this.plugins) {
            if (plugin.preProcess(session, msg)) continue;
            flag = false;
        }
        if (flag) {
            this.process0(session, msg);
        }
    }

    public abstract void process0(AioSession var1, T var2);

    @Override
    public final void stateEvent(AioSession session, StateMachineEnum stateMachineEnum, Throwable throwable) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.stateEvent(stateMachineEnum, session, throwable);
        }
        this.stateEvent0(session, stateMachineEnum, throwable);
    }

    public abstract void stateEvent0(AioSession var1, StateMachineEnum var2, Throwable var3);

    public final void addPlugin(Plugin<T> plugin) {
        this.plugins.add(plugin);
    }
}

