/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.protocol;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.extension.decoder.FixedLengthFrameDecoder;
import org.smartboot.socket.transport.AioSession;

public class StringProtocol
implements Protocol<String> {
    private final Charset charset;
    private final Map<AioSession, FixedLengthFrameDecoder> decoderMap = new ConcurrentHashMap<AioSession, FixedLengthFrameDecoder>();
    private long lastClearTime = System.currentTimeMillis();

    public StringProtocol(Charset charset) {
        this.charset = charset;
    }

    public StringProtocol() {
        this(StandardCharsets.UTF_8);
    }

    @Override
    public String decode(ByteBuffer readBuffer, AioSession session) {
        FixedLengthFrameDecoder decoder;
        if (System.currentTimeMillis() - this.lastClearTime > 5000L) {
            this.lastClearTime = System.currentTimeMillis();
            this.decoderMap.keySet().stream().filter(AioSession::isInvalid).forEach(this.decoderMap::remove);
        }
        if ((decoder = this.decoderMap.get(session)) != null) {
            String content = this.bigContent(readBuffer, decoder);
            if (content != null) {
                this.decoderMap.remove(session);
            }
            return content;
        }
        int remaining = readBuffer.remaining();
        if (remaining < 4) {
            return null;
        }
        readBuffer.mark();
        int length = readBuffer.getInt();
        if (length + 4 > readBuffer.capacity()) {
            FixedLengthFrameDecoder fixedLengthFrameDecoder = new FixedLengthFrameDecoder(length);
            this.decoderMap.put(session, fixedLengthFrameDecoder);
            return null;
        }
        if (length > readBuffer.remaining()) {
            readBuffer.reset();
            return null;
        }
        return this.convert(readBuffer, length);
    }

    private String bigContent(ByteBuffer readBuffer, FixedLengthFrameDecoder decoder) {
        if (!decoder.decode(readBuffer)) {
            return null;
        }
        ByteBuffer byteBuffer = decoder.getBuffer();
        return this.convert(byteBuffer, byteBuffer.capacity());
    }

    private String convert(ByteBuffer byteBuffer, int length) {
        byte[] b = new byte[length];
        byteBuffer.get(b);
        return new String(b, this.charset);
    }
}

