/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.smartboot.socket.DecoderException;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.NetMonitor;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.buffer.BufferPage;
import org.smartboot.socket.buffer.VirtualBuffer;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.transport.IOUtil;
import org.smartboot.socket.transport.IoServerConfig;
import org.smartboot.socket.transport.WriteBuffer;

final class TcpAioSession
extends AioSession {
    private final AsynchronousSocketChannel channel;
    private static final CompletionHandler<Integer, TcpAioSession> READ_COMPLETION_HANDLER = new CompletionHandler<Integer, TcpAioSession>(){

        @Override
        public void completed(Integer result, TcpAioSession aioSession) {
            try {
                aioSession.readCompleted(result);
            }
            catch (Throwable throwable) {
                this.failed(throwable, aioSession);
            }
        }

        @Override
        public void failed(Throwable exc, TcpAioSession aioSession) {
            try {
                aioSession.config.getProcessor().stateEvent(aioSession, StateMachineEnum.INPUT_EXCEPTION, exc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                aioSession.close(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private final WriteBuffer byteBuf;
    private static final CompletionHandler<Integer, TcpAioSession> WRITE_COMPLETION_HANDLER = new CompletionHandler<Integer, TcpAioSession>(){

        @Override
        public void completed(Integer result, TcpAioSession aioSession) {
            try {
                aioSession.writeCompleted(result);
            }
            catch (Throwable throwable) {
                this.failed(throwable, aioSession);
            }
        }

        @Override
        public void failed(Throwable exc, TcpAioSession aioSession) {
            try {
                aioSession.config.getProcessor().stateEvent(aioSession, StateMachineEnum.OUTPUT_EXCEPTION, exc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                aioSession.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private final IoServerConfig config;
    private final Supplier<VirtualBuffer> readBufferSupplier;
    private VirtualBuffer readBuffer;
    private VirtualBuffer writeBuffer;
    private InputStream inputStream;

    TcpAioSession(AsynchronousSocketChannel channel, IoServerConfig config, BufferPage writeBufferPage, Supplier<VirtualBuffer> readBufferSupplier) {
        this.channel = channel;
        this.config = config;
        this.readBufferSupplier = readBufferSupplier;
        this.byteBuf = new WriteBuffer(writeBufferPage, this::continueWrite, config.getWriteBufferSize(), config.getWriteBufferCapacity());
        config.getProcessor().stateEvent(this, StateMachineEnum.NEW_SESSION, null);
        this.doRead();
    }

    void doRead() {
        this.readBuffer = this.readBufferSupplier.get();
        this.readBuffer.buffer().flip();
        this.signalRead();
    }

    void writeCompleted(int result) {
        NetMonitor monitor = this.config.getMonitor();
        if (monitor != null) {
            monitor.afterWrite(this, result);
        }
        VirtualBuffer writeBuffer = this.writeBuffer;
        this.writeBuffer = null;
        if (writeBuffer == null) {
            writeBuffer = this.byteBuf.poll();
        } else if (!writeBuffer.buffer().hasRemaining()) {
            writeBuffer.clean();
            writeBuffer = this.byteBuf.poll();
        }
        if (writeBuffer != null) {
            this.continueWrite(writeBuffer);
            return;
        }
        this.byteBuf.finishWrite();
        if (this.status != 3) {
            this.close();
        } else {
            this.byteBuf.flush();
        }
    }

    @Override
    public WriteBuffer writeBuffer() {
        return this.byteBuf;
    }

    @Override
    public ByteBuffer readBuffer() {
        return this.readBuffer.buffer();
    }

    @Override
    public void awaitRead() {
        ++this.modCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void close(boolean immediate) {
        if (this.status == 1) {
            return;
        }
        this.status = (byte)(immediate ? 1 : 2);
        if (immediate) {
            try {
                this.byteBuf.close();
                if (this.readBuffer != null) {
                    this.readBuffer.clean();
                    this.readBuffer = null;
                }
                if (this.writeBuffer == null) return;
                this.writeBuffer.clean();
                this.writeBuffer = null;
                return;
            }
            finally {
                IOUtil.close(this.channel);
                this.config.getProcessor().stateEvent(this, StateMachineEnum.SESSION_CLOSED, null);
            }
        } else if ((this.writeBuffer == null || !this.writeBuffer.buffer().hasRemaining()) && this.byteBuf.isEmpty()) {
            this.close(true);
            return;
        } else {
            this.config.getProcessor().stateEvent(this, StateMachineEnum.SESSION_CLOSING, null);
            this.byteBuf.flush();
        }
    }

    void readCompleted(int result) {
        if (result == -2) {
            this.readBuffer.clean();
            this.readBuffer = null;
            return;
        }
        if (result == -3) {
            this.doRead();
            return;
        }
        NetMonitor monitor = this.config.getMonitor();
        if (monitor != null) {
            monitor.afterRead(this, result);
        }
        boolean bl = this.eof = result == -1;
        if (1 != this.status) {
            this.readBuffer.buffer().flip();
            this.signalRead();
        }
    }

    @Override
    public void signalRead() {
        NetMonitor monitor;
        int modCount = this.modCount;
        if (this.status == 1) {
            return;
        }
        ByteBuffer readBuffer = this.readBuffer.buffer();
        MessageProcessor messageProcessor = this.config.getProcessor();
        while (readBuffer.hasRemaining() && this.status == 3) {
            Object dataEntry;
            try {
                dataEntry = this.config.getProtocol().decode(readBuffer, this);
            }
            catch (Throwable e) {
                messageProcessor.stateEvent(this, StateMachineEnum.DECODE_EXCEPTION, e);
                throw e;
            }
            if (dataEntry == null) break;
            try {
                messageProcessor.process(this, dataEntry);
                if (modCount == this.modCount) continue;
                return;
            }
            catch (Exception e) {
                messageProcessor.stateEvent(this, StateMachineEnum.PROCESS_EXCEPTION, e);
            }
        }
        if (this.eof || this.status == 2) {
            this.close(false);
            messageProcessor.stateEvent(this, StateMachineEnum.INPUT_SHUTDOWN, null);
            return;
        }
        if (this.status == 1) {
            return;
        }
        this.byteBuf.flush();
        if (readBuffer.hasRemaining()) {
            readBuffer.compact();
            if (!readBuffer.hasRemaining()) {
                DecoderException exception = new DecoderException("readBuffer overflow. The current TCP connection will be closed. Please fix your " + this.config.getProtocol().getClass().getSimpleName() + "#decode bug.");
                messageProcessor.stateEvent(this, StateMachineEnum.DECODE_EXCEPTION, exception);
                throw exception;
            }
        } else {
            readBuffer.clear();
        }
        if ((monitor = this.config.getMonitor()) != null) {
            monitor.beforeRead(this);
        }
        this.channel.read(readBuffer, 0L, TimeUnit.MILLISECONDS, this, READ_COMPLETION_HANDLER);
    }

    @Override
    public int read(long timeout, TimeUnit unit) throws IOException {
        ByteBuffer buffer = this.readBuffer.buffer();
        buffer.compact();
        try {
            int readSize = timeout > 0L ? this.channel.read(buffer).get().intValue() : this.channel.read(buffer).get(timeout, unit).intValue();
            buffer.flip();
            return readSize;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void continueWrite(VirtualBuffer writeBuffer) {
        this.writeBuffer = writeBuffer;
        NetMonitor monitor = this.config.getMonitor();
        if (monitor != null) {
            monitor.beforeWrite(this);
        }
        this.channel.write(writeBuffer.buffer(), 0L, TimeUnit.MILLISECONDS, this, WRITE_COMPLETION_HANDLER);
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getRemoteAddress();
    }

    private void assertChannel() throws IOException {
        if (this.status == 1 || this.channel == null) {
            throw new IOException("session is closed");
        }
    }
}

