/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.xnio.Cancellable;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Xnio;
import org.xnio._private.Messages;

public abstract class AbstractIoFuture<T>
implements IoFuture<T> {
    private final AtomicReference<State<T>> stateRef = new AtomicReference(ST_INITIAL);
    private static final State<?> ST_INITIAL = new InitialState();
    private static final State<?> ST_CANCELLED = new CancelledState();

    protected AbstractIoFuture() {
    }

    @Override
    public IoFuture.Status getStatus() {
        return this.getState().getStatus();
    }

    private State<T> getState() {
        return this.stateRef.get();
    }

    private boolean compareAndSetState(State<T> expect, State<T> update) {
        return this.stateRef.compareAndSet(expect, update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status await() {
        State<T> withWaiter;
        State<T> state;
        Thread thread = Thread.currentThread();
        do {
            if ((state = this.getState()).getStatus() != IoFuture.Status.WAITING) {
                return state.getStatus();
            }
            Xnio.checkBlockingAllowed();
        } while (!this.compareAndSetState(state, withWaiter = state.withWaiter(thread)));
        boolean intr = Thread.interrupted();
        try {
            do {
                LockSupport.park(this);
                if (!Thread.interrupted()) continue;
                intr = true;
            } while ((state = this.getState()).getStatus() == IoFuture.Status.WAITING);
            IoFuture.Status status = state.getStatus();
            return status;
        }
        finally {
            if (intr) {
                thread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status await(long time, TimeUnit timeUnit) {
        State<T> withWaiter;
        State<T> state;
        if (time < 0L) {
            time = 0L;
        }
        long duration = timeUnit.toNanos(time);
        long now = System.nanoTime();
        Thread thread = Thread.currentThread();
        do {
            if ((state = this.getState()).getStatus() != IoFuture.Status.WAITING || duration == 0L) {
                return state.getStatus();
            }
            Xnio.checkBlockingAllowed();
        } while (!this.compareAndSetState(state, withWaiter = state.withWaiter(thread)));
        boolean intr = Thread.interrupted();
        try {
            long tick;
            do {
                LockSupport.parkNanos(this, duration);
                if (Thread.interrupted()) {
                    intr = true;
                }
                state = this.getState();
                tick = System.nanoTime();
                now = tick;
            } while (state.getStatus() == IoFuture.Status.WAITING && (duration -= tick - now) > 0L);
            IoFuture.Status status = state.getStatus();
            return status;
        }
        finally {
            if (intr) {
                thread.interrupt();
            }
        }
    }

    @Override
    public IoFuture.Status awaitInterruptibly() throws InterruptedException {
        State<T> withWaiter;
        State<T> state;
        Thread thread = Thread.currentThread();
        do {
            if ((state = this.getState()).getStatus() != IoFuture.Status.WAITING) {
                return state.getStatus();
            }
            Xnio.checkBlockingAllowed();
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        } while (!this.compareAndSetState(state, withWaiter = state.withWaiter(thread)));
        do {
            LockSupport.park(this);
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        } while ((state = this.getState()).getStatus() == IoFuture.Status.WAITING);
        return state.getStatus();
    }

    @Override
    public IoFuture.Status awaitInterruptibly(long time, TimeUnit timeUnit) throws InterruptedException {
        long tick;
        State<T> withWaiter;
        State<T> state;
        if (time < 0L) {
            time = 0L;
        }
        long duration = timeUnit.toNanos(time);
        long now = System.nanoTime();
        Thread thread = Thread.currentThread();
        do {
            if ((state = this.getState()).getStatus() != IoFuture.Status.WAITING || duration == 0L) {
                return state.getStatus();
            }
            Xnio.checkBlockingAllowed();
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        } while (!this.compareAndSetState(state, withWaiter = state.withWaiter(thread)));
        do {
            LockSupport.parkNanos(this, duration);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            state = this.getState();
            tick = System.nanoTime();
            now = tick;
        } while (state.getStatus() == IoFuture.Status.WAITING && (duration -= tick - now) > 0L);
        return state.getStatus();
    }

    @Override
    public T get() throws IOException, CancellationException {
        switch (this.await()) {
            case DONE: {
                return this.getState().getResult();
            }
            case FAILED: {
                throw this.getState().getException();
            }
            case CANCELLED: {
                throw Messages.futureMsg.opCancelled();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public T getInterruptibly() throws IOException, InterruptedException, CancellationException {
        switch (this.awaitInterruptibly()) {
            case DONE: {
                return this.getState().getResult();
            }
            case FAILED: {
                throw this.getState().getException();
            }
            case CANCELLED: {
                throw Messages.futureMsg.opCancelled();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public IOException getException() throws IllegalStateException {
        return this.getState().getException();
    }

    @Override
    public <A> IoFuture<T> addNotifier(IoFuture.Notifier<? super T, A> notifier, A attachment) {
        State<? super T> newState;
        State<? super T> oldState;
        while (!this.compareAndSetState(oldState = this.getState(), newState = oldState.withNotifier(this.getNotifierExecutor(), this, notifier, attachment))) {
        }
        return this;
    }

    protected boolean setException(IOException exception) {
        State<T> oldState = this.getState();
        if (oldState.getStatus() != IoFuture.Status.WAITING) {
            return false;
        }
        FailedState newState = new FailedState(exception);
        while (!this.compareAndSetState(oldState, newState)) {
            oldState = this.getState();
            if (oldState.getStatus() == IoFuture.Status.WAITING) continue;
            return false;
        }
        oldState.notifyFailed(this, exception);
        return true;
    }

    protected boolean setResult(T result) {
        State<T> oldState = this.getState();
        if (oldState.getStatus() != IoFuture.Status.WAITING) {
            return false;
        }
        CompleteState<T> newState = new CompleteState<T>(result);
        while (!this.compareAndSetState(oldState, newState)) {
            oldState = this.getState();
            if (oldState.getStatus() == IoFuture.Status.WAITING) continue;
            return false;
        }
        oldState.notifyDone(this, result);
        return true;
    }

    protected boolean setCancelled() {
        State<T> oldState = this.getState();
        if (oldState.getStatus() != IoFuture.Status.WAITING) {
            return false;
        }
        State<?> newState = ST_CANCELLED;
        while (!this.compareAndSetState(oldState, newState)) {
            oldState = this.getState();
            if (oldState.getStatus() == IoFuture.Status.WAITING) continue;
            return false;
        }
        oldState.notifyCancelled(this);
        return true;
    }

    @Override
    public IoFuture<T> cancel() {
        State<T> state;
        do {
            if ((state = this.getState()).getStatus() == IoFuture.Status.WAITING && !state.cancelRequested()) continue;
            return this;
        } while (!this.compareAndSetState(state, new CancelRequestedState<T>(state)));
        state.cancel();
        return this;
    }

    protected void addCancelHandler(Cancellable cancellable) {
        State<T> newState;
        State<T> oldState;
        do {
            if ((oldState = this.getState()).getStatus() != IoFuture.Status.WAITING || oldState.cancelRequested()) {
                try {
                    cancellable.cancel();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            newState = oldState.withCancelHandler(cancellable);
            if (oldState != newState) continue;
            return;
        } while (!this.compareAndSetState(oldState, newState));
    }

    protected void runNotifier(Runnable runnable) {
        this.getNotifierExecutor().execute(runnable);
    }

    protected Executor getNotifierExecutor() {
        return IoUtils.directExecutor();
    }

    static class NotifierRunnable<T, A>
    implements Runnable {
        private final IoFuture.Notifier<? super T, A> notifier;
        private final IoFuture<T> future;
        private final A attachment;

        NotifierRunnable(IoFuture.Notifier<? super T, A> notifier, IoFuture<T> future, A attachment) {
            this.notifier = notifier;
            this.future = future;
            this.attachment = attachment;
        }

        @Override
        public void run() {
            try {
                this.notifier.notify(this.future, this.attachment);
            }
            catch (Throwable t2) {
                Messages.futureMsg.notifierFailed(t2, this.notifier, this.attachment);
            }
        }
    }

    static final class CancelRequestedState<T>
    extends NestedState<T> {
        CancelRequestedState(State<T> next) {
            super(next);
        }

        @Override
        IoFuture.Status getStatus() {
            return IoFuture.Status.WAITING;
        }

        @Override
        protected void doNotifyDone(AbstractIoFuture<T> future, T result) {
        }

        @Override
        protected void doNotifyFailed(AbstractIoFuture<T> future, IOException exception) {
        }

        @Override
        protected void doNotifyCancelled(AbstractIoFuture<T> future) {
        }

        @Override
        protected void doCancel() {
        }

        @Override
        protected boolean isCancelRequested() {
            return true;
        }
    }

    static final class CancellableState<T>
    extends NestedState<T> {
        final Cancellable cancellable;

        CancellableState(State<T> next, Cancellable cancellable) {
            super(next);
            this.cancellable = cancellable;
        }

        @Override
        IoFuture.Status getStatus() {
            return IoFuture.Status.WAITING;
        }

        @Override
        protected void doNotifyDone(AbstractIoFuture<T> future, T result) {
        }

        @Override
        protected void doNotifyFailed(AbstractIoFuture<T> future, IOException exception) {
        }

        @Override
        protected void doNotifyCancelled(AbstractIoFuture<T> future) {
        }

        @Override
        protected void doCancel() {
            try {
                this.cancellable.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        protected boolean isCancelRequested() {
            return false;
        }
    }

    static final class WaiterState<T>
    extends NestedState<T> {
        final Thread waiter;

        WaiterState(State<T> next, Thread waiter) {
            super(next);
            this.waiter = waiter;
        }

        @Override
        IoFuture.Status getStatus() {
            return IoFuture.Status.WAITING;
        }

        @Override
        protected void doNotifyDone(AbstractIoFuture<T> future, T result) {
            LockSupport.unpark(this.waiter);
        }

        @Override
        protected void doNotifyFailed(AbstractIoFuture<T> future, IOException exception) {
            LockSupport.unpark(this.waiter);
        }

        @Override
        protected void doNotifyCancelled(AbstractIoFuture<T> future) {
            LockSupport.unpark(this.waiter);
        }

        @Override
        protected void doCancel() {
        }

        @Override
        protected boolean isCancelRequested() {
            return false;
        }
    }

    static final class NotifierState<T, A>
    extends NestedState<T> {
        final IoFuture.Notifier<? super T, A> notifier;
        final A attachment;

        NotifierState(State<T> next, IoFuture.Notifier<? super T, A> notifier, A attachment) {
            super(next);
            this.notifier = notifier;
            this.attachment = attachment;
        }

        @Override
        IoFuture.Status getStatus() {
            return IoFuture.Status.WAITING;
        }

        @Override
        protected void doNotifyDone(AbstractIoFuture<T> future, T result) {
            this.doNotify(future);
        }

        @Override
        protected void doNotifyFailed(AbstractIoFuture<T> future, IOException exception) {
            this.doNotify(future);
        }

        @Override
        protected void doNotifyCancelled(AbstractIoFuture<T> future) {
            this.doNotify(future);
        }

        @Override
        protected void doCancel() {
        }

        private void doNotify(AbstractIoFuture<T> future) {
            future.runNotifier(new NotifierRunnable<T, A>(this.notifier, future, this.attachment));
        }

        @Override
        protected boolean isCancelRequested() {
            return false;
        }
    }

    static final class CancelledState<T>
    extends State<T> {
        CancelledState() {
        }

        @Override
        IoFuture.Status getStatus() {
            return IoFuture.Status.CANCELLED;
        }

        @Override
        void notifyDone(AbstractIoFuture<T> future, T result) {
        }

        @Override
        void notifyFailed(AbstractIoFuture<T> future, IOException exception) {
        }

        @Override
        void notifyCancelled(AbstractIoFuture<T> future) {
        }

        @Override
        void cancel() {
        }

        @Override
        State<T> withCancelHandler(Cancellable cancellable) {
            try {
                cancellable.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this;
        }

        @Override
        <A> State<T> withNotifier(Executor executor, AbstractIoFuture<T> future, IoFuture.Notifier<? super T, A> notifier, A attachment) {
            future.runNotifier(new NotifierRunnable<T, A>(notifier, future, attachment));
            return this;
        }

        @Override
        State<T> withWaiter(Thread thread) {
            return this;
        }

        @Override
        boolean cancelRequested() {
            return true;
        }
    }

    static final class FailedState<T>
    extends State<T> {
        private final IOException exception;

        FailedState(IOException exception) {
            this.exception = exception;
        }

        @Override
        IoFuture.Status getStatus() {
            return IoFuture.Status.FAILED;
        }

        @Override
        void notifyDone(AbstractIoFuture<T> future, T result) {
        }

        @Override
        void notifyFailed(AbstractIoFuture<T> future, IOException exception) {
        }

        @Override
        void notifyCancelled(AbstractIoFuture<T> future) {
        }

        @Override
        void cancel() {
        }

        @Override
        State<T> withCancelHandler(Cancellable cancellable) {
            return this;
        }

        @Override
        State<T> withWaiter(Thread thread) {
            return this;
        }

        @Override
        <A> State<T> withNotifier(Executor executor, AbstractIoFuture<T> future, IoFuture.Notifier<? super T, A> notifier, A attachment) {
            future.runNotifier(new NotifierRunnable<T, A>(notifier, future, attachment));
            return this;
        }

        @Override
        IOException getException() {
            return this.exception;
        }

        @Override
        boolean cancelRequested() {
            return false;
        }
    }

    static final class CompleteState<T>
    extends State<T> {
        private final T result;

        CompleteState(T result) {
            this.result = result;
        }

        @Override
        IoFuture.Status getStatus() {
            return IoFuture.Status.DONE;
        }

        @Override
        void notifyDone(AbstractIoFuture<T> future, T result) {
        }

        @Override
        void notifyFailed(AbstractIoFuture<T> future, IOException exception) {
        }

        @Override
        void notifyCancelled(AbstractIoFuture<T> future) {
        }

        @Override
        void cancel() {
        }

        @Override
        State<T> withCancelHandler(Cancellable cancellable) {
            return this;
        }

        @Override
        State<T> withWaiter(Thread thread) {
            return this;
        }

        @Override
        <A> State<T> withNotifier(Executor executor, AbstractIoFuture<T> future, IoFuture.Notifier<? super T, A> notifier, A attachment) {
            future.runNotifier(new NotifierRunnable<T, A>(notifier, future, attachment));
            return this;
        }

        @Override
        T getResult() {
            return this.result;
        }

        @Override
        boolean cancelRequested() {
            return false;
        }
    }

    static final class InitialState<T>
    extends State<T> {
        InitialState() {
        }

        @Override
        IoFuture.Status getStatus() {
            return IoFuture.Status.WAITING;
        }

        @Override
        void notifyDone(AbstractIoFuture<T> future, T result) {
        }

        @Override
        void notifyFailed(AbstractIoFuture<T> future, IOException exception) {
        }

        @Override
        void notifyCancelled(AbstractIoFuture<T> future) {
        }

        @Override
        void cancel() {
        }

        @Override
        boolean cancelRequested() {
            return false;
        }
    }

    private static abstract class NestedState<T>
    extends State<T> {
        private final State<T> next;

        public NestedState(State next) {
            this.next = next;
        }

        protected abstract void doNotifyDone(AbstractIoFuture<T> var1, T var2);

        @Override
        public void notifyDone(AbstractIoFuture<T> future, T result) {
            this.doNotifyDone(future, result);
            if (this.next instanceof NestedState) {
                NestedState current = this;
                do {
                    current = (NestedState)current.next;
                    current.doNotifyDone(future, result);
                } while (current.next instanceof NestedState);
                current.next.notifyDone(future, result);
            } else {
                this.next.notifyDone(future, result);
            }
        }

        protected abstract void doNotifyFailed(AbstractIoFuture<T> var1, IOException var2);

        @Override
        public void notifyFailed(AbstractIoFuture<T> future, IOException exception) {
            this.doNotifyFailed(future, exception);
            if (this.next instanceof NestedState) {
                NestedState current = this;
                do {
                    current = (NestedState)current.next;
                    current.doNotifyFailed(future, exception);
                } while (current.next instanceof NestedState);
                current.next.notifyFailed(future, exception);
            } else {
                this.next.notifyFailed(future, exception);
            }
        }

        protected abstract void doNotifyCancelled(AbstractIoFuture<T> var1);

        @Override
        public void notifyCancelled(AbstractIoFuture<T> future) {
            this.doNotifyCancelled(future);
            if (this.next instanceof NestedState) {
                NestedState current = this;
                do {
                    current = (NestedState)current.next;
                    current.doNotifyCancelled(future);
                } while (current.next instanceof NestedState);
                current.next.notifyCancelled(future);
            } else {
                this.next.notifyCancelled(future);
            }
        }

        protected abstract void doCancel();

        @Override
        public void cancel() {
            this.doCancel();
            if (this.next instanceof NestedState) {
                NestedState current = this;
                do {
                    current = (NestedState)current.next;
                    current.doCancel();
                } while (current.next instanceof NestedState);
                current.next.cancel();
            } else {
                this.next.cancel();
            }
        }

        protected abstract boolean isCancelRequested();

        @Override
        public boolean cancelRequested() {
            if (this.isCancelRequested()) {
                return true;
            }
            if (this.next instanceof NestedState) {
                NestedState current = this;
                do {
                    if (!(current = (NestedState)current.next).isCancelRequested()) continue;
                    return true;
                } while (current.next instanceof NestedState);
                return current.next.cancelRequested();
            }
            return this.next.cancelRequested();
        }
    }

    static abstract class State<T> {
        State() {
        }

        abstract IoFuture.Status getStatus();

        abstract void notifyDone(AbstractIoFuture<T> var1, T var2);

        abstract void notifyFailed(AbstractIoFuture<T> var1, IOException var2);

        abstract void notifyCancelled(AbstractIoFuture<T> var1);

        abstract void cancel();

        abstract boolean cancelRequested();

        State<T> withWaiter(Thread thread) {
            return new WaiterState(this, thread);
        }

        <A> State<T> withNotifier(Executor executor, AbstractIoFuture<T> future, IoFuture.Notifier<? super T, A> notifier, A attachment) {
            return new NotifierState<T, A>(this, notifier, attachment);
        }

        State<T> withCancelHandler(Cancellable cancellable) {
            return new CancellableState(this, cancellable);
        }

        T getResult() {
            throw new IllegalStateException();
        }

        IOException getException() {
            throw new IllegalStateException();
        }
    }
}

