#pragma once

#include <Windows.h>
#include <comdef.h>


////////////////////////////////////////////////////////////////
//                     ö


enum DismPackageState
{
	DismPackageStateUnknown = 0,
	DismPackageStateNotPresent,
	DismPackageStateUnintallRequested,
	DismPackageStateStaged,              //ݴ
	DismPackageStateStaging,             //ݴ
	DismPackageStateInstalled,           //Ѿװ
	DismPackageStateInstallRequested,    //װ
	DismPackageStateSuperseded,          //øѾȡ
	DismPackageStatePartiallInstalled,   //ְװ
	DismPackageStateRemoved,             //Ѿɾ
	DismPackageStatePermanent,           //ù̻°
};
enum DismFeatureState
{
	DismFeatureStateUnknown = 0,
	DismFeatureStateNotPresent,
	DismFeatureStateUnintallRequested,   //ùѾرյδЧ
	DismFeatureStateDisable,             //ùѾر
	DismFeatureStateStaging,
	DismFeatureStateEnable,              //ùܱ
	DismFeatureStateEnableRequested,     //ùѾδЧ
	DismFeatureStateSuperseded,          //ùѾȡ
	DismFeatureStatePartiallInstalled,   //ùְܲװ
	DismFeatureStateRemoved              //ùѾɾ
};

enum DismFullyOfflineInstallableState
{
	DismPackageFullyOfflineUnknow = 0,
	DismPackageFullyOfflineInatallable,
	DismPackageFullyOfflineNotInatallable,
};



enum DismDriverSinStatus
{
	DismDriverSinStatusUnknow = 0,
	DismDriverSinStatusUnsigned,
	DismDriverSinStatusSinged
};


enum DriverShowEnum
{
	DriverShowAll = 0,
	DriverShowInbox = 1,
	DriverShowOutOfBox = 2
};


enum DismMountedImageStatus
{
	DismMountedImageStatusValid = 0,
	DismMountedImageStatusMounting = 1,
	DismMountedImageStatusInvalid = 2,
	DismMountedImageStatusNeedsRemount = 4
};

enum DismImageFileTpye
{
	WimImageFile,
	VhdImageFile
};

//WIMesdļѹ
enum DismCompressTpye
{
	//δ֪ѹ
	Compress_Unknown = -1,

	//洢ѹļ
	Compress_None = 0,

	//ѹʽ֧WIMBOOT
	Compress_XpressHuffman = 1,

	//ѹԽʡѹʱ䲢ҿԼύռ
	Compress_Xpress = 2,

	//ѹԽʡռ
	Compress_LZX = 3,

	//ѹǳķʱ䣬С
	Compress_LZMS = 4,
};


enum DismServiceStartType
{
	//δ֪ϵͳҲDism޷ʶͣΪ˰ȫDism++޷޸δ֪Ŀ
	DismServiceStartTypeUnknown = -1,
	//÷Ѿر
	DismServiceStartTypeDisable,
	//÷Ϊֶ
	DismServiceStartTypeManual,
	//÷Զ
	DismServiceStartTypeAuto,
	//÷ӳע_ӳٱǵ޷޸Ϊӳ᷵ز
	DismServiceStartTypeDelayed
};

enum DismSystemStatus
{
	//״̬δ֪
	DismSystemStatusUnknown = -1,
	//׼
	DismSystemStatusReady,
	//ϵͳ֧Dism++
	DismSystemStatusNotSupported,
	//ҲϵͳĿĿ¼޷ʻ·
	DismSystemStatusCannotFind,
	//ѾʧЧҪɾ
	DismSystemStatusNeedRemove,
	//Ե
	DismSystemStatusWait
};


enum DismEnvironmentType
{
	DismEnvironmentDefault = 0, //32λϵͳ32λĿ¼64λϵͳȡ64λ·
	DismEnvironment64Only,    //ȡ64λ·32λϵͳʧܣ
	DismEnvironment86Only,    //Ƿ32λ·
};


enum DismImageHealthState
{
	DismImageHealthy = 0,      //ӳʮֽҪ޸
	DismImageRepairable = 1,   //ӳѾ𣬵ǿ޸
	DismImageNonRepairable = 2 //ӳѾյ⣬޸
};

enum DismServiceType
{
	DismSystemService,    //ϵͳ
	DismAppService,       //Ӧó
	DismDriverService,    //
};


enum ProfileStatus
{
	ProfileStatusDisabled = 0,
	ProfileStatusEnabled = 1,
	ProfileStatusApplied = 2,
	ProfileStatusMax
};

enum StartupType
{
	StartupTypeUnknow = -1,

	//HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Run
	StartupTypeSystemRun,

	//HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Run
	StartupTypeSystemRun32,

	//HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce
	StartupTypeSystemRunOnce,

	//HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\RunOnce
	StartupTypeSystemRunOnce32,

	//HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Run
	StartupTypeUserRun,

	//HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce
	StartupTypeUserRunOnce,

	//%SystemDirve%\ProgramData\Microsoft\Windows\Start Menu\Programs\Startup
	StartupTypeAllUsersStartupFolder,

	//%UserProfile%\AppData\Roaming\Microsoft\Windows\Start Menu\Programs\Startup
	StartupTypeCurrentUserStartupFolder,

	//HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager
	StartupTypeNativeBootExecute,

	//HKEY_USERS\DEFAULT\SOFTWARE\Microsoft\Windows\CurrentVersion\Run
	StartupTypeDefaultUserRun,

	//HKEY_USERS\DEFAULT\SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce
	StartupTypeDefaultUserRunOnce,
};

enum StartupState
{
	StartupStateRemove = -1,
	StartupStateDisable,
	StartupStateEnable,
};

////////////////////////////////////////////////////////////////
//                      ṹ

#pragma pack(push, 1)

struct DismSystem
{
	//ϵͳ״̬
	DismSystemStatus Status;

	/*
	ϵͳCPUϵֵΪ
	PROCESSOR_ARCHITECTURE_AMD64     x64ϵ
	PROCESSOR_ARCHITECTURE_INTEL     x86ϵ
	PROCESSOR_ARCHITECTURE_UNKNOWN   δ֪ϵ*/
	long Architecture;

	//ָʾ
#define _ӳ      0x1     //ΪӳôñΪ1 Ϊ0

	//ʽ
#define _Ӳ      0x2  //ӳڱ
#define _ӳ      0x4  //ӳWIMVHDص

	//ʹõļ
#define _WIMBOOT       0x8  //ӳʹWIMBOOT
#define _VHDװ       0x10  //ӳVHDװ
#define _CompactOs     0x20  //ӳʹCompactOs
#define _WinPE         0x40
	//ûԶ 24~31  Dism++APIԱ֤ʹµĶ
	DWORD Flags;       //Flagsӵϱ־
	DWORD ProductType;          //Ȩ WinNTLanmanNT  ServerNT

	//ϵͳ汾 6.3.9600.17041
	UINT16 Version[4];


	wchar_t ProductName[256];    //ϵͳ
	wchar_t EditionID[256];      //ϵͳ汾

	wchar_t InstallationType[40];      //ϵͳװ
	DWORD DefaultLanguage;      //Ĭʾ
	DWORD InstallLanguage;      //ϵͳװ
	wchar_t InstallLanguageFallback[256];//Իб
	//WIM XMLеFlags
	wchar_t szFlags[256];
	wchar_t RootPath[MAX_PATH];       //ϵͳװλ
	//ӳչ·ڱWIM·ԼVHD· ַַ
	wchar_t ExtendPath[1];
};


struct DismPackage
{
	DismPackageState State;
	wchar_t RestartRequired[40];

	wchar_t ReleaseType[40];
	wchar_t Identity[256];
	wchar_t Name[256];
	wchar_t Description[512];
	wchar_t ProductName[256];
	wchar_t ProductVersion[256];
	wchar_t Company[256];
	wchar_t Copyright[256];
	wchar_t SupportInformation[512];
	wchar_t InstallPackageName[256];
	wchar_t InstallLocation[256];
	wchar_t InstallClient[256];
	wchar_t InstallUserName[256];

	//
	FILETIME CreationTime;
	FILETIME LastUpdateTime;
	FILETIME InstallTime;

	wchar_t FullyOfflineInstallable[256];
	wchar_t ScavengeSequence[40];

	VARIANT_BOOL IsApplicable;
};

struct DismFeature
{
	DismFeatureState State;
	wchar_t RestartRequired[40];
	wchar_t Name[256];
	wchar_t DisplayName[512];
	wchar_t Description[512];
	//DWORD ParentFeatureNameCount;
	wchar_t ParentFeatureName[40];
};

struct DismCapability
{
	DismFeatureState State;
	DWORD DownloadSize;
	DWORD InstallSize;

	wchar_t Name[256];
	wchar_t ID[256];
	wchar_t DisplayName[512];
	wchar_t Description[512];
};


struct DismDriver
{
	wchar_t LocaleName[0x55];
	wchar_t InfProviderName[0x104];
	wchar_t CatalogFile[0x104];
	wchar_t InfPath[0x104];
	wchar_t PublishedInfName[256];
	GUID ClassGuid;
	wchar_t ClassName[0x104];
	wchar_t ClassDescription[256];
	UINT16 Version[4];
	FILETIME Date;
	VARIANT_BOOL InBox;
	VARIANT_BOOL BootCritical;
	VARIANT_BOOL SigStatus;
};


struct DismMountedImage
{
	wchar_t MountDir[MAX_PATH];
	wchar_t ImagePath[MAX_PATH];
	DWORD Index;
	DismMountedImageStatus Status;
	VARIANT_BOOL ReadWritable;
};

struct DismImageInfo
{
	//ϵͳϵ
	long Architecture;

	//
	FILETIME CreationTime;

	//չռ
	UINT64 Space;

	//ϵͳ汾
	UINT16 Version[4];

	//////////////////////////////////////////////////
	//        ޸Ϣ ӳϢ

	//ӳ
	wchar_t Name[256];

	//ӳ˵
	wchar_t Description[512];

	//ʾ
	wchar_t DisplayName[256];

	//ʾ˵
	wchar_t DisplayDescription[512];

	//ӳ汾
	wchar_t Flags[256];
};

struct DismImageFileInfo
{
	//±
	int BootIndex;

	//ļ
	DismImageFileTpye Type;

	//ļΨһʶ
	GUID FileGUID;

	//ѹ
	DismCompressTpye Compression;

	//ӳ
	DWORD ImageInfoCount;

	//ӳ
	DismImageInfo ImageInfo[0];
};

struct DismService
{
	DismServiceType Type;
	/*
	,ֵΪ
	SERVICE_AUTO_START
	SERVICE_BOOT_START
	SERVICE_DEMAND_START
	SERVICE_DISABLED
	SERVICE_SYSTEM_START
	*/
	//ӳ
#define SERVICE_Delay_START 5
	DWORD dwStartType;

#define _ϵͳ 0x00000001
#define _ӳ 0x00000002
#define _ϵͳ 0x00000004
	//Flags ӵ״̬
	DWORD Flags;

	//
	wchar_t Name[256];

	//Ӧʾ
	wchar_t DisplayName[256];

	//Ӧʾ
	wchar_t Description[512];

	//Ӧ·
	wchar_t ImagePath[MAX_PATH];

	//Ӧĵ¼״̬
	wchar_t ObjectName[256];
};


struct AppxPackage
{
	//ǰṹСָһAppxPackageԪ
	DWORD cbData;
	wchar_t FullName[256];
	wchar_t InstalledLocation[MAX_PATH];
	wchar_t Users[1];
};



#pragma pack(pop)



typedef class CCbsHostProxy* DismSession;


#define DISM_MSG_PROGRESS   38008     //ϢwParamΪǰɰٷֱ
#define DISM_MSG_PROCESS    38009     //ָʾļǷӦñwParam = (PWSTR) pszFullPath   lParam = (PBOOL) pfProcessFile
#define DISM_MSG_SCANNING   38010     //ɨļļ wParam=(BOOL)IsDirector   lParam=(UINT)Count
#define DISM_MGS_RemoveInfo 37001     //ָʾļļҪ   wParam=(DWORD)Type    lParam=(LPCWSTR)FilePath
#define Dism_MSG_QUERY_ABORT 38030    //ǷҪжϸò-1 жϵǰS_OKô 

//DismصڷؽȵϢdwMessageIdϼϢ  UserData㴫ָ У뷵 ERROR_SUCCESS
typedef DWORD(WINAPI *DismCallBack)(DWORD dwMessageId, WPARAM wParam, LPARAM lParam, PVOID UserData);


///////////////////////////////////////////////֧////////////////////////////////////////////////
//
//

//ȡָעֵ,úҪʹRegCloseر
HRESULT WINAPI DismRegOpenKeyEx(DismSession Session, HKEY hKey, LPCWSTR lpSubKey, REGSAM samDesired, PHKEY phkResult);

//ֵ
HRESULT WINAPI DismRegCreateKeyEx(DismSession Session, HKEY hKey, LPCWSTR lpSubKey, REGSAM samDesired, PHKEY phkResult, LPDWORD lpdwDisposition);

//ȡָעֵ,úҪʹRegCloseر
HRESULT WINAPI DismRegOpenKey(DismSession Session, HKEY hKey, LPCWSTR lpSubKey, PHKEY phkResult);

//תָĻ
HRESULT WINAPI DismExpandEnvironmentStrings(DismSession Session, LPCWSTR lpSrc, LPBSTR lpDst);

#define DismLogLevelSilent      0    //κϢ
#define DismLogLevelFailure     1    //
#define DismLogLevelWarning     2    //;
#define DismLogLevelInformation 3    //󡢾Ϣ
#define DismLogLevelDebug       4    //ݺ͵
//д־
HRESULT WINAPI DismWriteLog(DWORD LogLevel, LPCWSTR LogName, LPCWSTR LogValue);

//ͷDismӿڵúĿռ
HRESULT WINAPI DismFreeMemory(void* pStruct);

//ݻỰϵͳϢ
HRESULT WINAPI DismGetSystemInfoBySession(DismSession Session, DismSystem** Info);

//·ϵͳϢ
HRESULT WINAPI DismGetSystemInfoByPath(LPCWSTR RootPath, DismSystem** Info);

//ָתΪӦı
HRESULT WINAPI DismFormatMessage(HRESULT hr, LPBSTR ppErrorMessage);

//ȡʱĿ¼
LPCWSTR WINAPI DismGetScratchDir();

BOOL WINAPI DismUnloadRegMount(LPCWSTR RootPath);

//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////°///////////////////////////////////////////////
//
//

//Ӹ°
HRESULT WINAPI DismAddPackage(DismSession Session, LPCWSTR PackageFilePath, DismCallBack CallBack, LPVOID UserData);

//ɾ°
HRESULT WINAPI DismRemovePackage(DismSession Session, LPCWSTR PackageName, DismCallBack CallBack, LPVOID UserData);

//ȡ°Ϣ
//HRESULT WINAPI DismGetPackage(DismSession Session, LPCWSTR PackageIdentity, DismPackage** ppPackageInfo);

//ȡи°
HRESULT WINAPI DismGetPackages(DismSession Session, DismPackage** ppPackages, DWORD* pCount, DismCallBack CallBack, LPVOID UserData);

//
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////





//////////////////////////////////////////////////ܰ/////////////////////////////////////////////////////
//

HRESULT WINAPI DismChangeFeatures(DismSession Session,
	LPCWSTR FeatureNames,  //ҪرյĹ
#define DismLimitAccess 0x00000001   //NT6.1Ч 򿪹ʱҪ΢ļ PS趨ܻӦòصļʧ
	DWORD ChangeFlags,   //رձ־֧״̬
	LPCWSTR SourcePaths,  //NT6.1Ч ָԴʱȴԴļ,ԴNULLָ
	DismCallBack CallBack, LPVOID UserData);

//ȡ״̬
HRESULT WINAPI DismGetFeatures(DismSession Session, DismFeature** ppFeature, LPDWORD pCount, DismCallBack CallBack, LPVOID UserData);

//
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////




//////////////////////////////////////////////////ϵͳ޸///////////////////////////////////////////////////////
//
//

//ɨϵͳǷ
HRESULT WINAPI DismScanHealth(DismSession Session, DismImageHealthState* pImageHealthState, DismCallBack CallBack, PVOID UserData);

//ָϵͳ
HRESULT WINAPI DismRestoreHealth(DismSession Session, LPCWSTR SourcePaths, DismCallBack CallBack, PVOID UserData);

//
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////ѡ///////////////////////////////////////////////////////
//
//
//ӱػȡ
#define CapabilityFlagsPackageStore 0x1
//ӰװԴлȡ
#define CapabilityFlagsLocalSouce   0x2
//ƶ˻ȡ
#define CapabilityFlagsCloud        0x4

//ȡпѡ״̬
HRESULT WINAPI DismGetCapabilities(DismSession Session, DWORD CapabilityFlags, DismCapability** ppCapabilitites, DWORD* pCount);

//ɾѡ
HRESULT WINAPI DismRemoveCapability(DismSession Session, LPCWSTR CapabilityName, DismCallBack CallBack, LPVOID UserData);

//ӿѡ
HRESULT WINAPI DismAddCapability(DismSession Session, LPCWSTR CapabilityName, DismCallBack CallBack, LPVOID UserData);
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////֧//////////////////////////////////////////////////////
//
//

//ȡз
HRESULT WINAPI DismGetServices(DismSession Session, DismService** ppService, DWORD *pCount, DismCallBack CallBack, LPVOID pUserData);

//ɾ
HRESULT WINAPI DismRemoveService(DismSession Session, LPCWSTR Name);

//޸ķ
HRESULT WINAPI DismSetServiceStart(DismSession Session, LPCWSTR Name, DWORD StartType);

//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////////////////////////
//
//

//
HRESULT WINAPI DismAddDriver(DismSession Session, LPCWSTR DriverPath);

//ɾ
HRESULT WINAPI DismRemoveDriver(DismSession Session, LPCWSTR DriverName);

//ȡ
HRESULT WINAPI DismGetDrivers(DismSession Session, DismDriver** ppDrivers, DWORD* pCount, DriverShowEnum DriverShow, DismCallBack CallBack, LPVOID UserData);

//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////////////////////
//
//

//ڲҪĸ
HRESULT WINAPI DismComponentCleanup(DismSession Session, DWORD Reserved, UINT64 *CleanUpSpace, DismCallBack CallBack, LPVOID UserData);

//Լʹõ
HRESULT WINAPI DismDriverCleanup(DismSession Session, DWORD Reserved, UINT64 *CleanUpSpace, DismCallBack CallBack, LPVOID UserData);

//ҪMetro App
HRESULT WINAPI DismAppxsCleanup(DismSession Session, DWORD Reserved, UINT64 *CleanUpSpace, DismCallBack CallBack, LPVOID UserData);

//ϵͳ
HRESULT WINAPI DismCompactOs(DismSession Session, DWORD Reserved, UINT64 *CleanUpSpace, DismCallBack CallBack, LPVOID UserData);

//ʹNTFSӲӺϲͬļСϵͳ
HRESULT WINAPI DismHardLinkMerge(DismSession Session, DWORD Reserved, UINT64 *CleanUpSpace, DismCallBack CallBack, LPVOID UserData);

//Windows¼־
HRESULT WINAPI DismEventLogCleanup(DismSession Session, DWORD Reserved, UINT64 *CleanUpSpace, DismCallBack CallBack, LPVOID UserData);

//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////WIM//////////////////////////////////////////////////
//
//

HRESULT WINAPI DismGetMountedImages(DismMountedImage** ppMountedImages, DWORD* pCount);

//ȡWIMesdVHDļϢ
HRESULT WINAPI DismGetImageFileInfo(LPCWSTR ImageFilePath, DismImageFileInfo** ppFileInfo);

//޸WIMesdļϢ
HRESULT WINAPI DismSetImageFileInfo(LPCWSTR ImageFilePath, DWORD ImageIndex, DismImageInfo* pImageInfo);




#define _ExportCreate            0x00000001	//Ŀļ
/*
ָӳ񣬵DesImageFileʱCompressTpye
SourceImageFileҪӳ·
SourceIndex    Ҫӳ±
DesImageFile   ڴĿӳôʹCompressTpyeָѹȼļļѾڣôCompressTpye
CompressTpye   ѹȼ
ExportFlags    ǣʹ
*/
HRESULT WINAPI DismExportImage(LPCWSTR SourceImageFile, DWORD SourceIndex, LPCWSTR DesImageFile, DWORD ExportFlags, DismCompressTpye CompressTpye, DismCallBack CallBack, LPVOID pUserData);

//ɾWIM ļеӳ
HRESULT WINAPI DismDeleteImage(LPCWSTR FilePath, DWORD DeleteIndex);

//ָ±WIMļΪindxeΪ-1 ô־
HRESULT WINAPI DismSetBootImage(LPCWSTR FilePath, DWORD BootIndex);

#define _CommitAppend               0x00000001
#define _CommitVerify               0x00000002
#define _CommitNoDirAcl             0x00000010
#define _CommitNoFileAcl            0x00000020
#define _CommitNoRpFix              0x00000100

//ύӳCommitFlags ӵ
HRESULT WINAPI DismCommitImage(LPCWSTR MountPath, DWORD CommitFlags, DismCallBack CallBack, LPVOID UserData);


#define _MountFlagReadOnly       0x00000200     //ñǴôΪдأΪֻ
#define _MountFlagOptimize       0x00000400
#define _MountFlagCheckIntegrity 0x00000002
//ָ±ӳFlagsӵ
HRESULT WINAPI DismMountImage(LPCWSTR ImageFilePath, DWORD MountIndex, DWORD MountFlags, LPCWSTR MountPath, DismCallBack CallBack, LPVOID UserData);


#define _ApplyFlags_Verify  0x00000002   //У
#define _ApplyFlags_WIMBoot 0x00002000   //ͷWIMBoot ӳ
#define _ApplyFlags_Compact 0x00004000   //ͷŽӳ
#define _ApplyFlags_WinToGo 0x10000000   //ΪӳWindows To Go
/*PublicKey ʹøKeyڴ*/
HRESULT WINAPI DismApplyImage(LPCWSTR ImageFilePath, DWORD ApplyIndex, DWORD ApplyFlags, LPCWSTR ApplyPath, DismCallBack CallBack, LPVOID UserData);


//жָĿ¼Ĺӳ
HRESULT WINAPI DismUnmountImage(LPCWSTR MountPath, DismCallBack CallBack, LPVOID UserData);


//ܼܵWIMļ
HRESULT WINAPI DismDecryptWimFile(LPCWSTR FilePath, LPCWSTR PublicKey, BOOL TestKey/* ΪTRUE ôKeyܷܴļ*/);

#define _CaptureNew                0x80000000	//½ļɾǰļĬļѾļ
#define _CaptureSnapshot           0x40000000	//ΪĿգʹøñ־Բʹõļһڲϵͳ
#define _CaptureBootable           0x20000000	//WIMļ֧,Windows PEӳΪܹ
#define _CaptureReserved           0x00000001	//WIMļ֧
#define _CaptureVerify             0x00000002	//WIMļ֧
#define _CaptureIndex              0x00000004	//WIMļ֧
#define _CaptureNoApply            0x00000008	//WIMļ֧
#define _CaptureNoDirAcl           0x00000010	//WIMļ֧
#define _CaptureNoFileAcl          0x00000020	//WIMļ֧
#define _CaptureShareWrite         0x00000040	//WIMļ֧
#define _CaptureFileInfo           0x00000080	//WIMļ֧
#define _CaptureNoRpFix            0x00000100	//WIMļ֧
#define _CaptureApplyCiEa          0x00001000	//WIMļ֧
//#define _CaptureWIMBoot            0x00002000	//WIMļ֧֣ɵļʹ WIMBoot á
/*ĳ·ΪWIMesdVHD(X)ļ esdVHD(X)δ֧֣
עDismCompressTpyeWIMļЧ ҽ½ļз*/
HRESULT WINAPI DismCaptureImage(LPCWSTR CapturePath, LPCWSTR ImageFilePath, DismCompressTpye CompressTpye, DWORD CaptureFlags, DismCallBack CallBack, LPVOID UserData, DismImageInfo* pImageInfo);

//ӳ
HRESULT WINAPI DismSplitFile(LPCWSTR ImageFilePath, LPCWSTR SplitFilePath, UINT64 SplitSize, DismCallBack CallBack, LPVOID UserData);

//һesdļתΪISOļ
HRESULT WINAPI DismConversionESD2ISO(LPCWSTR szWimFilePath, LPCWSTR szISOPath, DismCompressTpye CompressTpye, DismCallBack CallBack, LPVOID UserData);

//
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////



//Appx֧
HRESULT WINAPI DismGetAllUsersAppx(DismSession Session, AppxPackage** ppPackages, DWORD* pcbPackages);

HRESULT WINAPI DismRemoveAppx(DismSession Session, LPCWSTR FullName);

HRESULT WINAPI DismGetProvisionedAppxs(DismSession Session, AppxPackage** ppPackages, DWORD* pcbPackages);

HRESULT WINAPI DismRemoveProvisionedAppx(DismSession Session, LPCWSTR FullName);

enum REConfigCode
{
	//RE
	RunREOnly = -2,

	//REгʼ
	InitializeRE = -1,

	//REԶ幤ߣһΣ
	RunCustomToolOnce,

	//ִϵͳԭWindows.btеļƶǰϵͳ
	SystemRestore,

	//Dism++δʹô˹ܡ
	Reservation1,

	//REԶ幤ߣ־
	RunCustomTool,

	MaxREConfigCode,
};

/*RE֧
Code: ִж

BootID:  CodeΪ RunCustomToolOnce RunCustomToolʱЧ˵һ32λֵҪ˳ͻڲ˵

FilePathCodeΪ RunCustomToolOnce RunCustomToolʱЧREҪļ·

CallBackѡص

UserDataѡֵ صUserDataУʹ
*/
HRESULT WINAPI WinREConfig2(REConfigCode Code, DWORD BootID, LPCWSTR FilePath, DismCallBack CallBack, LPVOID UserData);


enum DismFirstBootPhase
{
	DismFirstBootPreSysPrep,
	DismFirstBootPostSysPrep,
	DismFirstBootPreOobe,
	DismFirstBootPostOobe,
};

//IBS֧֣״
HRESULT WINAPI IbsSetFirstBootCommandLine(DismSession Session, DismFirstBootPhase Phase, LPCWSTR CommandLine);


/*AssocSupport
ڵӳļ*/


HRESULT WINAPI DismAppAssociationsDefaultExport(DismSession Session, LPCWSTR FilePath);

HRESULT WINAPI DismAppAssociationsDefaultImport(DismSession Session, LPCWSTR FilePath);

HRESULT WINAPI DismAppAssociationsDefaultRemove(DismSession Session);

HRESULT WINAPI DismAppAssociationsExport(DismSession Session, LPCWSTR FilePath);

HRESULT WINAPI DismAppAssociationsImport(DismSession Session, LPCWSTR FilePath);

HRESULT WINAPI DismAppAssociationsRemove(DismSession Session);



#define CopyWithOptimization 0x1
#define CopyWithVSS          0x2

//һϵͳƵһĿ¼
HRESULT WINAPI DismCopySystem(LPCWSTR Source, LPCWSTR Target, DWORD CompactType, DWORD CopyFlags, DismCallBack CallBack, LPVOID UserData);

/*
ڴDism++ӿ

Session   Dism++Ự
ID        ӿGUIDֵ IPEImageManagerISuStartupCollection
ppUnknown Dism++صĽӿ
*/
HRESULT WINAPI DismCreateInterface(DismSession Session, const GUID& ID, IUnknown** ppUnknown);



//PE
MIDL_INTERFACE("745A9E3A-0DC8-4C44-8AF7-B233576C0B44")
IPEImageManager :public IUnknown
{
public:
	virtual HRESULT WINAPI get_ScratchSpace(unsigned long* pulScratchSpace) = 0;

	virtual HRESULT WINAPI put_ScratchSpace(unsigned long ulScratchSpace) = 0;

	virtual HRESULT WINAPI get_InstallRoot( BSTR* pInstallRoot) = 0;

	virtual HRESULT WINAPI put_InstallRoot(BSTR InstallRoot) = 0;
};


MIDL_INTERFACE("B3DB4480-3E38-4C39-BB44-16D47F8B6FFD")
ISuStartup :public IUnknown
{
public:
	virtual StartupType get_StartupType() = 0;
	virtual LPCWSTR get_Name() = 0;
	virtual HRESULT get_Description(LPBSTR pDescription) = 0;
	virtual HRESULT get_FilePath(LPBSTR pFilePath) = 0;
	virtual LPCWSTR get_CommandLine() = 0;
	virtual HRESULT put_State(StartupState dwState) = 0;
	virtual StartupState get_State() = 0;
};

//ڹ
MIDL_INTERFACE("DCB9FFE1-8E5A-49DE-8CAE-9C9D5C53426F")
ISuStartupCollection : public IUnknown
{
public:
	virtual HRESULT WINAPI get_Count(_Out_ long* pcount) = 0;

	virtual HRESULT WINAPI get_Item(_In_ long Index, _Out_ ISuStartup** pvar) = 0;

	virtual HRESULT WINAPI get__NewEnum(_Outptr_ IUnknown** ppUnk) = 0;
};