/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;

public class CompositeTransferable
implements Transferable {
    private HashMap<DataFlavor, Transferable> transferables = new HashMap();
    private LinkedList<DataFlavor> flavors = new LinkedList();

    public void add(Transferable transferable) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!this.transferables.containsKey(dataFlavorArray[i])) {
                this.flavors.add(dataFlavorArray[i]);
            }
            this.transferables.put(dataFlavorArray[i], transferable);
        }
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        Transferable transferable = this.transferables.get(dataFlavor);
        if (transferable == null) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return transferable.getTransferData(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors.toArray(new DataFlavor[this.transferables.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.transferables.containsKey(dataFlavor);
    }
}

