/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.gui.datatransfer;

import ch.randelshofer.gui.datatransfer.CompositeTransferable;
import ch.randelshofer.gui.datatransfer.PlainTextTransferable;
import ch.randelshofer.gui.datatransfer.StringTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.im.InputContext;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;

public class FileTextFieldTransferHandler
extends TransferHandler {
    private boolean shouldRemove;
    private JTextComponent exportComp;
    private int p0;
    private int p1;
    private int fileSelectionMode;
    private FileFilter fileFilter;

    public FileTextFieldTransferHandler() {
        this(0);
    }

    public FileTextFieldTransferHandler(int n) {
        this(n, null);
    }

    public FileTextFieldTransferHandler(int n, FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        if (n != 2 && n != 0 && n != 1) {
            throw new IllegalArgumentException("illegal file selection mode:" + n);
        }
        this.fileSelectionMode = n;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        Object object;
        Object object2;
        Object object3;
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (jTextComponent == this.exportComp && jTextComponent.getCaretPosition() >= this.p0 && jTextComponent.getCaretPosition() <= this.p1) {
            this.shouldRemove = false;
            return true;
        }
        boolean bl = false;
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            object3 = jTextComponent.getInputContext();
            if (object3 != null) {
                ((InputContext)object3).endComposition();
            }
            try {
                object2 = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (object2.size() > 0) {
                    object = (File)object2.get(0);
                    switch (this.fileSelectionMode) {
                        case 2: {
                            break;
                        }
                        case 0: {
                            if (!((File)object).isDirectory()) break;
                            return false;
                        }
                        case 1: {
                            if (((File)object).isDirectory()) break;
                            return false;
                        }
                    }
                    if (this.fileFilter != null && !this.fileFilter.accept((File)object)) {
                        return false;
                    }
                    jTextComponent.setText(((File)object).getPath());
                }
                bl = true;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
        if (!bl && (object3 = this.getImportFlavor(transferable.getTransferDataFlavors(), jTextComponent)) != null) {
            object2 = jTextComponent.getInputContext();
            if (object2 != null) {
                ((InputContext)object2).endComposition();
            }
            try {
                object = ((DataFlavor)object3).getReaderForText(transferable);
                boolean bl2 = false;
                this.handleReaderImport((Reader)object, jTextComponent, bl2);
                bl = true;
            }
            catch (UnsupportedFlavorException | IOException | BadLocationException exception) {
                // empty catch block
            }
        }
        return bl;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        CompositeTransferable compositeTransferable;
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        this.shouldRemove = true;
        this.p0 = jTextComponent.getSelectionStart();
        this.p1 = jTextComponent.getSelectionEnd();
        if (this.p0 != this.p1) {
            compositeTransferable = new CompositeTransferable();
            String string = jTextComponent.getSelectedText();
            compositeTransferable.add(new StringTransferable(string));
            compositeTransferable.add(new PlainTextTransferable(string));
        } else {
            compositeTransferable = null;
        }
        return compositeTransferable;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
            return false;
        }
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!dataFlavor.isFlavorJavaFileListType() && !dataFlavor.isFlavorTextType()) continue;
            return true;
        }
        return false;
    }

    protected DataFlavor getImportFlavor(DataFlavor[] dataFlavorArray, JTextComponent jTextComponent) {
        DataFlavor dataFlavor = null;
        DataFlavor dataFlavor2 = null;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            String string = dataFlavorArray[i].getMimeType();
            if (string.startsWith("text/plain")) {
                return dataFlavorArray[i];
            }
            if (dataFlavor == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i].getRepresentationClass() == String.class) {
                dataFlavor = dataFlavorArray[i];
                continue;
            }
            if (dataFlavor2 != null || !dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
            dataFlavor2 = dataFlavorArray[i];
        }
        if (dataFlavor != null) {
            return dataFlavor;
        }
        if (dataFlavor2 != null) {
            return dataFlavor2;
        }
        return null;
    }

    protected void handleReaderImport(Reader reader, JTextComponent jTextComponent, boolean bl) throws BadLocationException, IOException {
        if (bl) {
            int n = jTextComponent.getSelectionStart();
            int n2 = jTextComponent.getSelectionEnd();
            int n3 = n2 - n;
            EditorKit editorKit = jTextComponent.getUI().getEditorKit(jTextComponent);
            Document document = jTextComponent.getDocument();
            if (n3 > 0) {
                document.remove(n, n3);
            }
            editorKit.read(reader, document, n);
        } else {
            int n;
            char[] cArray = new char[1024];
            boolean bl2 = false;
            StringBuilder stringBuilder = null;
            while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n);
                }
                int n4 = 0;
                block5: for (int i = 0; i < n; ++i) {
                    switch (cArray[i]) {
                        case '\r': {
                            if (bl2) {
                                if (i == 0) {
                                    stringBuilder.append('\n');
                                    continue block5;
                                }
                                cArray[i - 1] = 10;
                                continue block5;
                            }
                            bl2 = true;
                            continue block5;
                        }
                        case '\n': {
                            if (!bl2) continue block5;
                            if (i > n4 + 1) {
                                stringBuilder.append(cArray, n4, i - n4 - 1);
                            }
                            bl2 = false;
                            n4 = i;
                            continue block5;
                        }
                        default: {
                            if (!bl2) continue block5;
                            if (i == 0) {
                                stringBuilder.append('\n');
                            } else {
                                cArray[i - 1] = 10;
                            }
                            bl2 = false;
                        }
                    }
                }
                if (n4 >= n) continue;
                if (bl2) {
                    if (n4 >= n - 1) continue;
                    stringBuilder.append(cArray, n4, n - n4 - 1);
                    continue;
                }
                stringBuilder.append(cArray, n4, n - n4);
            }
            if (bl2) {
                stringBuilder.append('\n');
            }
            System.out.println("FileTextTransferHandler " + jTextComponent.getSelectionStart() + ".." + jTextComponent.getSelectionEnd());
            jTextComponent.replaceSelection(stringBuilder != null ? stringBuilder.toString() : "");
        }
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (jTextComponent instanceof JPasswordField && jTextComponent.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
            return 0;
        }
        return jTextComponent.isEditable() ? 3 : 1;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (this.shouldRemove && n == 2) {
            try {
                Document document = jTextComponent.getDocument();
                document.remove(this.p0, this.p1 - this.p0);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.exportComp = null;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }
}

