/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ProgressMonitor;
import processing.app.Language;
import processing.app.Platform;

class FFmpegEngine {
    static Pattern framePattern = Pattern.compile("^frame=(\\d+)$");
    Component parent;
    String ffmpegPath;
    static Map<String, String> variantToFilename = new HashMap<String, String>();
    static final String DOWNLOAD_URL;
    static NumberFormat formatter;

    FFmpegEngine(Component component) {
        this.parent = component;
        String string = this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile();
        string = URLDecoder.decode(string, StandardCharsets.UTF_8);
        File file = new File(string).getParentFile();
        String string2 = Platform.isWindows() ? "ffmpeg.exe" : "ffmpeg";
        File file2 = new File(file, string2);
        this.ffmpegPath = file2.getAbsolutePath();
        if (!file2.exists()) {
            // empty if block
        }
    }

    String[] getFormats() {
        return new String[]{"MPEG-4", "MPEG-4 (Lossless 4:2:0)", "MPEG-4 (Lossless 4:4:4)", "Apple ProRes 4444", "Animated GIF", "Animated GIF (Loop)"};
    }

    void write(File file, File[] fileArray, File file2, int n, int n2, double d, String string2) throws IOException {
        File file3 = File.createTempFile("listing", ".txt");
        PrintWriter printWriter = new PrintWriter(new FileWriter(file3));
        for (File object2 : fileArray) {
            printWriter.println("file '" + object2.getAbsolutePath() + "'");
        }
        printWriter.flush();
        printWriter.close();
        Object object3 = file.getAbsolutePath();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.ffmpegPath);
        arrayList.add("-y");
        arrayList.add("-r");
        arrayList.add(String.valueOf(d));
        arrayList.add("-f");
        arrayList.add("image2");
        arrayList.add("-safe");
        arrayList.add("0");
        arrayList.add("-f");
        arrayList.add("concat");
        arrayList.add("-i");
        arrayList.add(file3.getAbsolutePath());
        arrayList.add("-progress");
        arrayList.add("pipe:2");
        String string3 = "fps=" + d;
        if (n != 0 && n2 != 0) {
            string3 = string3 + ",scale=" + n + ":" + n2 + ":flags=lanczos";
        }
        if (file2 != null && !string2.contains("GIF")) {
            arrayList.add("-i");
            arrayList.add(file2.getAbsolutePath());
        }
        if (string2.startsWith("MPEG-4")) {
            arrayList.add("-vcodec");
            arrayList.add("libx264");
            if (string2.contains("4:2:0")) {
                arrayList.add("-pix_fmt");
                arrayList.add("yuv420p");
                arrayList.add("-preset");
                arrayList.add("ultrafast");
                arrayList.add("-crf");
                arrayList.add("0");
            } else if (string2.contains("4:4:4")) {
                arrayList.add("-pix_fmt");
                arrayList.add("yuv444p");
                arrayList.add("-profile:v");
                arrayList.add("high444");
                arrayList.add("-preset:v");
                arrayList.add("slow");
                arrayList.add("-crf");
                arrayList.add("0");
            } else {
                arrayList.add("-pix_fmt");
                arrayList.add("yuv420p");
                arrayList.add("-crf");
                arrayList.add("21");
            }
            if (n != 0 && n2 != 0) {
                arrayList.add("-vf");
                arrayList.add(string3);
            }
            if (file2 != null) {
                arrayList.add("-acodec");
                arrayList.add("aac");
            }
            arrayList.add("-movflags");
            arrayList.add("faststart");
            if (!((String)object3).toLowerCase().endsWith(".mp4")) {
                object3 = (String)object3 + ".mp4";
            }
        } else if (string2.contains("ProRes 4444")) {
            arrayList.add("-c:v");
            arrayList.add("prores_ks");
            arrayList.add("-profile:v");
            arrayList.add("4");
            arrayList.add("-vendor");
            arrayList.add("apl0");
            arrayList.add("-bits_per_mb");
            arrayList.add("8000");
            arrayList.add("-pix_fmt");
            arrayList.add("yuva444p10le");
            if (file2 != null) {
                arrayList.add("-c:a");
                arrayList.add("copy");
            }
            if (!((String)object3).toLowerCase().endsWith(".mov")) {
                object3 = (String)object3 + ".mov";
            }
        } else if (string2.startsWith("Animated GIF")) {
            string3 = string3 + ",split[s0][s1];[s0]palettegen[p];[s1][p]paletteuse";
            arrayList.add("-vf");
            arrayList.add(string3);
            arrayList.add("-loop");
            arrayList.add(string2.contains("Loop") ? "0" : "-1");
            if (!((String)object3).toLowerCase().endsWith(".gif")) {
                object3 = (String)object3 + ".gif";
            }
        }
        arrayList.add((String)object3);
        String string4 = new File((String)object3).getName();
        String string5 = FFmpegEngine.nfc(fileArray.length);
        ProgressMonitor progressMonitor = new ProgressMonitor(this.parent, Language.interpolate((String)"movie_maker.progress.creating_file_name", (Object[])new Object[]{string4}), Language.interpolate((String)"movie_maker.progress.handling_frame", (Object[])new Object[]{string5, string5}), 0, fileArray.length);
        Process process = new ProcessBuilder(arrayList).start();
        StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), System.out::println);
        StreamGobbler streamGobbler2 = new StreamGobbler(process.getErrorStream(), string -> {
            Matcher matcher = framePattern.matcher((CharSequence)string);
            if (matcher.find()) {
                int n = Integer.parseInt(matcher.group(1));
                progressMonitor.setNote(Language.interpolate((String)"movie_maker.progress.handling_frame", (Object[])new Object[]{FFmpegEngine.nfc(n + 1), FFmpegEngine.nfc(fileArray.length)}));
                progressMonitor.setProgress(n);
            }
        });
        new Thread(streamGobbler).start();
        new Thread(streamGobbler2).start();
        try {
            int interruptedException = process.waitFor();
            if (interruptedException != 0) {
                throw new IOException("Unknown error while creating movie. (FFmpeg result was " + interruptedException + ")");
            }
            progressMonitor.close();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static String nfc(int n) {
        return formatter.format(n);
    }

    static {
        variantToFilename.put("macos-x86_64", "darwin-x64");
        variantToFilename.put("macos-aarch64", "darwin-arm64");
        variantToFilename.put("windows-amd64", "win32-x64");
        variantToFilename.put("linux-amd64", "linux-x64");
        variantToFilename.put("linux-arm", "linux-arm");
        variantToFilename.put("linux-aarch64", "linux-arm64");
        DOWNLOAD_URL = "https://github.com/eugeneware/ffmpeg-static/releases/download/b5.0.1/" + variantToFilename.get(Platform.getVariant()) + ".gz";
        formatter = NumberFormat.getInstance();
    }

    static class StreamGobbler
    implements Runnable {
        private final InputStream inputStream;
        private final Consumer<String> consumeInputLine;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumeInputLine = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumeInputLine);
        }
    }
}

