/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import ch.randelshofer.gui.datatransfer.FileTextFieldTransferHandler;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import processing.app.Base;
import processing.app.Language;
import processing.app.Platform;
import processing.app.tools.Chooser;
import processing.app.tools.FFmpegEngine;
import processing.app.tools.Tool;

public class MovieMaker
extends JFrame
implements Tool {
    private Preferences prefs;
    private FFmpegEngine engine;
    int width;
    int height;
    private JComboBox<String> compressionBox;
    private JLabel compressionLabel;
    private JTextField fpsField;
    private JLabel fpsLabel;
    private JTextField heightField;
    private JLabel heightLabel;
    private JTextField imageFolderField;
    private JCheckBox originalSizeCheckBox;
    private JTextField soundFileField;
    private JTextField widthField;
    private JLabel widthLabel;
    private JButton createMovieButton;

    public String getMenuTitle() {
        return Language.text((String)"movie_maker");
    }

    public void run() {
        this.setVisible(true);
    }

    public void init(Base base) {
        JComponent[] jComponentArray;
        this.engine = new FFmpegEngine(this);
        this.initComponents(base == null);
        ((JComponent)this.getContentPane()).setBorder(new EmptyBorder(12, 18, 18, 18));
        this.imageFolderField.setTransferHandler(new FileTextFieldTransferHandler(1));
        this.soundFileField.setTransferHandler(new FileTextFieldTransferHandler());
        for (JComponent jComponent : jComponentArray = new JComponent[]{this.compressionBox, this.compressionLabel, this.fpsField, this.fpsLabel, this.widthField, this.widthLabel, this.heightField, this.heightLabel, this.originalSizeCheckBox}) {
            jComponent.putClientProperty("JComponent.sizeVariant", "small");
        }
        this.prefs = Preferences.userNodeForPackage(MovieMaker.class);
        this.imageFolderField.setText(this.prefs.get("movie.imageFolder", ""));
        this.soundFileField.setText(this.prefs.get("movie.soundFile", ""));
        this.widthField.setText("" + this.prefs.getInt("movie.width", 640));
        this.heightField.setText("" + this.prefs.getInt("movie.height", 480));
        boolean bl = this.prefs.getBoolean("movie.originalSize", false);
        this.originalSizeCheckBox.setSelected(bl);
        this.widthField.setEnabled(!bl);
        this.heightField.setEnabled(!bl);
        Object object = "" + this.prefs.getDouble("movie.fps", 30.0);
        if (((String)object).endsWith(".0")) {
            object = ((String)object).substring(0, ((String)object).length() - 2);
        }
        this.fpsField.setText((String)object);
        this.compressionBox.setSelectedIndex(Math.max(0, Math.min(this.compressionBox.getItemCount() - 1, this.prefs.getInt("movie.compression", 0))));
        this.originalSizeCheckBox.addActionListener(actionEvent -> {
            boolean bl = !this.originalSizeCheckBox.isSelected();
            this.widthField.setEnabled(bl);
            this.heightField.setEnabled(bl);
        });
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public static void registerWindowCloseKeys(JRootPane jRootPane, ActionListener actionListener) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        keyStroke = KeyStroke.getKeyStroke(87, n);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
    }

    private void initComponents(boolean bl) {
        JLabel jLabel = new JLabel();
        this.imageFolderField = new JTextField();
        JButton jButton = new JButton();
        JLabel jLabel2 = new JLabel();
        this.soundFileField = new JTextField();
        JButton jButton2 = new JButton();
        this.createMovieButton = new JButton();
        this.widthLabel = new JLabel();
        this.widthField = new JTextField();
        this.heightLabel = new JLabel();
        this.heightField = new JTextField();
        this.compressionLabel = new JLabel();
        this.compressionBox = new JComboBox();
        this.fpsLabel = new JLabel();
        this.fpsField = new JTextField();
        this.originalSizeCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MovieMaker.this.setVisible(false);
            }
        });
        MovieMaker.registerWindowCloseKeys(this.getRootPane(), actionEvent -> {
            if (bl) {
                System.exit(0);
            } else {
                this.setVisible(false);
            }
        });
        this.setTitle(Language.text((String)"movie_maker.two.title"));
        JLabel jLabel3 = new JLabel(Language.text((String)"movie_maker.two.blurb"));
        jLabel.setText(Language.text((String)"movie_maker.image_folder_help_label"));
        jButton.setText(Language.text((String)"movie_maker.choose_button"));
        jButton.addActionListener(actionEvent -> Chooser.selectFolder(this, Language.text((String)"movie_maker.select_image_folder"), new File(this.imageFolderField.getText()), new Chooser.Callback(){

            @Override
            void select(File file) {
                if (file != null) {
                    MovieMaker.this.imageFolderField.setText(file.getAbsolutePath());
                }
            }
        }));
        jLabel2.setText(Language.text((String)"movie_maker.sound_file_help_label"));
        jButton2.setText(Language.text((String)"movie_maker.choose_button"));
        jButton2.addActionListener(actionEvent -> Chooser.selectInput(this, Language.text((String)"movie_maker.select_sound_file"), new File(this.soundFileField.getText()), new Chooser.Callback(){

            @Override
            void select(File file) {
                if (file != null) {
                    MovieMaker.this.soundFileField.setText(file.getAbsolutePath());
                }
            }
        }));
        this.createMovieButton.setText(Language.text((String)"movie_maker.create_movie_button"));
        this.createMovieButton.addActionListener(actionEvent -> {
            String string = this.prefs.get("movie.outputFile", null);
            File file = string == null ? null : new File(string);
            Chooser.selectOutput(this, Language.text((String)"movie_maker.save_dialog_prompt"), file, new Chooser.Callback(){

                @Override
                void select(File file) {
                    MovieMaker.this.createMovie(file);
                }
            });
        });
        Font font = new Font("Dialog", 0, 11);
        this.widthLabel.setFont(font);
        this.widthLabel.setText(Language.text((String)"movie_maker.width"));
        this.widthField.setColumns(4);
        this.widthField.setFont(font);
        this.widthField.setText("320");
        this.heightLabel.setFont(font);
        this.heightLabel.setText(Language.text((String)"movie_maker.height"));
        this.heightField.setColumns(4);
        this.heightField.setFont(font);
        this.heightField.setText("240");
        this.compressionLabel.setFont(font);
        this.compressionLabel.setText(Language.text((String)"movie_maker.compression"));
        this.compressionBox.setFont(font);
        this.compressionBox.setModel(new DefaultComboBoxModel<String>(this.engine.getFormats()));
        this.fpsLabel.setFont(font);
        this.fpsLabel.setText(Language.text((String)"movie_maker.framerate"));
        this.fpsField.setColumns(4);
        this.fpsField.setFont(font);
        this.fpsField.setText("30");
        this.originalSizeCheckBox.setFont(font);
        this.originalSizeCheckBox.setText(Language.text((String)"movie_maker.orig_size_button"));
        this.originalSizeCheckBox.setToolTipText(Language.text((String)"movie_maker.orig_size_tooltip"));
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(61, 61, 61).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.widthLabel).addComponent(this.fpsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.fpsField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.compressionLabel).addGap(1, 1, 1).addComponent(this.compressionBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.originalSizeCheckBox)).addGroup(groupLayout.createSequentialGroup().addComponent(this.widthField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.heightLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.heightField, -2, -1, -2))).addGap(41, 41, 41)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel3, -1, 484, Short.MAX_VALUE).addComponent(jLabel).addComponent(jLabel2).addGroup(groupLayout.createSequentialGroup().addComponent(this.soundFileField, -1, 372, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jButton2)).addComponent(this.createMovieButton, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.imageFolderField, -1, 372, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jButton)))).addGroup(groupLayout.createSequentialGroup().addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(jLabel3, -2, -1, -2).addGap(18, 18, 18).addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.imageFolderField, -2, -1, -2).addComponent(jButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.widthLabel).addComponent(this.widthField, -2, -1, -2).addComponent(this.heightLabel).addComponent(this.heightField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.compressionBox, -2, -1, -2).addComponent(this.fpsLabel).addComponent(this.fpsField, -2, -1, -2).addComponent(this.compressionLabel).addComponent(this.originalSizeCheckBox)).addGap(18, 18, 18).addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.soundFileField, -2, -1, -2).addComponent(jButton2)).addGap(18, 18, 18).addComponent(this.createMovieButton).addContainerGap()));
        this.pack();
    }

    private void createMovie(final File file) {
        double d;
        File file2;
        if (file == null) {
            return;
        }
        this.createMovieButton.setEnabled(false);
        final File file3 = this.soundFileField.getText().trim().length() == 0 ? null : new File(this.soundFileField.getText().trim());
        File file4 = file2 = this.imageFolderField.getText().trim().length() == 0 ? null : new File(this.imageFolderField.getText().trim());
        if (file3 == null && file2 == null) {
            JOptionPane.showMessageDialog(this, Language.text((String)"movie_maker.error.need_input"));
            return;
        }
        try {
            this.width = Integer.parseInt(this.widthField.getText());
            this.height = Integer.parseInt(this.heightField.getText());
            d = Double.parseDouble(this.fpsField.getText());
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(this, Language.text((String)"movie_maker.error.badnumbers"));
            return;
        }
        if (this.width < 1 || this.height < 1 || d < 1.0) {
            JOptionPane.showMessageDialog(this, Language.text((String)"movie_maker.error.badnumbers"));
            return;
        }
        this.prefs.put("movie.imageFolder", this.imageFolderField.getText());
        this.prefs.put("movie.soundFile", this.soundFileField.getText());
        this.prefs.putInt("movie.width", this.width);
        this.prefs.putInt("movie.height", this.height);
        this.prefs.putDouble("movie.fps", d);
        this.prefs.putInt("movie.compression", this.compressionBox.getSelectedIndex());
        this.prefs.putBoolean("movie.originalSize", this.originalSizeCheckBox.isSelected());
        final boolean bl = this.originalSizeCheckBox.isSelected();
        new SwingWorker<Throwable, Object>(){

            @Override
            protected Throwable doInBackground() {
                try {
                    if (file2 != null) {
                        Object[] objectArray = file2.listFiles(new FileFilter(){
                            final FileSystemView fsv = FileSystemView.getFileSystemView();

                            @Override
                            public boolean accept(File file) {
                                return file.isFile() && !this.fsv.isHiddenFile(file) && !file.getName().equals("Thumbs.db");
                            }
                        });
                        if (objectArray == null || objectArray.length == 0) {
                            return new RuntimeException(Language.text((String)"movie_maker.error.no_images_found"));
                        }
                        Arrays.sort(objectArray);
                        if (bl) {
                            MovieMaker.this.width = 0;
                            MovieMaker.this.height = 0;
                        }
                        if (file.exists() && !file.delete()) {
                            return new RuntimeException("Could not replace " + file.getAbsolutePath());
                        }
                        String string = (String)MovieMaker.this.compressionBox.getSelectedItem();
                        MovieMaker.this.engine.write(file, (File[])objectArray, file3, MovieMaker.this.width, MovieMaker.this.height, d, string);
                    }
                    return null;
                }
                catch (Throwable throwable) {
                    return throwable;
                }
            }

            @Override
            protected void done() {
                Throwable throwable;
                try {
                    throwable = (Throwable)this.get();
                }
                catch (Exception exception) {
                    throwable = exception;
                }
                if (throwable != null) {
                    throwable.printStackTrace();
                    JOptionPane.showMessageDialog(MovieMaker.this, Language.text((String)"movie_maker.error.movie_failed") + "\n" + (throwable.getMessage() == null ? throwable.toString() : throwable.getMessage()), Language.text((String)"movie_maker.error.sorry"), 0);
                }
                MovieMaker.this.createMovieButton.setEnabled(true);
            }
        }.execute();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(() -> {
            Base.setCommandLine();
            Platform.init();
            MovieMaker movieMaker = new MovieMaker();
            movieMaker.init(null);
            movieMaker.setVisible(true);
        });
    }
}

