/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Util;
import processing.core.PApplet;
import processing.data.StringList;

public class Language {
    protected static final String PREF_FILE = "language.txt";
    protected static final File prefFile = Base.getSettingsFile("language.txt");
    private static volatile Language instance;
    private String language;
    private final Map<String, String> languages;
    private LanguageBundle bundle;

    private Language() {
        String origLanguage = this.language = Language.loadLanguage();
        this.languages = new HashMap<String, String>();
        for (String code : Language.listSupported()) {
            Locale locale = Locale.forLanguageTag(code);
            this.languages.put(code, locale.getDisplayName(locale));
        }
        if (!this.languages.containsKey(this.language)) {
            this.language = null;
        }
        if (this.language == null) {
            Locale defaultLocale = Locale.getDefault();
            String shortCode = defaultLocale.getLanguage();
            String fullCode = shortCode + "-" + defaultLocale.getCountry();
            if (this.languages.containsKey(fullCode)) {
                this.language = fullCode;
            } else if (this.languages.containsKey(shortCode)) {
                this.language = shortCode;
            }
        }
        if (this.language == null) {
            this.language = "en";
        }
        if (!this.language.equals(origLanguage)) {
            Language.saveLanguage(this.language);
        }
        try {
            this.bundle = new LanguageBundle(this.language);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String[] listSupported() {
        StringList supported;
        block4: {
            supported = new StringList();
            try {
                File baseFolder = Base.getLibFile("languages");
                String[] names = baseFolder.list();
                if (names != null) {
                    for (String filename : names) {
                        if (!filename.startsWith("PDE_") || !filename.endsWith(".properties")) continue;
                        int dotIndex = filename.lastIndexOf(".properties");
                        String language = filename.substring(4, dotIndex);
                        supported.append(language);
                    }
                    break block4;
                }
                throw new IOException("Could not read list of files inside " + baseFolder);
            }
            catch (IOException e) {
                Messages.showError("Translation Trouble", "There was a problem reading the language translations folder.\nYou may need to reinstall, or report if the problem persists.", e);
            }
        }
        return supported.toArray();
    }

    private static String loadLanguage() {
        try {
            if (prefFile.exists()) {
                String language;
                String[] lines = PApplet.loadStrings((File)prefFile);
                if (lines != null && lines.length > 0 && (language = lines[0].trim()).length() != 0) {
                    return language;
                }
                System.err.println("Using default language because of a problem while reading " + prefFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void saveLanguage(String language) {
        try {
            Util.saveFile(language, prefFile);
            boolean ok = prefFile.setWritable(true, false);
            if (!ok) {
                System.err.println("Warning: could not set " + prefFile + " to writable");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Platform.saveLanguage(language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Language init() {
        if (instance != null) return instance;
        Class<Language> clazz = Language.class;
        synchronized (Language.class) {
            if (instance != null) return instance;
            instance = new Language();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static String get(String key) {
        LanguageBundle bundle = Language.init().bundle;
        try {
            String value = bundle.getString(key);
            if (value != null) {
                return value;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    public static String text(String key) {
        String value = Language.get(key);
        if (value == null) {
            return key;
        }
        return value;
    }

    public static String interpolate(String key, Object ... arguments) {
        String value = Language.get(key);
        if (value == null) {
            return key;
        }
        return String.format(value, arguments);
    }

    public static String pluralize(String key, int count) {
        String customKey = key + "." + count;
        String value = Language.get(customKey);
        if (value != null) {
            return String.format(value, count);
        }
        return Language.interpolate(key + ".n", count);
    }

    public static String getPrompt(String which) {
        return Language.text("prompt." + which);
    }

    public static Map<String, String> getLanguages() {
        return Language.init().languages;
    }

    public static String getLanguage() {
        return Language.init().language;
    }

    public static boolean useInputMethod() {
        String language = Language.getLanguage();
        return language.equals("ja") || language.equals("ko") || language.equals("zh");
    }

    public static void addModeStrings(Mode mode) {
        String baseFilename = "languages/mode.properties";
        File modeBaseFile = new File(mode.getFolder(), baseFilename);
        if (modeBaseFile.exists()) {
            Language.init().bundle.read(modeBaseFile, true);
        }
        String langFilename = "languages/mode_" + Language.instance.language + ".properties";
        File modeLangFile = new File(mode.getFolder(), langFilename);
        if (modeLangFile.exists()) {
            Language.init().bundle.read(modeLangFile, true);
        }
    }

    static class LanguageBundle {
        Map<String, String> table = new HashMap<String, String>();

        LanguageBundle(String language) throws IOException {
            String baseFilename = "languages/PDE.properties";
            String langFilename = "languages/PDE_" + language + ".properties";
            File baseFile = Base.getLibFile(baseFilename);
            File langFile = Base.getLibFile(langFilename);
            this.read(baseFile);
            this.read(langFile);
        }

        void read(File additions) {
            this.read(additions, false);
        }

        void read(File additions, boolean enforcePrefix) {
            String prefix = null;
            String[] lines = PApplet.loadStrings((File)additions);
            if (lines != null) {
                for (String line : lines) {
                    int equals;
                    if (line.length() == 0 || line.charAt(0) == '#' || (equals = line.indexOf(61)) == -1) continue;
                    String key = line.substring(0, equals).trim();
                    boolean ignore = false;
                    if (enforcePrefix) {
                        if (prefix == null) {
                            prefix = key.substring(0, key.indexOf(46) + 1);
                            if (prefix.length() == 0) {
                                System.err.println("Language strings in Modes must include a prefix for all entries.");
                                System.err.println(additions + " will be ignored.");
                                return;
                            }
                        } else if (!key.startsWith(prefix)) {
                            System.err.println("Ignoring " + key + " because all entries in " + additions + " must begin with " + prefix);
                            ignore = true;
                        }
                    }
                    if (ignore) continue;
                    String value = line.substring(equals + 1).trim();
                    value = value.replaceAll("\\\\n", "\n");
                    value = value.replaceAll("\\\\'", "'");
                    this.table.put(key, value);
                }
            } else {
                System.err.println("Unable to read " + additions);
            }
        }

        String getString(String key) {
            return this.table.get(key);
        }
    }
}

