/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import processing.app.Base;
import processing.app.Language;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Settings;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.app.Util;
import processing.app.contrib.ContributionManager;
import processing.app.syntax.PdeTokenMarker;
import processing.app.syntax.TokenMarker;
import processing.app.ui.Editor;
import processing.app.ui.EditorException;
import processing.app.ui.EditorState;
import processing.app.ui.ExamplesFrame;
import processing.app.ui.Recent;
import processing.app.ui.Toolkit;
import processing.core.PApplet;

public abstract class Mode {
    protected Base base;
    protected File folder;
    protected TokenMarker tokenMarker;
    protected Map<String, String> keywordToReference = new HashMap<String, String>();
    protected Settings theme;
    protected Map<String, List<Library>> importToLibraryTable;
    protected JMenu importMenu;
    protected ExamplesFrame examplesFrame;
    protected JMenu toolbarMenu;
    protected File examplesFolder;
    protected File librariesFolder;
    protected File referenceFolder;
    public List<Library> coreLibraries;
    public List<Library> contribLibraries;
    public List<Library> foundationLibraries = new ArrayList<Library>();
    protected Library coreLibrary;
    protected ClassLoader classLoader;
    protected int importMenuIndex = -1;

    public Mode(Base base, File folder) {
        this.base = base;
        this.folder = folder;
        this.tokenMarker = this.createTokenMarker();
        this.examplesFolder = new File(folder, "examples");
        this.librariesFolder = new File(folder, "libraries");
        this.referenceFolder = new File(folder, "reference");
        this.rebuildLibraryList();
        try {
            for (File file : this.getKeywordFiles()) {
                this.loadKeywords(file);
            }
        }
        catch (IOException e) {
            Messages.showWarning("Problem loading keywords", "Could not load keywords file for " + this.getTitle() + " mode.", e);
        }
    }

    public File[] getKeywordFiles() {
        return new File[]{new File(this.folder, "keywords.txt")};
    }

    protected void loadKeywords(File keywordFile) throws IOException {
        this.loadKeywords(keywordFile, "#");
    }

    protected void loadKeywords(File keywordFile, String commentPrefix) throws IOException {
        String[] lines = PApplet.loadStrings((File)keywordFile);
        if (lines != null) {
            for (String line : lines) {
                boolean seen;
                String htmlFilename;
                String[] pieces;
                if (line.trim().startsWith(commentPrefix) || (pieces = PApplet.splitTokens((String)line)).length < 2) continue;
                Object keyword = pieces[0];
                String coloring = pieces[1];
                if (coloring.length() > 0) {
                    this.tokenMarker.addColoring((String)keyword, coloring);
                }
                if (pieces.length != 3 || (htmlFilename = pieces[2]).length() <= 0) continue;
                if (htmlFilename.endsWith("_")) {
                    keyword = (String)keyword + "_";
                }
                if ((seen = this.keywordToReference.containsKey(keyword)) && !((String)keyword).equals(htmlFilename)) continue;
                this.keywordToReference.put((String)keyword, htmlFilename);
            }
        } else {
            System.err.println("Could not read " + keywordFile);
        }
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public File getContentFile(String path) {
        return new File(this.folder, path);
    }

    public InputStream getContentStream(String path) throws FileNotFoundException {
        return new FileInputStream(this.getContentFile(path));
    }

    public File addTemplateFiles(File sketchFolder, String sketchName) throws IOException {
        File newbieFile = new File(sketchFolder, sketchName + "." + this.getDefaultExtension());
        try {
            File templateFolder = this.checkSketchbookTemplate();
            if (templateFolder == null) {
                templateFolder = this.getTemplateFolder();
            }
            if (templateFolder.exists()) {
                Util.copyDir(templateFolder, sketchFolder);
                File templateFile = new File(sketchFolder, "sketch." + this.getDefaultExtension());
                if (!templateFile.renameTo(newbieFile)) {
                    System.err.println("Error while assigning the sketch template.");
                }
            } else if (!newbieFile.createNewFile()) {
                System.err.println(newbieFile + " already exists.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newbieFile;
    }

    protected File checkSketchbookTemplate() {
        File template;
        File user = new File(Base.getSketchbookTemplatesFolder(), this.getTitle());
        if (user.exists() && (template = new File(user, "sketch." + this.getDefaultExtension())).exists() && template.canRead()) {
            return user;
        }
        return null;
    }

    public File getTemplateFolder() {
        return this.getContentFile("template");
    }

    public abstract String getTitle();

    public String getIdentifier() {
        return this.getClass().getCanonicalName();
    }

    public abstract Editor createEditor(Base var1, String var2, EditorState var3) throws EditorException;

    public File getFolder() {
        return this.folder;
    }

    public File getExamplesFolder() {
        return this.examplesFolder;
    }

    public File getLibrariesFolder() {
        return this.librariesFolder;
    }

    public File getReferenceFolder() {
        return this.referenceFolder;
    }

    public void rebuildLibraryList() {
        HashMap<String, List<Library>> newTable = new HashMap<String, List<Library>>();
        Library core = this.getCoreLibrary();
        if (core != null) {
            core.addPackageList(newTable);
        }
        this.coreLibraries = Library.list(this.librariesFolder);
        File contribLibrariesFolder = Base.getSketchbookLibrariesFolder();
        this.contribLibraries = Library.list(contribLibrariesFolder);
        this.foundationLibraries = new ArrayList<Library>();
        for (Library lib : this.contribLibraries) {
            if (!lib.isFoundation()) continue;
            this.foundationLibraries.add(lib);
        }
        this.coreLibraries.addAll(this.foundationLibraries);
        this.contribLibraries.removeAll(this.foundationLibraries);
        for (Library lib : this.coreLibraries) {
            lib.addPackageList(newTable);
        }
        for (Library lib : this.contribLibraries) {
            lib.addPackageList(newTable);
        }
        this.importToLibraryTable = Collections.unmodifiableMap(newTable);
        if (this.base != null) {
            this.base.getEditors().forEach(Editor::librariesChanged);
        }
    }

    public Library getCoreLibrary() {
        return null;
    }

    public Library getLibrary(String pkgName) throws SketchException {
        List<Library> libraries = this.importToLibraryTable.get(pkgName);
        if (libraries == null) {
            return null;
        }
        if (libraries.size() > 1) {
            String primary = "More than one library is competing for this sketch.";
            String secondary = "The import " + pkgName + " points to multiple libraries:<br>";
            for (Library library : libraries) {
                String location = library.getPath();
                if (location.startsWith(this.getLibrariesFolder().getAbsolutePath())) {
                    location = "part of Processing";
                }
                secondary = secondary + "<b>" + library.getName() + "</b> (" + location + ")<br>";
            }
            secondary = secondary + "Extra libraries need to be removed before this sketch can be used.";
            Messages.showWarningTiered("Duplicate Library Problem", primary, secondary, null);
            throw new SketchException("Duplicate libraries found for " + pkgName + ".");
        }
        return libraries.get(0);
    }

    public JMenu getToolbarMenu() {
        if (this.toolbarMenu == null) {
            this.rebuildToolbarMenu();
        }
        return this.toolbarMenu;
    }

    public void insertToolbarRecentMenu() {
        if (this.toolbarMenu == null) {
            this.rebuildToolbarMenu();
        } else {
            this.toolbarMenu.insert(Recent.getToolbarMenu(), 1);
        }
    }

    public void removeToolbarRecentMenu() {
        this.toolbarMenu.remove(Recent.getToolbarMenu());
    }

    protected void rebuildToolbarMenu() {
        if (this.toolbarMenu == null) {
            this.toolbarMenu = new JMenu();
        } else {
            this.toolbarMenu.removeAll();
        }
        JMenuItem item = Toolkit.newJMenuItem("Open...", 79);
        item.addActionListener(e -> this.base.handleOpenPrompt());
        this.toolbarMenu.add(item);
        this.insertToolbarRecentMenu();
        item = Toolkit.newJMenuItemShift("Examples...", 79);
        item.addActionListener(e -> this.showExamplesFrame());
        this.toolbarMenu.add(item);
        item = new JMenuItem(Language.text("examples.add_examples"));
        item.addActionListener(e -> ContributionManager.openExamples());
        this.toolbarMenu.add(item);
        this.toolbarMenu.addSeparator();
        this.base.populateSketchbookMenu(this.toolbarMenu);
    }

    public void removeImportMenu(JMenu sketchMenu) {
        JMenu importMenu = this.getImportMenu();
        this.importMenuIndex = Toolkit.getMenuItemIndex(sketchMenu, importMenu);
        sketchMenu.remove(importMenu);
    }

    public void insertImportMenu(JMenu sketchMenu) {
        if (this.importMenuIndex != -1) {
            sketchMenu.insert(this.getImportMenu(), this.importMenuIndex);
        }
    }

    public JMenu getImportMenu() {
        if (this.importMenu == null) {
            this.rebuildImportMenu();
        }
        return this.importMenu;
    }

    public void rebuildImportMenu() {
        if (this.importMenu == null) {
            this.importMenu = new JMenu(Language.text("menu.library"));
        } else {
            this.importMenu.removeAll();
        }
        JMenuItem manageLibs = new JMenuItem(Language.text("menu.library.manage_libraries"));
        manageLibs.addActionListener(e -> ContributionManager.openLibraries());
        this.importMenu.add(manageLibs);
        this.importMenu.addSeparator();
        this.rebuildLibraryList();
        ActionListener listener = e -> this.base.activeEditor.handleImportLibrary(e.getActionCommand());
        if (this.coreLibraries.size() == 0) {
            JMenuItem item = new JMenuItem(this.getTitle() + " " + Language.text("menu.library.no_core_libraries"));
            item.setEnabled(false);
            this.importMenu.add(item);
        } else {
            for (Library library : this.coreLibraries) {
                JMenuItem item = new JMenuItem(library.getName());
                item.addActionListener(listener);
                item.setActionCommand(library.getName());
                this.importMenu.add(item);
            }
        }
        if (this.contribLibraries.size() != 0) {
            this.importMenu.addSeparator();
            JMenuItem contrib = new JMenuItem(Language.text("menu.library.contributed"));
            contrib.setEnabled(false);
            this.importMenu.add(contrib);
            HashMap<String, JMenu> subfolders = new HashMap<String, JMenu>();
            for (Library library : this.contribLibraries) {
                JMenuItem item = new JMenuItem(library.getName());
                item.addActionListener(listener);
                item.setActionCommand(library.getName());
                String group = library.getGroup();
                if (group != null) {
                    JMenu subMenu = (JMenu)subfolders.get(group);
                    if (subMenu == null) {
                        subMenu = new JMenu(group);
                        this.importMenu.add(subMenu);
                        subfolders.put(group, subMenu);
                    }
                    subMenu.add(item);
                    continue;
                }
                this.importMenu.add(item);
            }
        }
    }

    public boolean requireExampleCompatibility() {
        return false;
    }

    public File[] getExampleCategoryFolders() {
        return this.examplesFolder.listFiles((dir, name) -> dir.isDirectory() && name.charAt(0) != '.');
    }

    public void rebuildExamplesFrame() {
        if (this.examplesFrame != null) {
            boolean visible = this.examplesFrame.isVisible();
            Rectangle bounds = null;
            if (visible) {
                bounds = this.examplesFrame.getBounds();
                this.examplesFrame.setVisible(false);
                this.examplesFrame.dispose();
            }
            this.examplesFrame = null;
            if (visible) {
                this.showExamplesFrame();
                this.examplesFrame.setBounds(bounds);
            }
        }
    }

    public void showExamplesFrame() {
        if (this.examplesFrame == null) {
            this.examplesFrame = new ExamplesFrame(this.base, this);
        }
        this.examplesFrame.setVisible();
    }

    public ImageIcon loadIcon(String filename) {
        if (filename.startsWith("/lib/")) {
            return Toolkit.getLibIcon(filename.substring(5));
        }
        File file = new File(this.folder, filename);
        if (!file.exists()) {
            return null;
        }
        return new ImageIcon(file.getAbsolutePath());
    }

    public Image loadImage(String filename) {
        ImageIcon icon = this.loadIcon(filename);
        if (icon != null) {
            return icon.getImage();
        }
        return null;
    }

    public Image loadImageX(String filename) {
        return this.loadImage(filename + "-" + Toolkit.highResMultiplier() + "x.png");
    }

    public String loadString(String filename) {
        File file = filename.startsWith("/lib/") ? Platform.getContentFile(filename.substring(1)) : new File(this.folder, filename);
        return Util.loadFile(file);
    }

    public String lookupReference(String keyword) {
        return this.keywordToReference.get(keyword);
    }

    public TokenMarker getTokenMarker(SketchCode code) {
        return this.getTokenMarker();
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    protected TokenMarker createTokenMarker() {
        return new PdeTokenMarker();
    }

    public boolean hideExtension(String ext) {
        return ext.equals(this.getDefaultExtension());
    }

    public boolean isDefaultExtension(SketchCode code) {
        return code.getExtension().equals(this.getDefaultExtension());
    }

    public boolean isDefaultExtension(String ext) {
        return ext.equals(this.getDefaultExtension());
    }

    public boolean canEdit(File file) {
        int dot = file.getName().lastIndexOf(46);
        if (dot < 0) {
            return false;
        }
        return this.validExtension(file.getName().substring(dot + 1));
    }

    public boolean canEdit(Sketch sketch) {
        for (SketchCode code : sketch.getCode()) {
            if (this.validExtension(code.getExtension())) continue;
            return false;
        }
        return true;
    }

    public boolean validExtension(String what) {
        String[] ext;
        for (String s : ext = this.getExtensions()) {
            if (!s.equals(what)) continue;
            return true;
        }
        return false;
    }

    public abstract String getDefaultExtension();

    public String getModuleExtension() {
        return this.getDefaultExtension();
    }

    public abstract String[] getExtensions();

    public abstract String[] getIgnorable();

    public Library findLibraryByName(String libName) {
        for (Library lib : this.coreLibraries) {
            if (!libName.equals(lib.getName())) continue;
            return lib;
        }
        for (Library lib : this.contribLibraries) {
            if (!libName.equals(lib.getName())) continue;
            return lib;
        }
        return null;
    }

    public void prepareExportFolder(File targetFolder) {
        if (targetFolder != null) {
            if (Preferences.getBoolean("export.delete_target_folder") && targetFolder.exists()) {
                try {
                    Platform.deleteFile(targetFolder);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!targetFolder.exists() && !targetFolder.mkdirs()) {
                Messages.err("Could not create " + targetFolder);
            }
        }
    }

    public String toString() {
        return this.getTitle();
    }
}

