/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import processing.app.Base;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Settings;
import processing.app.SketchCode;
import processing.app.Util;
import processing.app.ui.Editor;
import processing.app.ui.Recent;
import processing.app.ui.Toolkit;
import processing.core.PApplet;

public class Sketch {
    private final Editor editor;
    private final Mode mode;
    private File mainFile;
    private String name;
    private boolean modified;
    private File folder;
    private File dataFolder;
    private File codeFolder;
    private SketchCode current;
    private int currentIndex;
    private int codeCount;
    private SketchCode[] code;
    private boolean untitled;
    private boolean disappearedWarning;
    boolean renamingCode;
    AtomicBoolean saving = new AtomicBoolean();

    public Sketch(String path, Mode mode) {
        this.editor = null;
        this.mode = mode;
        this.load(path);
    }

    public Sketch(String path, Editor editor) throws IOException {
        this.editor = editor;
        this.mode = editor.getMode();
        this.load(path);
    }

    protected void load(String path) {
        this.mainFile = new File(path);
        this.folder = this.mainFile.getParentFile();
        this.name = this.folder.getName();
        this.disappearedWarning = false;
        this.load();
    }

    protected void load() {
        int i;
        this.codeFolder = new File(this.folder, "code");
        this.dataFolder = new File(this.folder, "data");
        ArrayList<String> filenames = new ArrayList<String>();
        ArrayList<String> extensions = new ArrayList<String>();
        this.getSketchCodeFiles(filenames, extensions);
        this.codeCount = filenames.size();
        this.code = new SketchCode[this.codeCount];
        for (i = 0; i < this.codeCount; ++i) {
            String filename = (String)filenames.get(i);
            String extension = (String)extensions.get(i);
            this.code[i] = new SketchCode(new File(this.folder, filename), extension);
        }
        for (i = 1; i < this.codeCount; ++i) {
            if (!this.code[i].getFile().equals(this.mainFile)) continue;
            SketchCode temp = this.code[0];
            this.code[0] = this.code[i];
            this.code[i] = temp;
            break;
        }
        this.sortCode();
        if (this.editor != null) {
            this.setCurrentCode(0);
        }
    }

    public void getSketchCodeFiles(List<String> outFilenames, List<String> outExtensions) {
        String[] list = this.folder.list();
        if (list != null) {
            for (String filename : list) {
                if (filename.startsWith(".") || new File(this.folder, filename).isDirectory()) continue;
                String base = filename;
                for (String extension : this.mode.getExtensions()) {
                    if (!base.toLowerCase().endsWith("." + extension) || !Sketch.isSanitaryName(base = base.substring(0, base.length() - (extension.length() + 1)))) continue;
                    if (outFilenames != null) {
                        outFilenames.add(filename);
                    }
                    if (outExtensions == null) continue;
                    outExtensions.add(extension);
                }
            }
        }
    }

    public void reload() {
        this.current = null;
        this.load();
    }

    public void loadNewTab(String filename, String ext, boolean newAddition) {
        if (newAddition) {
            this.insertCode(new SketchCode(new File(this.folder, filename), ext));
        } else {
            this.replaceCode(new SketchCode(new File(this.folder, filename), ext));
        }
        this.sortCode();
    }

    protected void replaceCode(SketchCode newCode) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].getFileName().equals(newCode.getFileName())) continue;
            this.code[i] = newCode;
            break;
        }
    }

    protected void insertCode(SketchCode newCode) {
        this.ensureExistence();
        this.code = (SketchCode[])PApplet.append((Object)this.code, (Object)newCode);
        ++this.codeCount;
    }

    protected void sortCode() {
        for (int i = 1; i < this.codeCount; ++i) {
            int who = i;
            for (int j = i + 1; j < this.codeCount; ++j) {
                if (this.code[j].getFileName().compareTo(this.code[who].getFileName()) >= 0) continue;
                who = j;
            }
            if (who == i) continue;
            SketchCode temp = this.code[who];
            this.code[who] = this.code[i];
            this.code[i] = temp;
            if (this.currentIndex == i) {
                this.currentIndex = who;
                continue;
            }
            if (this.currentIndex != who) continue;
            this.currentIndex = i;
        }
    }

    public void handleNewCode() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Messages.showMessage(Language.text("new.messages.is_read_only"), Language.text("new.messages.is_read_only.description"));
            return;
        }
        this.renamingCode = false;
        this.promptForTabName(Language.text("editor.tab.rename.description") + ":", "");
    }

    public void handleRenameCode() {
        this.ensureExistence();
        if (this.currentIndex == 0 && this.isUntitled()) {
            Messages.showMessage(Language.text("rename.messages.is_untitled"), Language.text("rename.messages.is_untitled.description"));
            return;
        }
        if (this.isModified()) {
            Messages.showMessage(Language.text("menu.file.save"), Language.text("rename.messages.is_modified"));
            return;
        }
        if (this.isReadOnly()) {
            Messages.showMessage(Language.text("rename.messages.is_read_only"), Language.text("rename.messages.is_read_only.description"));
            return;
        }
        this.renamingCode = true;
        String prompt = this.currentIndex == 0 && Preferences.getBoolean("editor.sync_folder_and_filename") ? Language.text("editor.sketch.rename.description") : Language.text("editor.tab.rename.description");
        String oldName = this.current.isExtension(this.mode.getDefaultExtension()) ? this.current.getPrettyName() : this.current.getFileName();
        this.promptForTabName(prompt + ":", oldName);
    }

    protected void promptForTabName(String prompt, String oldName) {
        final JTextField field = new JTextField(oldName);
        field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                char ch = event.getKeyChar();
                if (!(ch == '_' || ch == '.' || 'A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z')) {
                    if (ch == ' ') {
                        String t = field.getText();
                        int start = field.getSelectionStart();
                        int end2 = field.getSelectionEnd();
                        field.setText(t.substring(0, start) + "_" + t.substring(end2));
                        field.setCaretPosition(start + 1);
                        event.consume();
                    } else if (ch >= '0' && ch <= '9') {
                        if (field.getCaretPosition() == 0 || field.getSelectionStart() == 0) {
                            event.consume();
                        }
                    } else if (ch == '\n') {
                        Container parent = field.getParent();
                        while (true) {
                            if (parent instanceof JOptionPane) break;
                            parent = parent.getParent();
                        }
                        JOptionPane pane = (JOptionPane)parent;
                        JPanel pnlBottom = (JPanel)pane.getComponent(pane.getComponentCount() - 1);
                        for (int i = 0; i < pnlBottom.getComponents().length; ++i) {
                            ActionListener[] actionListeners;
                            JButton okButton;
                            Component component = pnlBottom.getComponents()[i];
                            if (!(component instanceof JButton) || !(okButton = (JButton)component).getText().equalsIgnoreCase("OK") || (actionListeners = okButton.getActionListeners()).length <= 0) continue;
                            actionListeners[0].actionPerformed(null);
                            event.consume();
                        }
                    } else {
                        event.consume();
                    }
                }
            }
        });
        int userReply = JOptionPane.showOptionDialog(this.editor, new Object[]{prompt, field}, Language.text("editor.tab.new"), 2, -1, null, new Object[]{Language.getPrompt("ok"), Language.getPrompt("cancel")}, field);
        if (userReply == 0) {
            this.nameCode(field.getText());
        }
    }

    protected void nameCode(String newName) {
        String sanitaryName;
        if (((String)(newName = ((String)newName).trim())).length() == 0) {
            return;
        }
        this.ensureExistence();
        if (((String)newName).indexOf(46) == -1) {
            newName = (String)newName + "." + (this.renamingCode ? this.mode.getDefaultExtension() : this.mode.getModuleExtension());
        }
        if (this.renamingCode && ((String)newName).equalsIgnoreCase(this.current.getFileName())) {
            return;
        }
        if (((String)newName).startsWith(".")) {
            Messages.showWarning(Language.text("name.messages.problem_renaming"), Language.text("name.messages.starts_with_dot.description"));
            return;
        }
        int dot = ((String)newName).lastIndexOf(46);
        String newExtension = ((String)newName).substring(dot + 1).toLowerCase();
        if (!this.mode.validExtension(newExtension)) {
            Messages.showWarning(Language.text("name.messages.problem_renaming"), Language.interpolate("name.messages.invalid_extension.description", newExtension));
            return;
        }
        if (!this.mode.isDefaultExtension(newExtension) && this.renamingCode && this.current == this.code[0]) {
            Messages.showWarning(Language.text("name.messages.problem_renaming"), Language.interpolate("name.messages.main_java_extension.description", newExtension));
            return;
        }
        String shortName = ((String)newName).substring(0, dot);
        if (!shortName.equals(sanitaryName = Sketch.sanitizeName(shortName))) {
            newName = sanitaryName + "." + newExtension;
        }
        if (!this.renamingCode || !sanitaryName.equals(this.current.getPrettyName())) {
            for (SketchCode c : this.code) {
                if (c == this.current || !sanitaryName.equalsIgnoreCase(c.getPrettyName())) continue;
                Messages.showMessage(Language.text("name.messages.new_sketch_exists"), Language.interpolate("name.messages.new_sketch_exists.description", c.getFileName(), this.folder.getAbsolutePath()));
                return;
            }
        }
        File newFile = new File(this.folder, (String)newName);
        if (this.renamingCode) {
            if (this.currentIndex == 0 && Preferences.getBoolean("editor.sync_folder_and_filename")) {
                if (!this.renameSketch((String)newName, newExtension)) {
                    return;
                }
            } else {
                if (!this.current.renameTo(newFile, newExtension)) {
                    Messages.showWarning(Language.text("name.messages.error"), Language.interpolate("name.messages.no_rename_file.description", this.current.getFileName(), newFile.getName()));
                    return;
                }
                if (this.currentIndex == 0) {
                    this.mainFile = newFile;
                    this.updateNameProperties();
                }
            }
        } else {
            try {
                if (!newFile.createNewFile()) {
                    throw new IOException("createNewFile() returned false");
                }
            }
            catch (IOException e) {
                Messages.showWarning(Language.text("name.messages.error"), Language.interpolate("name.messages.no_create_file.description", newFile, this.folder.getAbsolutePath()), e);
                return;
            }
            SketchCode newCode = new SketchCode(newFile, newExtension);
            this.insertCode(newCode);
        }
        this.sortCode();
        this.setCurrentCode((String)newName);
        this.editor.rebuildHeader();
    }

    protected boolean renameSketch(String newName, String newExtension) {
        String folderName = newName.substring(0, newName.indexOf(46));
        File newFolder = new File(this.folder.getParentFile(), folderName);
        if (newFolder.exists()) {
            Messages.showWarning(Language.text("name.messages.new_folder_exists"), Language.interpolate("name.messages.new_folder_exists.description", newName));
            return false;
        }
        boolean success = this.folder.renameTo(newFolder);
        if (!success) {
            Messages.showWarning(Language.text("name.messages.error"), Language.text("name.messages.no_rename_folder.description"));
            return false;
        }
        this.current.setFolder(newFolder);
        File newFile = new File(newFolder, newName);
        if (!this.current.renameTo(newFile, newExtension)) {
            Messages.showWarning(Language.text("name.messages.error"), Language.interpolate("name.messages.no_rename_file.description", this.current.getFileName(), newFile.getName()));
            return false;
        }
        for (int i = 1; i < this.codeCount; ++i) {
            this.code[i].setFolder(newFolder);
        }
        String oldPath = this.getMainPath();
        this.updateInternal(newFolder);
        if (this.renamingCode) {
            Recent.rename(this.editor, oldPath);
        }
        return true;
    }

    public void handleDeleteCode() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Messages.showMessage(Language.text("delete.messages.is_read_only"), Language.text("delete.messages.is_read_only.description"));
            return;
        }
        if (this.currentIndex == 0 && this.isUntitled()) {
            Messages.showMessage(Language.text("delete.messages.cannot_delete"), Language.text("delete.messages.cannot_delete.description"));
            return;
        }
        Object[] options = new Object[]{Language.text("prompt.ok"), Language.text("prompt.cancel")};
        String prompt = this.currentIndex == 0 ? Language.interpolate("warn.delete.sketch_folder", this.getName()) : Language.interpolate("warn.delete.sketch_file", this.current.getPrettyName());
        int result = JOptionPane.showOptionDialog(this.editor, prompt, Language.text("warn.delete"), 0, 3, null, options, options[0]);
        if (result == 0) {
            if (this.currentIndex == 0) {
                try {
                    Platform.deleteFile(this.folder);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.editor.getBase().rebuildSketchbook();
                this.editor.getBase().handleClose(this.editor, false);
            } else {
                if (!this.current.deleteFile()) {
                    Messages.showMessage(Language.text("delete.messages.cannot_delete.file"), Language.text("delete.messages.cannot_delete.file.description") + " \"" + this.current.getFileName() + "\".");
                    return;
                }
                this.removeCode(this.current);
                this.editor.rebuildHeader();
                this.setCurrentCode(0);
            }
        }
    }

    public void removeCode(SketchCode which) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (this.code[i] != which) continue;
            for (int j = i; j < this.codeCount - 1; ++j) {
                this.code[j] = this.code[j + 1];
            }
            --this.codeCount;
            this.code = (SketchCode[])PApplet.shorten((Object)this.code);
            return;
        }
        if (Base.DEBUG) {
            System.err.println("removeCode: could not find " + which.getFileName());
        }
    }

    public void handlePrevCode() {
        int prev = this.currentIndex - 1;
        if (prev < 0) {
            prev = this.codeCount - 1;
        }
        this.setCurrentCode(prev);
    }

    public void handleNextCode() {
        this.setCurrentCode((this.currentIndex + 1) % this.codeCount);
    }

    public void setModified(boolean state) {
        if (this.current.isModified() != state) {
            this.current.setModified(state);
            this.calcModified();
        }
    }

    protected void calcModified() {
        this.modified = false;
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].isModified()) continue;
            this.modified = true;
            break;
        }
        this.editor.repaintHeader();
        if (Platform.isMacOS()) {
            Boolean modifiedParam = this.modified ? Boolean.TRUE : Boolean.FALSE;
            this.editor.getRootPane().putClientProperty("Window.documentModified", modifiedParam);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void updateSketchCodes() {
        this.current.setProgram(this.editor.getText());
    }

    public boolean save() throws IOException {
        this.ensureExistence();
        this.updateSketchCodes();
        if (this.isReadOnly()) {
            Messages.showMessage(Language.text("save_file.messages.is_read_only"), Language.text("save_file.messages.is_read_only.description"));
            if (!this.saveAs()) {
                return false;
            }
        }
        for (SketchCode sc : this.code) {
            if (!sc.isModified()) continue;
            sc.save();
        }
        this.calcModified();
        return true;
    }

    public boolean saveAs() throws IOException {
        File newFolder;
        String newParentDir = null;
        String newSketchName = null;
        String PROMPT = Language.text("save");
        boolean useNative = Preferences.getBoolean("chooser.files.native");
        if (useNative) {
            FileDialog fd = new FileDialog((Frame)this.editor, PROMPT, 1);
            if (this.isReadOnly() || this.isUntitled()) {
                fd.setDirectory(Preferences.getSketchbookPath());
            } else {
                fd.setDirectory(this.folder.getParent());
            }
            String oldFolderName = this.folder.getName();
            fd.setFile(oldFolderName);
            fd.setVisible(true);
            newParentDir = fd.getDirectory();
            newSketchName = fd.getFile();
        } else {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle(PROMPT);
            if (this.isReadOnly() || this.isUntitled()) {
                fc.setCurrentDirectory(new File(Preferences.getSketchbookPath()));
            } else {
                fc.setCurrentDirectory(this.folder.getParentFile());
            }
            int result = fc.showSaveDialog(this.editor);
            if (result == 0) {
                File selection = fc.getSelectedFile();
                newParentDir = selection.getParent();
                newSketchName = selection.getName();
            }
        }
        if (newSketchName == null) {
            return false;
        }
        boolean sync = Preferences.getBoolean("editor.sync_folder_and_filename");
        String newMainFileName = null;
        if (sync) {
            String newMainName = Sketch.sanitizeName(newSketchName);
            newFolder = new File(newParentDir, newMainName);
            if (!newMainName.equals(newSketchName) && newFolder.exists()) {
                Messages.showMessage(Language.text("save_file.messages.sketch_exists"), Language.interpolate("save_file.messages.sketch_exists.description", newMainName));
                return false;
            }
            newSketchName = newMainName;
            newMainFileName = newMainName + "." + this.mode.getDefaultExtension();
        } else {
            newFolder = new File(newParentDir, newSketchName);
        }
        for (int i = 1; i < this.codeCount; ++i) {
            if (!newSketchName.equalsIgnoreCase(this.code[i].getPrettyName())) continue;
            Messages.showMessage(Language.text("save_file.messages.tab_exists"), Language.interpolate("save_file.messages.tab_exists.description", newSketchName));
            return false;
        }
        if (newFolder.equals(this.folder)) {
            return this.save();
        }
        try {
            String newPath = newFolder.getCanonicalPath() + File.separator;
            String oldPath = this.folder.getCanonicalPath() + File.separator;
            if (newPath.indexOf(oldPath) == 0) {
                Messages.showWarning(Language.text("save_file.messages.recursive_save"), Language.text("save_file.messages.recursive_save.description"));
                return false;
            }
        }
        catch (IOException newPath) {
            // empty catch block
        }
        if (newFolder.exists()) {
            try {
                Platform.deleteFile(newFolder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!newFolder.mkdirs()) {
            System.err.println("Error creating path " + newFolder);
        }
        this.updateSketchCodes();
        File[] copyItems = this.folder.listFiles(file -> {
            String name = file.getName();
            if (name.equals(".") || name.equals("..")) {
                return false;
            }
            String[] ignorable = this.mode.getIgnorable();
            if (ignorable != null) {
                for (String ignore : ignorable) {
                    if (!name.equals(ignore)) continue;
                    return false;
                }
            }
            for (String ext : this.mode.getExtensions()) {
                if (!name.endsWith(ext)) continue;
                return false;
            }
            return !name.startsWith("screen-");
        });
        this.startSaveAsThread(newFolder, copyItems);
        for (int i = 0; i < this.codeCount; ++i) {
            File newFile = new File(newFolder, this.code[i].getFileName());
            if (i == 0 && sync) {
                newFile = new File(newFolder, newMainFileName);
            }
            this.code[i].saveAs(newFile);
        }
        this.updateInternal(newFolder);
        this.setUntitled(false);
        Recent.append(this.editor);
        return true;
    }

    public boolean isSaving() {
        return this.saving.get();
    }

    void startSaveAsThread(final File newFolder, final File[] copyItems) {
        this.saving.set(true);
        EventQueue.invokeLater(() -> {
            final JFrame frame = new JFrame("Saving \u201c" + newFolder.getName() + "\u201c\u2026");
            frame.setDefaultCloseOperation(1);
            Box box = Box.createVerticalBox();
            box.setBorder(new EmptyBorder(16, 16, 16, 16));
            if (Platform.isMacOS()) {
                frame.setBackground(Color.WHITE);
            }
            JLabel label = new JLabel("Saving additional files from the sketch folder...");
            box.add(label);
            box.add(Box.createVerticalStrut(8));
            final JProgressBar progressBar = new JProgressBar(0, 100);
            progressBar.setValue(0);
            progressBar.setStringPainted(true);
            box.add(progressBar);
            frame.getContentPane().add(box);
            frame.pack();
            frame.setLocationRelativeTo(this.editor);
            Toolkit.setIcon(frame);
            frame.setVisible(true);
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    this.addPropertyChangeListener(evt -> {
                        if ("progress".equals(evt.getPropertyName())) {
                            progressBar.setValue((Integer)evt.getNewValue());
                        }
                    });
                    long totalSize = 0L;
                    for (File copyable : copyItems) {
                        totalSize += Util.calcSize(copyable);
                    }
                    long progress = 0L;
                    this.setProgress(0);
                    for (File copyable : copyItems) {
                        if (copyable.isDirectory()) {
                            this.copyDir(copyable, new File(newFolder, copyable.getName()), progress, totalSize);
                            progress += Util.calcSize(copyable);
                            continue;
                        }
                        this.copyFile(copyable, new File(newFolder, copyable.getName()), progress, totalSize);
                        if (Util.calcSize(copyable) >= 524288L) continue;
                        this.setProgress((int)((progress += Util.calcSize(copyable)) * 100L / totalSize));
                    }
                    Sketch.this.saving.set(false);
                    return null;
                }

                void copyFile(File sourceFile, File targetFile, long progress, long totalSize) throws IOException {
                    int bytesRead;
                    BufferedInputStream from = new BufferedInputStream(new FileInputStream(sourceFile));
                    BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(targetFile));
                    byte[] buffer = new byte[16384];
                    int progRead = 0;
                    while ((bytesRead = from.read(buffer)) != -1) {
                        to.write(buffer, 0, bytesRead);
                        if ((progRead += bytesRead) < 524288) continue;
                        this.setProgress((int)(100L * (progress += (long)progRead) / totalSize));
                        progRead = 0;
                    }
                    this.setProgress((int)(100L * progress / totalSize));
                    from.close();
                    to.flush();
                    to.close();
                    if (!targetFile.setLastModified(sourceFile.lastModified())) {
                        System.err.println("Warning: Could not set modification date/time for " + targetFile);
                    }
                    if (!targetFile.setExecutable(sourceFile.canExecute()) && !Platform.isWindows()) {
                        System.err.println("Warning: Could not set permissions for " + targetFile);
                    }
                }

                long copyDir(File sourceDir, File targetDir, long progress, long totalSize) throws IOException {
                    if (sourceDir.equals(targetDir)) {
                        String urDum = "source and target directories are identical";
                        throw new IllegalArgumentException("source and target directories are identical");
                    }
                    targetDir.mkdirs();
                    String[] files = sourceDir.list();
                    if (files != null) {
                        for (String filename : files) {
                            if (filename.charAt(0) == '.') continue;
                            File source = new File(sourceDir, filename);
                            File target = new File(targetDir, filename);
                            if (source.isDirectory()) {
                                progress = this.copyDir(source, target, progress, totalSize);
                                this.setProgress((int)(100L * progress / totalSize));
                                target.setLastModified(source.lastModified());
                                continue;
                            }
                            this.copyFile(source, target, progress, totalSize);
                            this.setProgress((int)(100L * (progress += source.length()) / totalSize));
                        }
                    } else {
                        throw new IOException("Could not list files inside " + sourceDir);
                    }
                    return progress;
                }

                @Override
                public void done() {
                    frame.dispose();
                    Sketch.this.editor.statusNotice(Language.text("editor.status.saving.done"));
                }
            }.execute();
        });
    }

    protected void updateInternal(File sketchFolder) {
        this.mainFile = this.code[0].getFile();
        this.name = sketchFolder.getName();
        this.folder = sketchFolder;
        this.disappearedWarning = false;
        this.codeFolder = new File(this.folder, "code");
        this.dataFolder = new File(this.folder, "data");
        this.updateNameProperties();
        this.calcModified();
        this.editor.updateTitle();
        this.editor.getBase().rebuildSketchbook();
    }

    protected void updateModeProperties(Mode mode, Mode defaultMode) {
        Sketch.updateModeProperties(this.folder, mode, defaultMode);
    }

    protected static void updateModeProperties(File folder, Mode mode, Mode defaultMode) {
        try {
            Settings props = Sketch.loadProperties(folder);
            if (mode == defaultMode) {
                props.remove("mode");
                props.remove("mode.id");
            } else {
                props.set("mode", mode.getTitle());
                props.set("mode.id", mode.getIdentifier());
            }
            props.reckon();
        }
        catch (IOException e) {
            System.err.println("Error while writing sketch.properties");
            e.printStackTrace();
        }
    }

    protected static Settings loadProperties(File folder) throws IOException {
        return new Settings(new File(folder, "sketch.properties"));
    }

    protected static File findMain(File folder, List<Mode> modeList) {
        try {
            File mainFile;
            Settings props = Sketch.loadProperties(folder);
            String main = props.get("main");
            if (main != null && !(mainFile = new File(folder, main)).exists()) {
                System.err.println(main + " does not exist inside " + folder);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Mode mode : modeList) {
            String defaultName = folder.getName() + "." + mode.getDefaultExtension();
            File entry = new File(folder, defaultName);
            if (!entry.exists()) continue;
            return entry;
        }
        return null;
    }

    private void updateNameProperties() {
        String mainName = this.mainFile.getName();
        String defaultName = this.name + "." + this.mode.getDefaultExtension();
        try {
            Settings props = Sketch.loadProperties(this.folder);
            if (mainName.equals(defaultName)) {
                props.remove("main");
            } else {
                props.set("main", mainName);
            }
            props.reckon();
        }
        catch (IOException e) {
            System.err.println("Error while updating sketch.properties");
            e.printStackTrace();
        }
    }

    public void handleAddFile() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Messages.showMessage(Language.text("add_file.messages.is_read_only"), Language.text("add_file.messages.is_read_only.description"));
            return;
        }
        String prompt = Language.text("file");
        FileDialog fd = new FileDialog((Frame)this.editor, prompt, 0);
        fd.setVisible(true);
        String directory = fd.getDirectory();
        String filename = fd.getFile();
        if (filename == null) {
            return;
        }
        File sourceFile = new File(directory, filename);
        boolean result = this.addFile(sourceFile);
        if (result) {
            // empty if block
        }
    }

    public boolean addFile(File sourceFile) {
        boolean muchSuccess;
        if (sourceFile.isDirectory()) {
            System.err.println("Skipping folder " + sourceFile);
            System.err.println("Dragging and dropping a folder is not supported.");
            return false;
        }
        String filename = sourceFile.getName();
        File destFile = null;
        String codeExtension = null;
        boolean replacement = false;
        boolean isCode = false;
        if (filename.toLowerCase().endsWith(".class") || filename.toLowerCase().endsWith(".jar") || filename.toLowerCase().endsWith(".dll") || filename.toLowerCase().endsWith(".dylib") || filename.toLowerCase().endsWith(".jnilib") || filename.toLowerCase().endsWith(".so")) {
            boolean success;
            if (!this.codeFolder.exists() && !(success = this.codeFolder.mkdirs())) {
                System.err.println("Could not create " + this.codeFolder);
                return false;
            }
            destFile = new File(this.codeFolder, filename);
            isCode = true;
        } else {
            for (String extension : this.mode.getExtensions()) {
                String lower = filename.toLowerCase();
                if (!lower.endsWith("." + extension)) continue;
                destFile = new File(this.folder, filename);
                codeExtension = extension;
            }
            if (codeExtension == null) {
                this.prepareDataFolder();
                destFile = new File(this.dataFolder, filename);
            }
        }
        if (destFile.exists()) {
            Object[] options = new Object[]{Language.text("prompt.ok"), Language.text("prompt.cancel")};
            String prompt = Language.interpolate("add_file.messages.confirm_replace", filename);
            int result = JOptionPane.showOptionDialog(this.editor, prompt, "Replace", 0, 3, null, options, options[0]);
            if (result == 0) {
                replacement = true;
            } else {
                return false;
            }
        }
        if (replacement && !(muchSuccess = destFile.delete())) {
            Messages.showWarning(Language.text("add_file.messages.error_adding"), Language.interpolate("add_file.messages.cannot_delete.description", filename));
            return false;
        }
        if (codeExtension == null && sourceFile.equals(destFile)) {
            Messages.showWarning(Language.text("add_file.messages.same_file"), Language.text("add_file.messages.same_file.description"));
            return false;
        }
        if (!sourceFile.equals(destFile)) {
            try {
                Util.copyFile(sourceFile, destFile);
            }
            catch (IOException e) {
                Messages.showWarning(Language.text("add_file.messages.error_adding"), Language.interpolate("add_file.messages.cannot_add.description", filename), e);
                return false;
            }
        }
        if (isCode) {
            this.editor.codeFolderChanged();
        }
        if (codeExtension != null) {
            SketchCode newCode = new SketchCode(destFile, codeExtension);
            if (replacement) {
                this.replaceCode(newCode);
            } else {
                this.insertCode(newCode);
                this.sortCode();
            }
            this.setCurrentCode(filename);
            this.editor.repaintHeader();
            if (this.isUntitled()) {
                this.current.setModified(true);
            }
        } else if (this.isUntitled()) {
            this.code[0].setModified(true);
        }
        return true;
    }

    public void setCurrentCode(int which) {
        if (which < 0 || which >= this.codeCount || this.currentIndex == which && this.current == this.code[this.currentIndex]) {
            return;
        }
        if (this.current != null) {
            this.current.setState(this.editor.getText(), this.editor.getSelectionStart(), this.editor.getSelectionStop(), this.editor.getScrollPosition());
        }
        this.current = this.code[which];
        this.currentIndex = which;
        this.current.visited = System.currentTimeMillis();
        this.editor.setCode(this.current);
        this.editor.repaintHeader();
    }

    public void setCurrentCode(String findName) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (!findName.equals(this.code[i].getFileName()) && !findName.equals(this.code[i].getPrettyName())) continue;
            this.setCurrentCode(i);
            return;
        }
    }

    public File makeTempFolder() {
        try {
            return Util.createTempFolder(this.name, "temp", null);
        }
        catch (IOException e) {
            Messages.showWarning(Language.text("temp_dir.messages.bad_build_folder"), Language.text("temp_dir.messages.bad_build_folder.description"), e);
            return null;
        }
    }

    public void ensureExistence() {
        if (!this.folder.exists() && !this.disappearedWarning) {
            this.disappearedWarning = true;
            Messages.showWarning(Language.text("ensure_exist.messages.missing_sketch"), Language.text("ensure_exist.messages.missing_sketch.description"));
            try {
                this.folder.mkdirs();
                this.modified = true;
                for (int i = 0; i < this.codeCount; ++i) {
                    this.code[i].save();
                }
                this.calcModified();
            }
            catch (Exception e) {
                Messages.showWarning(Language.text("ensure_exist.messages.unrecoverable"), Language.text("ensure_exist.messages.unrecoverable.description"), e);
            }
        }
    }

    public boolean isReadOnly() {
        String path = this.folder.getAbsolutePath();
        List<Mode> modes = this.editor.getBase().getModeList();
        for (Mode mode : modes) {
            if (!path.startsWith(mode.getExamplesFolder().getAbsolutePath()) && !path.startsWith(mode.getLibrariesFolder().getAbsolutePath())) continue;
            return true;
        }
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].isModified() || !this.code[i].fileReadOnly() || !this.code[i].fileExists()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getMainName() {
        return this.code[0].getPrettyName();
    }

    public String getMainPath() {
        return this.mainFile.getAbsolutePath();
    }

    public File getFolder() {
        return this.folder;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public boolean hasDataFolder() {
        return this.dataFolder.exists();
    }

    public File prepareDataFolder() {
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        return this.dataFolder;
    }

    public File getCodeFolder() {
        return this.codeFolder;
    }

    public boolean hasCodeFolder() {
        return this.codeFolder != null && this.codeFolder.exists();
    }

    public SketchCode[] getCode() {
        return this.code;
    }

    public int getCodeCount() {
        return this.codeCount;
    }

    public SketchCode getCode(int index) {
        return this.code[index];
    }

    public SketchCode getCurrentCode() {
        return this.current;
    }

    public int getCurrentCodeIndex() {
        return this.currentIndex;
    }

    @Deprecated
    public String getMainProgram() {
        return this.getCode(0).getProgram();
    }

    public void setUntitled(boolean untitled) {
        this.untitled = untitled;
        this.editor.updateTitle();
    }

    public boolean isUntitled() {
        return this.untitled;
    }

    public static boolean isSanitaryName(String name) {
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            name = name.substring(0, dot);
        }
        return Sketch.sanitizeName(name).equals(name);
    }

    static boolean isAsciiLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static String sanitizeName(String origName) {
        int underscore;
        char[] orig = origName.toCharArray();
        StringBuilder sb = new StringBuilder();
        if (!Sketch.isAsciiLetter(orig[0])) {
            sb.append("sketch_");
        }
        for (char c : orig) {
            if (Sketch.isAsciiLetter(c) || c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        if (sb.length() > 63) {
            sb.setLength(63);
        }
        for (underscore = 0; underscore < sb.length() && sb.charAt(underscore) == '_'; ++underscore) {
        }
        if (underscore == sb.length()) {
            return "bad_sketch_name_please_fix";
        }
        if (underscore != 0) {
            return sb.substring(underscore);
        }
        return sb.toString();
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean equals(Object another) {
        if (another instanceof Sketch) {
            return this.getMainPath().equals(((Sketch)another).getMainPath());
        }
        return false;
    }
}

