/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.IOException;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;
import processing.app.Util;

public class SketchCode {
    private File file;
    private String extension;
    private String program;
    private String savedProgram;
    private Document document;
    long visited;
    private long lastModified;
    private final UndoManager undo = new UndoManager();
    private final Stack<Integer> caretUndoStack = new Stack();
    private final Stack<Integer> caretRedoStack = new Stack();
    private int selectionStart;
    private int selectionStop;
    private int scrollPosition;
    private boolean modified;
    private int preprocOffset;

    public SketchCode(File file, String extension) {
        this.file = file;
        this.extension = extension;
        try {
            this.load();
        }
        catch (IOException e) {
            System.err.println("Error while loading code " + file.getName());
        }
    }

    public File getFile() {
        return this.file;
    }

    protected boolean fileExists() {
        return this.file.exists();
    }

    protected boolean fileReadOnly() {
        return !this.file.canWrite();
    }

    protected boolean deleteFile() {
        return this.file.delete();
    }

    protected boolean renameTo(File what, String ext) {
        boolean success = this.file.renameTo(what);
        if (success) {
            this.file = what;
            this.extension = ext;
        }
        return success;
    }

    public void copyTo(File dest) throws IOException {
        Util.saveFile(this.program, dest);
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String getPrettyName() {
        String name = this.file.getName();
        int dot = name.lastIndexOf(46);
        return dot != -1 ? name.substring(0, dot) : name;
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean isExtension(String what) {
        return this.extension.equals(what);
    }

    public String getProgram() {
        return this.program;
    }

    public void setProgram(String replacement) {
        this.program = replacement;
    }

    public String getSavedProgram() {
        return this.savedProgram;
    }

    public int getLineCount() {
        return Util.countLines(this.program);
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setPreprocOffset(int preprocOffset) {
        this.preprocOffset = preprocOffset;
    }

    public int getPreprocOffset() {
        return this.preprocOffset;
    }

    public void addPreprocOffset(int extra) {
        this.preprocOffset += extra;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getDocumentText() throws BadLocationException {
        return this.document.getText(0, this.document.getLength());
    }

    public void setDocument(Document d) {
        this.document = d;
    }

    public UndoManager getUndo() {
        return this.undo;
    }

    public Stack<Integer> getCaretRedoStack() {
        return this.caretRedoStack;
    }

    public Stack<Integer> getCaretUndoStack() {
        return this.caretUndoStack;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionStop() {
        return this.selectionStop;
    }

    public int getScrollPosition() {
        return this.scrollPosition;
    }

    protected void setState(String p, int start, int stop, int pos) {
        this.program = p;
        this.selectionStart = start;
        this.selectionStop = stop;
        this.scrollPosition = pos;
    }

    public long lastVisited() {
        return this.visited;
    }

    public void load() throws IOException {
        this.program = Util.loadFile(this.file);
        if (this.program == null) {
            System.err.println("There was a problem loading " + this.file);
            System.err.println("This may happen because you don't have permissions to read the file, or the file has gone missing.");
            throw new IOException("Cannot read or access " + this.file);
        }
        if (this.program.indexOf(0) != -1) {
            this.program = this.program.replaceAll("\u0000", "");
        }
        this.savedProgram = this.program;
        if (this.program.indexOf(65533) != -1) {
            System.err.println(this.file.getName() + " contains unrecognized characters.");
            System.err.println("You should re-open " + this.file.getName() + " with a text editor,");
            System.err.println("and re-save it in UTF-8 format. Otherwise, you can");
            System.err.println("delete the bad characters to get rid of this warning.");
            System.err.println();
        }
        this.setLastModified();
        this.setModified(false);
    }

    public void save() throws IOException {
        Util.saveFile(this.program, this.file);
        this.savedProgram = this.program;
        this.lastModified = this.file.lastModified();
        this.setModified(false);
    }

    public void saveAs(File newFile) throws IOException {
        Util.saveFile(this.program, newFile);
        this.savedProgram = this.program;
        this.file = newFile;
        this.setLastModified();
        this.setModified(false);
    }

    public void setFolder(File sketchFolder) {
        this.file = new File(sketchFolder, this.file.getName());
    }

    public void setLastModified() {
        this.lastModified = this.file.lastModified();
    }

    public long getLastModified() {
        return this.lastModified;
    }
}

