/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.core.PApplet;
import processing.data.JSONArray;
import processing.data.JSONObject;
import processing.data.StringList;

public class SketchName {
    static final String FILENAME = "naming.json";
    public static final String CLASSIC = "Classic (sketch_220809a)";
    static boolean breakTime = false;
    static Map<String, WordList> wordLists;

    static File nextFolder(File parentDir) {
        WordList wl;
        String approach = Preferences.get("sketch.name.approach");
        if (approach != null && !CLASSIC.equals(approach) && (wl = SketchName.getWordLists().get(approach)) != null) {
            File folder = wl.wordsFolder(parentDir);
            if (folder == null) {
                Messages.showWarning("Out of Options", "All possible naming combinations have been used.\nUse \u201cPreferences\u201d to choose a different naming system,\nor restart Processing.");
            }
            return folder;
        }
        return SketchName.classicFolder(parentDir);
    }

    static File classicFolder(File parentDir) {
        Object newbieName;
        File newbieDir;
        Object suffix;
        int index = 0;
        String prefix = Preferences.get("editor.untitled.prefix");
        String format = Preferences.get("editor.untitled.suffix");
        if (format == null) {
            Calendar cal = Calendar.getInstance();
            int day = cal.get(5);
            int month = cal.get(2);
            String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
            suffix = months[month] + PApplet.nf((int)day, (int)2);
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            suffix = formatter.format(new Date());
        }
        do {
            if (index == 26) {
                if (!breakTime) {
                    Messages.showWarning("Time for a Break", "You've reached the limit for auto naming of new sketches\nfor the day. How about going for a walk instead?", null);
                    breakTime = true;
                } else {
                    Messages.showWarning("Sunshine", "No really, time for some fresh air for you.\n(At a minimum, you'll need to restart Processing.)", null);
                }
                return null;
            }
            newbieName = prefix + (String)suffix + (char)(97 + index);
            newbieName = Sketch.sanitizeName((String)newbieName);
            newbieDir = new File(parentDir, (String)newbieName);
            ++index;
        } while (newbieDir.exists() || new File(Base.getSketchbookFolder(), (String)newbieName).exists());
        return newbieDir;
    }

    private static void load(File namingFile) {
        JSONArray array = PApplet.loadJSONArray((File)namingFile);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            WordList wl = new WordList(obj);
            wordLists.put(wl.name, wl);
        }
    }

    static Map<String, WordList> getWordLists() {
        if (wordLists == null) {
            wordLists = new HashMap<String, WordList>();
            try {
                File namingFile = Base.getLibFile(FILENAME);
                SketchName.load(namingFile);
            }
            catch (Exception e) {
                Messages.showWarning("Naming Error", "Could not load word lists from naming.json", e);
            }
            File sketchbookFile = new File(Base.getSketchbookFolder(), FILENAME);
            if (sketchbookFile.exists()) {
                try {
                    SketchName.load(sketchbookFile);
                }
                catch (Exception e) {
                    Messages.showWarning("Naming Error", "Error while reading naming.json from sketchbook folder", e);
                }
            }
        }
        return wordLists;
    }

    public static String[] getOptions() {
        StringList outgoing = new StringList();
        outgoing.append(CLASSIC);
        for (String approach : SketchName.getWordLists().keySet()) {
            outgoing.append(approach);
        }
        return outgoing.toArray();
    }

    static class WordList {
        String name;
        String notes;
        StringList prefixes;
        StringList suffixes;
        StringList exhaustive;

        WordList(JSONObject source) {
            this.name = source.getString("name");
            this.notes = source.getString("notes");
            this.prefixes = source.getStringList("prefixes");
            this.suffixes = source.getStringList("suffixes");
        }

        String getPair() {
            return (this.prefixes.choice() + " " + this.suffixes.choice()).replace(' ', '_');
        }

        File wordsFolderExhaust(File parentDir) {
            String name;
            File outgoing;
            if (this.exhaustive == null) {
                this.exhaustive = new StringList();
                for (String prefix : this.prefixes) {
                    for (String suffix : this.suffixes) {
                        String pair = (prefix + " " + suffix).replace(' ', '_');
                        String name2 = Sketch.sanitizeName(pair);
                        File folder = new File(parentDir, name2);
                        if (folder.exists()) continue;
                        this.exhaustive.append(name2);
                    }
                }
                this.exhaustive.shuffle();
            }
            do {
                if (this.exhaustive.size() == 0) {
                    return null;
                }
                name = this.exhaustive.removeChoice();
                if (name != null) continue;
                return null;
            } while ((outgoing = new File(parentDir, name)).exists());
            return outgoing;
        }

        File wordsFolder(File parentDir) {
            File outgoing;
            if (this.exhaustive != null) {
                return this.wordsFolderExhaust(parentDir);
            }
            int maxAttempts = this.prefixes.size() * this.suffixes.size();
            int attempts = 0;
            do {
                String name = Sketch.sanitizeName(this.getPair());
                outgoing = new File(parentDir, name);
                if (++attempts != maxAttempts) continue;
                return this.wordsFolderExhaust(parentDir);
            } while (outgoing.exists());
            return outgoing;
        }
    }
}

