/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import processing.app.Messages;
import processing.app.Platform;
import processing.core.PApplet;
import processing.data.StringDict;
import processing.data.StringList;

public class Util {
    public static int countLines(String what) {
        int count = 1;
        for (char c : what.toCharArray()) {
            if (c != '\n') continue;
            ++count;
        }
        return count;
    }

    public static byte[] loadBytesRaw(File file) throws IOException {
        int bytesRead;
        int size = (int)file.length();
        FileInputStream input = new FileInputStream(file);
        byte[] buffer = new byte[size];
        int offset = 0;
        while ((bytesRead = input.read(buffer, offset, size - offset)) != -1) {
            offset += bytesRead;
            if (bytesRead != 0) continue;
        }
        input.close();
        return buffer;
    }

    public static InputStream createInput(String path) throws IOException {
        URL url = new URL(path);
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)conn;
            httpConn.setInstanceFollowRedirects(true);
            int response = httpConn.getResponseCode();
            if (response >= 300 && response < 400) {
                String newLocation = httpConn.getHeaderField("Location");
                return Util.createInput(newLocation);
            }
            return conn.getInputStream();
        }
        if (conn instanceof JarURLConnection) {
            return url.openStream();
        }
        return null;
    }

    public static StringDict readSettings(File inputFile, boolean allowHex) {
        if (!inputFile.exists()) {
            Messages.err(inputFile + " does not exist inside readSettings()");
            return null;
        }
        String[] lines = PApplet.loadStrings((File)inputFile);
        if (lines == null) {
            System.err.println("Could not read " + inputFile);
            return null;
        }
        return Util.readSettings(inputFile.toString(), lines, allowHex);
    }

    public static StringDict readSettings(String filename, String[] lines, boolean allowHex) {
        StringDict settings = new StringDict();
        for (String line : lines) {
            line = PApplet.trim((String)line);
            if (!allowHex && line.contains("#")) {
                line = line.substring(0, line.indexOf(35)).trim();
            }
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            int equals = line.indexOf(61);
            if (equals == -1) {
                if (filename == null) continue;
                System.err.println("Ignoring illegal line in " + filename + ":");
                System.err.println("  " + line);
                continue;
            }
            String attr = line.substring(0, equals).trim();
            String valu = line.substring(equals + 1).trim();
            settings.set(attr, valu);
        }
        return settings;
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        int bytesRead;
        BufferedInputStream from = new BufferedInputStream(new FileInputStream(sourceFile));
        BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(targetFile));
        byte[] buffer = new byte[16384];
        while ((bytesRead = from.read(buffer)) != -1) {
            to.write(buffer, 0, bytesRead);
        }
        from.close();
        to.flush();
        to.close();
        targetFile.setLastModified(sourceFile.lastModified());
        targetFile.setExecutable(sourceFile.canExecute());
    }

    public static String loadFile(File file) {
        String[] contents;
        if (file != null && file.exists() && (contents = PApplet.loadStrings((File)file)) != null) {
            return PApplet.join((String[])contents, (String)"\n");
        }
        return null;
    }

    public static void saveFile(String text, File file) throws IOException {
        boolean result;
        String[] lines = text.split("\\r?\\n");
        File temp = File.createTempFile(file.getName(), null, file.getParentFile());
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IOException("Could not resolve canonical representation of " + file.getAbsolutePath());
        }
        PrintWriter writer = PApplet.createWriter((File)temp);
        for (String line : lines) {
            writer.println(line);
        }
        boolean error = writer.checkError();
        writer.close();
        if (error) {
            throw new IOException("Error while trying to save " + file);
        }
        if (file.exists() && !(result = file.delete())) {
            throw new IOException("Could not remove old version of " + file.getAbsolutePath());
        }
        result = temp.renameTo(file);
        if (!result) {
            throw new IOException("Could not replace " + file.getAbsolutePath() + " with " + temp.getAbsolutePath());
        }
    }

    public static File createTempFolder(String prefix, String suffix, File directory) throws IOException {
        File folder;
        int fillChars = 3 - ((String)prefix).length();
        if (fillChars > 0) {
            prefix = (String)prefix + "_".repeat(fillChars);
        }
        if (directory == null) {
            directory = Util.getProcessingTemp();
        }
        if (!(folder = File.createTempFile((String)prefix, suffix, directory)).delete()) {
            throw new IOException("Could not remove " + folder + " to create a temporary folder");
        }
        if (!folder.mkdirs()) {
            throw new IOException("Unable to create " + folder + ", please check permissions for " + folder.getParentFile());
        }
        return folder;
    }

    public static File getProcessingTemp() throws IOException {
        String tmpDir = System.getProperty("java.io.tmpdir");
        File directory = new File(tmpDir, "processing");
        if (!directory.exists()) {
            if (directory.mkdirs()) {
                if (Platform.isLinux()) {
                    Path path = directory.toPath();
                    Files.setPosixFilePermissions(path, PosixFilePermissions.fromString("rwxrwxrwx"));
                } else {
                    if (!directory.setReadable(true, false)) {
                        System.err.println("Could not set readable for all: " + directory);
                    }
                    if (!directory.setWritable(true, false)) {
                        System.err.println("Could not set writable for all: " + directory);
                    }
                    if (!directory.setExecutable(true, false)) {
                        System.err.println("Could not set writable for all: " + directory);
                    }
                }
            } else {
                throw new IOException("Could not create temp directory. Check that you have permissions to write to " + tmpDir);
            }
        }
        return directory;
    }

    public static void copyDir(File sourceDir, File targetDir) throws IOException {
        if (sourceDir.equals(targetDir)) {
            String urDum = "source and target directories are identical";
            throw new IllegalArgumentException("source and target directories are identical");
        }
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new IOException("Could not create " + targetDir);
        }
        String[] filenames = sourceDir.list();
        if (filenames != null) {
            for (String filename : filenames) {
                if (filename.charAt(0) == '.') continue;
                File source = new File(sourceDir, filename);
                File target = new File(targetDir, filename);
                if (source.isDirectory()) {
                    Util.copyDir(source, target);
                    target.setLastModified(source.lastModified());
                    continue;
                }
                Util.copyFile(source, target);
            }
        } else {
            throw new IOException("Could not read " + sourceDir);
        }
    }

    public static void copyDirNative(File sourceDir, File targetDir) throws IOException {
        if (!Platform.isMacOS() && !Platform.isLinux()) {
            throw new RuntimeException("Not yet implemented on Windows");
        }
        Process process = Runtime.getRuntime().exec(new String[]{"cp", "-a", sourceDir.getAbsolutePath(), targetDir.getAbsolutePath()});
        try {
            int result = process.waitFor();
            if (result != 0) {
                throw new IOException("Error while copying (result " + result + ")");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean removeDir(File dir) {
        return Util.removeDir(dir, true);
    }

    public static boolean removeDir(File dir, boolean printErrorMessages) {
        boolean deleted;
        File[] files;
        if (!dir.exists()) {
            return true;
        }
        boolean result = true;
        if (!Files.isSymbolicLink(dir.toPath()) && (files = dir.listFiles()) != null) {
            for (File child : files) {
                if (child.isFile()) {
                    boolean deleted2 = child.delete();
                    if (!deleted2 && printErrorMessages) {
                        System.err.println("Could not delete " + child.getAbsolutePath());
                    }
                    result &= deleted2;
                    continue;
                }
                if (!child.isDirectory()) continue;
                result &= Util.removeDir(child, printErrorMessages);
            }
        }
        if (!(deleted = dir.delete()) && printErrorMessages) {
            System.err.println("Could not delete " + dir.getAbsolutePath());
        }
        return result &= deleted;
    }

    public static long calcSize(File file) {
        return file.isFile() ? file.length() : Util.calcFolderSize(file);
    }

    public static long calcFolderSize(File folder) {
        long size = 0L;
        String[] filenames = folder.list();
        if (filenames == null) {
            return -1L;
        }
        for (String file : filenames) {
            if (file.equals(".") || file.equals("..") || file.equals(".DS_Store")) continue;
            File fella = new File(folder, file);
            if (fella.isDirectory()) {
                long subfolderSize = Util.calcFolderSize(fella);
                if (subfolderSize == -1L) {
                    return -1L;
                }
                size += subfolderSize;
                continue;
            }
            size += fella.length();
        }
        return size;
    }

    public static String[] listFiles(File folder, boolean relative) {
        return Util.listFiles(folder, relative, null);
    }

    public static String[] listFiles(File folder, boolean relative, String extension) {
        if (extension != null && !((String)extension).startsWith(".")) {
            extension = "." + (String)extension;
        }
        StringList list = new StringList();
        Util.listFilesImpl(folder, relative, (String)extension, list);
        if (relative) {
            String[] outgoing = new String[list.size()];
            int prefixLength = folder.getAbsolutePath().length() + 1;
            for (int i = 0; i < outgoing.length; ++i) {
                outgoing[i] = list.get(i).substring(prefixLength);
            }
            return outgoing;
        }
        return list.toArray();
    }

    static void listFilesImpl(File folder, boolean relative, String extension, StringList list) {
        File[] items = folder.listFiles();
        if (items != null) {
            for (File item : items) {
                String name = item.getName();
                if (name.charAt(0) == '.') continue;
                if (item.isDirectory()) {
                    Util.listFilesImpl(item, relative, extension, list);
                    continue;
                }
                if (extension != null && !name.endsWith(extension)) continue;
                list.append(item.getAbsolutePath());
            }
        }
    }

    public static File[] listJarFiles(File folder) {
        return folder.listFiles((dir, name) -> !name.startsWith(".") && (name.toLowerCase().endsWith(".jar") || name.toLowerCase().endsWith(".zip")));
    }

    public static String contentsToClassPath(File folder) {
        if (folder == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String sep = System.getProperty("path.separator");
        try {
            String[] list;
            Object path = folder.getCanonicalPath();
            if (!((String)path).endsWith(File.separator)) {
                path = (String)path + File.separator;
            }
            if ((list = folder.list()) != null) {
                for (String item : list) {
                    if (item.startsWith(".") || !item.toLowerCase().endsWith(".jar") && !item.toLowerCase().endsWith(".zip")) continue;
                    sb.append(sep);
                    sb.append((String)path);
                    sb.append(item);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static StringList packageListFromClassPath(String path) {
        String[] pieces;
        StringList list = new StringList();
        for (String piece : pieces = PApplet.split((String)path, (char)File.pathSeparatorChar)) {
            if (piece.length() == 0) continue;
            if (piece.toLowerCase().endsWith(".jar") || piece.toLowerCase().endsWith(".zip")) {
                Util.packageListFromZip(piece, list);
                continue;
            }
            File dir = new File(piece);
            if (!dir.exists() || !dir.isDirectory()) continue;
            Util.packageListFromFolder(dir, null, list);
        }
        StringList outgoing = new StringList(list.size());
        for (String item : list) {
            outgoing.append(item.replace('/', '.'));
        }
        return outgoing;
    }

    private static void packageListFromZip(String filename, StringList list) {
        try {
            ZipFile file = new ZipFile(filename);
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                int slash;
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(".class") || name.contains("META-INF/") || (slash = name.lastIndexOf(47)) == -1) continue;
                String packageName = name.substring(0, slash);
                list.appendUnique(packageName);
            }
            file.close();
        }
        catch (IOException e) {
            System.err.println("Ignoring " + filename + " (" + e.getMessage() + ")");
        }
    }

    private static void packageListFromFolder(File dir, String sofar, StringList list) {
        boolean foundClass = false;
        String[] filenames = dir.list();
        if (filenames != null) {
            for (String filename : filenames) {
                if (filename.equals(".") || filename.equals("..")) continue;
                File sub = new File(dir, filename);
                if (sub.isDirectory()) {
                    String nowfar = sofar == null ? filename : sofar + "." + filename;
                    Util.packageListFromFolder(sub, nowfar, list);
                    continue;
                }
                if (foundClass || !filename.endsWith(".class")) continue;
                list.appendUnique(sofar);
                foundClass = true;
            }
        } else {
            System.err.println("Could not read " + dir);
        }
    }

    public static void unzip(File zipFile, File dest) throws IOException {
        ZipEntry entry;
        FileInputStream fis = new FileInputStream(zipFile);
        CheckedInputStream checksum = new CheckedInputStream(fis, new Adler32());
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(checksum));
        while ((entry = zis.getNextEntry()) != null) {
            String name = entry.getName();
            if (name.startsWith("__MACOSX")) continue;
            File currentFile = new File(dest, name);
            if (entry.isDirectory()) {
                currentFile.mkdirs();
                continue;
            }
            File parentDir = currentFile.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            currentFile.createNewFile();
            Util.unzipEntry(zis, currentFile);
        }
    }

    protected static void unzipEntry(ZipInputStream zin, File f) throws IOException {
        int len;
        FileOutputStream out = new FileOutputStream(f);
        byte[] b = new byte[512];
        while ((len = zin.read(b)) != -1) {
            out.write(b, 0, len);
        }
        out.flush();
        out.close();
    }

    public static byte[] gzipEncode(byte[] what) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream output = new GZIPOutputStream(baos);
        PApplet.saveStream((OutputStream)output, (InputStream)new ByteArrayInputStream(what));
        output.close();
        return baos.toByteArray();
    }

    public static boolean containsNonASCII(String what) {
        for (char c : what.toCharArray()) {
            if (c >= ' ' && c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    public static String sanitizeHtmlTags(String str) {
        return str.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String markDownLinksToHtml(String str) {
        Pattern p = Pattern.compile("\\[(.*?)]\\((.*?)\\)");
        Matcher m = p.matcher(str);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while (m.find(start)) {
            sb.append(str, start, m.start());
            String text = m.group(1);
            String url = m.group(2);
            sb.append("<a href=\"");
            sb.append(url);
            sb.append("\">");
            sb.append(text);
            sb.append("</a>");
            start = m.end();
        }
        sb.append(str.substring(start));
        return sb.toString();
    }

    public static String removeMarkDownLinks(String str) {
        StringBuilder name = new StringBuilder();
        if (str != null) {
            int parentheses = 0;
            for (char c : str.toCharArray()) {
                if (c == '[' || c == ']') continue;
                if (c == '(') {
                    ++parentheses;
                    continue;
                }
                if (c == ')') {
                    --parentheses;
                    continue;
                }
                if (parentheses != 0) continue;
                name.append(c);
            }
        }
        return name.toString();
    }
}

