/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JProgressBar;

public class ContribProgress {
    private static final int UNKNOWN = -1;
    private final JProgressBar progressBar;
    private boolean canceled = false;
    private Exception exception;

    public ContribProgress(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public void startTask(String name) {
        this.startTask(name, -1);
    }

    public void startTask(String name, int maxValue) {
        if (this.progressBar != null) {
            this.progressBar.setString(name);
            this.progressBar.setIndeterminate(maxValue == -1);
            this.progressBar.setMaximum(maxValue);
        }
    }

    public void setProgress(int value) {
        if (this.progressBar != null) {
            this.progressBar.setValue(value);
        }
    }

    public final void finished() {
        try {
            EventQueue.invokeAndWait(this::finishedAction);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            cause.printStackTrace();
        }
    }

    public void finishedAction() {
    }

    public final void cancel() {
        this.canceled = true;
        try {
            EventQueue.invokeAndWait(this::cancelAction);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            cause.printStackTrace();
        }
    }

    public void cancelAction() {
    }

    public boolean notCanceled() {
        return !this.canceled;
    }

    public void setException(Exception e) {
        this.exception = e;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isException() {
        return this.exception != null;
    }
}

