/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import processing.app.Base;
import processing.app.UpdateCheck;
import processing.app.Util;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.ContribProgress;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ListPanel;
import processing.core.PApplet;
import processing.data.StringDict;
import processing.data.StringList;

public class ContributionListing {
    static volatile ContributionListing singleInstance;
    static final String LISTING_URL = "https://download.processing.org/contribs";
    static final String LOCAL_FILENAME = "contribs.txt";
    private File listingFile;
    private boolean listDownloaded;
    private final ReentrantLock downloadingLock = new ReentrantLock();
    final Set<AvailableContribution> availableContribs;
    private final Map<String, Contribution> libraryExports;
    private final Set<Contribution> allContribs;
    Set<ListPanel> listPanels = new HashSet<ListPanel>();

    private ContributionListing() {
        this.availableContribs = new HashSet<AvailableContribution>();
        this.libraryExports = new HashMap<String, Contribution>();
        this.allContribs = ConcurrentHashMap.newKeySet();
        this.listingFile = Base.getSettingsFile(LOCAL_FILENAME);
        if (this.listingFile.exists()) {
            EventQueue.invokeLater(() -> this.loadAvailableList(this.listingFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContributionListing getInstance() {
        if (singleInstance != null) return singleInstance;
        Class<ContributionListing> clazz = ContributionListing.class;
        synchronized (ContributionListing.class) {
            if (singleInstance != null) return singleInstance;
            singleInstance = new ContributionListing();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleInstance;
        }
    }

    protected static Set<Contribution> getAllContribs() {
        return ContributionListing.getInstance().allContribs;
    }

    protected static void updateInstalled(Set<Contribution> installedContribs) {
        ContributionListing listing = ContributionListing.getInstance();
        for (Contribution installed : installedContribs) {
            Contribution listed = listing.findContribution(installed);
            if (listed != null) {
                if (listed == installed) continue;
                listing.replaceContribution(listed, installed);
                continue;
            }
            listing.addContribution(installed);
        }
        listing.updateTableModels();
    }

    private Contribution findContribution(Contribution contribution) {
        for (Contribution c : this.allContribs) {
            if (!c.getName().equals(contribution.getName()) || c.getType() != contribution.getType()) continue;
            return c;
        }
        return null;
    }

    protected void replaceContribution(Contribution oldContrib, Contribution newContrib) {
        if (oldContrib != null && newContrib != null) {
            this.allContribs.remove(oldContrib);
            this.allContribs.add(newContrib);
            for (ListPanel listener : this.listPanels) {
                listener.contributionChanged(oldContrib, newContrib);
            }
        }
    }

    private void addContribution(Contribution contribution) {
        this.allContribs.add(contribution);
        for (ListPanel listener : this.listPanels) {
            listener.contributionAdded(contribution);
        }
    }

    protected void removeContribution(Contribution contribution) {
        this.allContribs.remove(contribution);
        for (ListPanel listener : this.listPanels) {
            listener.contributionRemoved(contribution);
        }
    }

    protected void updateTableModels() {
        for (ListPanel listener : this.listPanels) {
            listener.updateModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AvailableContribution findAvailableContribution(Contribution contrib) {
        Set<AvailableContribution> set = this.availableContribs;
        synchronized (set) {
            for (AvailableContribution advertised : this.availableContribs) {
                if (advertised.getType() != contrib.getType() || !advertised.getName().equals(contrib.getName())) continue;
                return advertised;
            }
        }
        return null;
    }

    protected void addListPanel(ListPanel listener) {
        this.listPanels.add(listener);
    }

    public void downloadAvailableList(Base base, ContribProgress progress) {
        new Thread(() -> {
            this.downloadingLock.lock();
            try {
                URL url = new URL(LISTING_URL);
                File tempContribFile = Base.getSettingsFile("contribs.tmp");
                if (tempContribFile.exists() && !tempContribFile.canWrite() && !tempContribFile.setWritable(true, false)) {
                    System.err.println("Could not set " + tempContribFile + " writable");
                }
                ContributionManager.download(url, this.makeContribsBlob(base), tempContribFile, progress);
                if (progress.notCanceled() && !progress.isException()) {
                    if (this.listingFile.exists()) {
                        this.listingFile.delete();
                    }
                    if (tempContribFile.renameTo(this.listingFile)) {
                        this.listDownloaded = true;
                        try {
                            EventQueue.invokeAndWait(() -> {
                                this.loadAvailableList(this.listingFile);
                                base.tallyUpdatesAvailable();
                            });
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            cause.printStackTrace();
                        }
                    }
                }
            }
            catch (MalformedURLException e) {
                progress.setException(e);
                progress.finished();
            }
            finally {
                this.downloadingLock.unlock();
            }
        }, "Contribution List Downloader").start();
    }

    private void loadAvailableList(File file) {
        this.listingFile = file;
        this.availableContribs.clear();
        this.availableContribs.addAll(ContributionListing.parseContribList(this.listingFile));
        this.libraryExports.clear();
        for (Contribution contribution : this.availableContribs) {
            StringList exports;
            this.addContribution(contribution);
            if (contribution.getType() != ContributionType.LIBRARY || (exports = contribution.getExports()) == null) continue;
            for (String export : exports) {
                this.libraryExports.put(export, contribution);
            }
        }
        this.updateTableModels();
    }

    private byte[] makeContribsBlob(Base base) {
        Set<Contribution> contribs = base.getInstalledContribs();
        StringList entries = new StringList();
        for (Contribution c : contribs) {
            String entry = c.getTypeName() + "=" + PApplet.urlEncode((String)String.format("name=%s\nurl=%s\nrevision=%d\nversion=%s", c.getName(), c.getUrl(), c.getVersion(), c.getBenignVersion()));
            entries.append(entry);
        }
        String joined = "id=" + UpdateCheck.getUpdateID() + "&" + entries.join("&");
        return joined.getBytes();
    }

    public boolean hasUpdates(Contribution contrib) {
        if (contrib.isInstalled()) {
            AvailableContribution available = this.findAvailableContribution(contrib);
            return available != null && available.getVersion() > contrib.getVersion() && available.isCompatible();
        }
        return false;
    }

    protected String getLatestPrettyVersion(Contribution contrib) {
        AvailableContribution newestContrib = this.findAvailableContribution(contrib);
        if (newestContrib != null) {
            return newestContrib.getPrettyVersion();
        }
        return null;
    }

    private static List<AvailableContribution> parseContribList(File file) {
        String[] lines;
        ArrayList<AvailableContribution> outgoing = new ArrayList<AvailableContribution>();
        if (file != null && file.exists() && (lines = PApplet.loadStrings((File)file)) != null) {
            int start = 0;
            while (start < lines.length) {
                int end2;
                String type = lines[start];
                ContributionType contribType = ContributionType.fromName(type);
                if (contribType == null) {
                    System.err.println("Error in contribution listing file on line " + (start + 1));
                    for (end2 = ++start; end2 < lines.length && !lines[end2].trim().isEmpty(); ++end2) {
                    }
                    start = end2 + 1;
                    continue;
                }
                for (end2 = ++start; end2 < lines.length && !lines[end2].trim().isEmpty(); ++end2) {
                }
                String[] contribLines = PApplet.subset((String[])lines, (int)start, (int)(end2 - start));
                StringDict contribParams = Util.readSettings(file.getName(), contribLines, false);
                outgoing.add(new AvailableContribution(contribType, contribParams));
                start = end2 + 1;
            }
        }
        return outgoing;
    }

    public Map<String, Contribution> getLibraryExports() {
        return this.libraryExports;
    }
}

