/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import processing.app.Base;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Util;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.ContribProgress;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionType;
import processing.app.contrib.LocalContribution;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.StatusPanel;
import processing.app.ui.Editor;
import processing.core.PApplet;
import processing.data.StringDict;

public class ContributionManager {
    static ManagerFrame managerFrame;
    static ContributionListing contribListing;

    static boolean download(URL source, byte[] post, File dest, ContribProgress progress) {
        boolean success;
        block11: {
            success = false;
            try {
                int response;
                HttpURLConnection conn = (HttpURLConnection)source.openConnection();
                HttpURLConnection.setFollowRedirects(true);
                conn.setConnectTimeout(15000);
                conn.setReadTimeout(60000);
                if (post == null) {
                    conn.setRequestMethod("GET");
                    conn.connect();
                } else {
                    post = Util.gzipEncode(post);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    conn.setRequestProperty("Content-Encoding", "gzip");
                    conn.setRequestProperty("Content-Length", String.valueOf(post.length));
                    conn.setUseCaches(false);
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.getOutputStream().write(post);
                }
                if (progress != null) {
                    int fileSize = conn.getContentLength();
                    progress.startTask(Language.text("contrib.progress.downloading"), fileSize);
                }
                if ((response = conn.getResponseCode()) >= 300 && response < 400) {
                    String newLocation = conn.getHeaderField("Location");
                    return ContributionManager.download(new URL(newLocation), post, dest, progress);
                }
                InputStream in = conn.getInputStream();
                FileOutputStream out = new FileOutputStream(dest);
                byte[] b = new byte[8192];
                if (progress != null) {
                    int amount;
                    int total = 0;
                    while (progress.notCanceled() && (amount = in.read(b)) != -1) {
                        out.write(b, 0, amount);
                        progress.setProgress(total += amount);
                    }
                } else {
                    int amount;
                    while ((amount = in.read(b)) != -1) {
                        out.write(b, 0, amount);
                    }
                }
                out.flush();
                out.close();
                success = true;
            }
            catch (IOException ioe) {
                if (progress == null) break block11;
                progress.setException(ioe);
                progress.cancel();
            }
        }
        if (progress != null) {
            progress.finished();
        }
        return success;
    }

    static void downloadAndInstall(Base base, URL url, AvailableContribution available, ContribProgress downloadProgress, ContribProgress installProgress, StatusPanel status) {
        new Thread(() -> {
            String filename = url.getFile();
            filename = filename.substring(filename.lastIndexOf(47) + 1);
            try {
                File contribZip = File.createTempFile("download", filename);
                contribZip.setWritable(true);
                try {
                    ContributionManager.download(url, null, contribZip, downloadProgress);
                    if (downloadProgress.notCanceled() && !downloadProgress.isException()) {
                        installProgress.startTask(Language.text("contrib.progress.installing"));
                        LocalContribution installed = available.install(base, contribZip, status);
                        if (installed != null) {
                            try {
                                EventQueue.invokeAndWait(() -> {
                                    contribListing.replaceContribution(available, installed);
                                    contribListing.updateTableModels();
                                    base.refreshContribs(installed.getType());
                                    base.tallyUpdatesAvailable();
                                });
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                throw (Exception)e.getCause();
                            }
                        }
                        installProgress.finished();
                    } else {
                        Exception exception = downloadProgress.getException();
                        if (exception instanceof SocketTimeoutException) {
                            status.setErrorMessage(Language.interpolate("contrib.errors.contrib_download.timeout", available.getName()));
                        } else if (exception != null) {
                            status.setErrorMessage(Language.interpolate("contrib.errors.download_and_install", available.getName()));
                            exception.printStackTrace();
                        }
                    }
                    contribZip.delete();
                }
                catch (Exception e) {
                    Object msg = null;
                    if (e instanceof RuntimeException) {
                        Throwable cause = e.getCause();
                        if (cause instanceof NoClassDefFoundError || cause instanceof NoSuchMethodError) {
                            msg = "This item is not compatible with this version of Processing";
                        } else if (cause instanceof UnsupportedClassVersionError) {
                            msg = "This needs to be recompiled for Java " + PApplet.javaPlatform;
                        }
                    }
                    if (msg == null) {
                        msg = Language.interpolate("contrib.errors.download_and_install", available.getName());
                        e.printStackTrace();
                    }
                    status.setErrorMessage((String)msg);
                    downloadProgress.cancel();
                    installProgress.cancel();
                }
            }
            catch (IOException e) {
                status.setErrorMessage(Language.text("contrib.errors.temporary_directory"));
                downloadProgress.cancel();
                installProgress.cancel();
            }
        }, "Contribution Installer").start();
    }

    static void downloadAndInstallOnStartup(Base base, URL url, AvailableContribution available) {
        new Thread(() -> {
            String filename = url.getFile();
            filename = filename.substring(filename.lastIndexOf(47) + 1);
            try {
                File contribZip = File.createTempFile("download", filename);
                try {
                    ContributionManager.download(url, null, contribZip, null);
                    LocalContribution installed = available.install(base, contribZip, null);
                    if (installed != null) {
                        try {
                            EventQueue.invokeAndWait(() -> {
                                contribListing.replaceContribution(available, installed);
                                contribListing.updateTableModels();
                                base.refreshContribs(installed.getType());
                                base.tallyUpdatesAvailable();
                            });
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            cause.printStackTrace();
                        }
                    }
                    if (contribZip.exists() && !contribZip.delete()) {
                        System.err.println("Could not delete " + contribZip);
                    }
                    ContributionManager.handleUpdateFailedMarkers(available);
                }
                catch (Exception e) {
                    String arg = "contrib.startup.errors.download_install";
                    System.err.println(Language.interpolate(arg, available.getName()));
                }
            }
            catch (IOException e) {
                String arg = "contrib.startup.errors.temp_dir";
                System.err.println(Language.interpolate(arg, available.getName()));
            }
        }, "Contribution Installer").start();
    }

    private static void handleUpdateFailedMarkers(AvailableContribution c) {
        File[] folderList;
        File typeFolder = c.getType().getSketchbookFolder();
        if (typeFolder != null && (folderList = typeFolder.listFiles()) != null) {
            for (File contribDir : folderList) {
                StringDict props;
                File propsFile;
                if (!contribDir.isDirectory() || !(propsFile = new File(contribDir, c.getType() + ".properties")).exists() || (props = Util.readSettings(propsFile, false)) == null || !c.getName().equals(props.get("name"))) continue;
                return;
            }
        }
        try {
            new File(typeFolder, c.getName()).createNewFile();
        }
        catch (IOException e) {
            String arg = "contrib.startup.errors.new_marker";
            System.err.println(Language.interpolate(arg, c.getName()));
        }
    }

    public static void downloadAndInstallOnImport(Base base, List<AvailableContribution> list) {
        Editor editor = base.getActiveEditor();
        editor.getTextArea().setEditable(false);
        ArrayList<String> installedLibList = new ArrayList<String>();
        boolean prevDone = false;
        for (AvailableContribution available : list) {
            if (available.getType() != ContributionType.LIBRARY) continue;
            try {
                URL url = new URL(available.link);
                String filename = url.getFile();
                filename = filename.substring(filename.lastIndexOf(47) + 1);
                try {
                    String arg;
                    File contribZip = File.createTempFile("download", filename);
                    contribZip.setWritable(true);
                    try {
                        String statusMsg = editor.getStatusMessage();
                        if (prevDone) {
                            String status = statusMsg + " " + Language.interpolate("contrib.import.progress.download", available.name);
                            editor.statusNotice(status);
                        } else {
                            arg = "contrib.import.progress.download";
                            String status = Language.interpolate(arg, available.name);
                            editor.statusNotice(status);
                        }
                        prevDone = false;
                        ContributionManager.download(url, null, contribZip, null);
                        arg = "contrib.import.progress.install";
                        editor.statusNotice(Language.interpolate(arg, available.name));
                        LocalContribution installed = available.install(base, contribZip, null);
                        if (installed != null) {
                            try {
                                EventQueue.invokeAndWait(() -> {
                                    contribListing.replaceContribution(available, installed);
                                    contribListing.updateTableModels();
                                    base.refreshContribs(installed.getType());
                                    base.tallyUpdatesAvailable();
                                });
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof RuntimeException) {
                                    throw (RuntimeException)cause;
                                }
                                cause.printStackTrace();
                            }
                        }
                        contribZip.delete();
                        installedLibList.add(available.name);
                        prevDone = true;
                        arg = "contrib.import.progress.done";
                        editor.statusNotice(Language.interpolate(arg, available.name));
                    }
                    catch (Exception e) {
                        arg = "contrib.startup.errors.download_install";
                        System.err.println(Language.interpolate(arg, available.getName()));
                    }
                }
                catch (IOException e) {
                    String arg = "contrib.startup.errors.temp_dir";
                    System.err.println(Language.interpolate(arg, available.getName()));
                }
            }
            catch (MalformedURLException e1) {
                System.err.println(Language.interpolate("contrib.import.errors.link", available.getName()));
            }
        }
        editor.getTextArea().setEditable(true);
        editor.statusEmpty();
        System.out.println(Language.text("contrib.import.progress.final_list"));
        for (String l : installedLibList) {
            System.out.println("  * " + l);
        }
    }

    public static File getUniqueName(File parentFolder, String fileName) {
        Object folderName;
        File backupFolderForLib;
        int i = 1;
        do {
            folderName = fileName;
            if (i >= 2) {
                folderName = (String)folderName + "(" + i + ")";
            }
            ++i;
        } while ((backupFolderForLib = new File(parentFolder, (String)folderName)).exists());
        return backupFolderForLib;
    }

    public static String getFileName(File libFile) {
        String path = libFile.getPath();
        int lastSeparator = path.lastIndexOf(File.separatorChar);
        String fileName = lastSeparator != -1 ? path.substring(lastSeparator + 1) : path;
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot != -1) {
            return fileName.substring(0, lastDot);
        }
        return fileName;
    }

    private static void cleanup(Base base) throws Exception {
        ContributionManager.deleteTemp(Base.getSketchbookModesFolder());
        ContributionManager.deleteTemp(Base.getSketchbookToolsFolder());
        ContributionManager.deleteFlagged(Base.getSketchbookLibrariesFolder());
        ContributionManager.deleteFlagged(Base.getSketchbookModesFolder());
        ContributionManager.deleteFlagged(Base.getSketchbookToolsFolder());
        ContributionManager.installPreviouslyFailed(base, Base.getSketchbookModesFolder());
        ContributionManager.updateFlagged(base, Base.getSketchbookModesFolder());
        ContributionManager.updateFlagged(base, Base.getSketchbookToolsFolder());
    }

    private static void deleteTemp(File root) {
        String pattern = root.getName().substring(0, 4) + "\\d*tmp";
        File[] possible = root.listFiles();
        if (possible != null) {
            for (File f : possible) {
                if (!f.getName().matches(pattern)) continue;
                try {
                    Platform.deleteFile(f);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void deleteFlagged(File root) {
        File[] markedForDeletion = root.listFiles(folder -> folder.isDirectory() && LocalContribution.isDeletionFlagged(folder));
        if (markedForDeletion != null) {
            for (File folder2 : markedForDeletion) {
                try {
                    Platform.deleteFile(folder2);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void installPreviouslyFailed(Base base, File root) throws Exception {
        File[] installList = root.listFiles(File::isFile);
        if (installList != null) {
            boolean found = false;
            for (File file : installList) {
                for (AvailableContribution available : ContributionManager.contribListing.availableContribs) {
                    if (!file.getName().equals(available.getName())) continue;
                    file.delete();
                    ContributionManager.installOnStartUp(base, available);
                    EventQueue.invokeAndWait(() -> contribListing.replaceContribution(available, available));
                    found = true;
                }
            }
            if (found) {
                contribListing.updateTableModels();
            }
        } else {
            System.err.println("Could not read " + root);
        }
    }

    private static void updateFlagged(Base base, File root) throws Exception {
        if (!root.exists()) {
            return;
        }
        if (!root.canRead() || !root.canWrite()) {
            if (Platform.isMacOS()) {
                Messages.showError("Cannot access sketchbook", "There is a problem with the \u201cpermissions\u201d for the sketchbook folder.\nProcessing needs access to the Documents folder to save your work.\nUsually this happens after you click \u201cDon't Allow\u201d when macOS asks\nfor access to your Documents folder. To fix:\n\n1. Quit Processing\n2. Open Applications \u2192 Utilities \u2192 Terminal\n3. Type \u201ctccutil reset All org.processing.four\u201d and press return\n4. Restart Processing, and when prompted for access, click \u201cOK\u201d\n\nIf that's not the problem, the forum is a good place to get help:\nhttps://discourse.processing.org\n", null);
            } else {
                throw new Exception("Please fix read/write permissions for " + root);
            }
        }
        File[] markedForUpdate = root.listFiles(folder -> folder.isDirectory() && LocalContribution.isUpdateFlagged(folder));
        ArrayList<String> updateContribsNames = new ArrayList<String>();
        LinkedList<AvailableContribution> updateContribsList = new LinkedList<AvailableContribution>();
        String contribType = root.getName().substring(root.getName().lastIndexOf(47) + 1);
        String propFileName = null;
        if (contribType.equalsIgnoreCase("tools")) {
            propFileName = "tool.properties";
        } else if (contribType.equalsIgnoreCase("modes")) {
            propFileName = "mode.properties";
        }
        if (markedForUpdate != null) {
            for (File folder2 : markedForUpdate) {
                StringDict props = Util.readSettings(new File(folder2, propFileName), false);
                if (props == null) continue;
                String name = props.get("name", null);
                if (name != null) {
                    updateContribsNames.add(name);
                }
                try {
                    Platform.deleteFile(folder2);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (AvailableContribution contrib : ContributionManager.contribListing.availableContribs) {
            if (!updateContribsNames.contains(contrib.getName())) continue;
            updateContribsList.add(contrib);
        }
        for (AvailableContribution contrib : updateContribsList) {
            ContributionManager.installOnStartUp(base, contrib);
            contribListing.replaceContribution(contrib, contrib);
        }
        if (!updateContribsList.isEmpty()) {
            contribListing.updateTableModels();
        }
    }

    private static void installOnStartUp(Base base, AvailableContribution availableContrib) {
        if (availableContrib.link == null) {
            Messages.showWarning(Language.interpolate("contrib.errors.update_on_restart_failed", availableContrib.getName()), Language.text("contrib.missing_link"));
        } else {
            try {
                URL downloadUrl = new URL(availableContrib.link);
                ContributionManager.downloadAndInstallOnStartup(base, downloadUrl, availableContrib);
            }
            catch (MalformedURLException e) {
                Messages.showWarning(Language.interpolate("contrib.errors.update_on_restart_failed", availableContrib.getName()), Language.text("contrib.errors.malformed_url"), e);
            }
        }
    }

    public static void init(Base base) throws Exception {
        contribListing = ContributionListing.getInstance();
        managerFrame = new ManagerFrame(base);
        ContributionManager.cleanup(base);
    }

    public static void updateTheme() {
        if (managerFrame != null) {
            managerFrame.updateTheme();
        }
    }

    public static void openLibraries() {
        managerFrame.showFrame(ContributionType.LIBRARY);
    }

    public static void openModes() {
        managerFrame.showFrame(ContributionType.MODE);
    }

    public static void openTools() {
        managerFrame.showFrame(ContributionType.TOOL);
    }

    public static void openExamples() {
        managerFrame.showFrame(ContributionType.EXAMPLES);
    }

    public static void openUpdates() {
        managerFrame.showFrame(null);
    }
}

